//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLYPH_TEXT_NODE_CACHE_H)
    #define CANDERA_GLYPH_TEXT_NODE_CACHE_H

#include <Candera/Engine2D/Core/TextNode2D.h>
#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRenderer.h>
#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRendererTools.h>
#include <Candera/Engine2D/Core/TextNodeRenderer/SurfaceTextRenderContext.h>

namespace Candera {
    namespace Internal {
        class GlyphTextNodeRendererWrapper;
    }
    template <typename TextRendererContext>
    class GlyphByGlyphTextNodeRenderer : public TextNodeRenderer
    {
        FEATSTD_TYPEDEF_BASE(Candera::TextNodeRenderer);
        friend class Candera::Internal::GlyphTextNodeRendererWrapper;
    public:
        //Constructor
        CANDERA_DEPRECATED_3_3_0(
        "Please use GetInstance() to get the GlyphTextNodeRenderer instance",
        GlyphByGlyphTextNodeRenderer());

        /**
         *  Gets the instance of this class.
         *  @return A reference to the instance of this class.
         */
        static GlyphByGlyphTextNodeRenderer& GetInstance();

        // overrides TextNodeRenderer::Clone
        virtual GlyphByGlyphTextNodeRenderer* Clone() const override;

        // overrides TextNodeRenderer::Dispose
        virtual void Dispose() override {};

        // overrides TextNodeRenderer::GetMeasureReferenceContext
        virtual const TextRendering::TextRenderContext* GetMeasureReferenceContext() const { return 0; }

        // overrides TextNodeRenderer::PreRender
        virtual bool PreRenderInternal(const TextNode2D& /*textNode*/) { return false; }

        // overrides TextNodeRenderer::Render
        virtual void RenderInternal(TextNode2D& textNode, RenderTarget2D* renderTarget, const Matrix3x2& localTransform);

#ifdef CANDERA_DEPRECATED_3_3_0
        /**
        * Destructor
        */
        virtual ~GlyphByGlyphTextNodeRenderer() {};
#else
#error  Make destructor private.
#endif
        FEATSTD_RTTI_TEMPLATE_DEFINITION(Candera::GlyphByGlyphTextNodeRenderer, TextNodeRenderer);

    private:
        GlyphByGlyphTextNodeRenderer(Int) {}

        FEATSTD_MAKE_CLASS_UNCOPYABLE(GlyphByGlyphTextNodeRenderer);
    };

    typedef GlyphByGlyphTextNodeRenderer<TextNodeTextRenderContext>
        GlyphTextNodeRenderer;
    typedef GlyphByGlyphTextNodeRenderer<GlyphCacheTextNodeTextRenderContext>
        GlyphCacheTextNodeRenderer;

    /*
    *    GlyphTextNodeRendererWrapper
    *    Wrapper class to allow specialization for
    *    GlyphByGlyphTextNodeRenderer::GetInstance and to provide the
    *    static instantiation of the GlyphTextNodeRenderer
    *    in the GlypTextNodeRender.cpp file.
    */
    namespace Internal {
        class GlyphTextNodeRendererWrapper
        {
        public:
            template <typename T>
            static T& GetInstance();
        };
        template<>
        GlyphTextNodeRenderer& GlyphTextNodeRendererWrapper::
            GetInstance<GlyphTextNodeRenderer>();
        template<>
        GlyphCacheTextNodeRenderer& GlyphTextNodeRendererWrapper::
            GetInstance<GlyphCacheTextNodeRenderer>();
    }

    template<typename TextRendererContext>
    GlyphByGlyphTextNodeRenderer<TextRendererContext>::GlyphByGlyphTextNodeRenderer()
    {
    }

    template <typename TextRendererContext>
    GlyphByGlyphTextNodeRenderer<TextRendererContext>& GlyphByGlyphTextNodeRenderer<TextRendererContext>::GetInstance()
    {
        return Candera::Internal::GlyphTextNodeRendererWrapper::
            GetInstance<GlyphByGlyphTextNodeRenderer>();
    }

    template <typename TextRendererContext>
    GlyphByGlyphTextNodeRenderer<TextRendererContext>* GlyphByGlyphTextNodeRenderer<TextRendererContext>::Clone() const
    {
        return &(GetInstance());
    }

    template <typename TextRendererContext>
    void GlyphByGlyphTextNodeRenderer<TextRendererContext>::RenderInternal(TextNode2D& textNode, RenderTarget2D* renderTarget, const Matrix3x2& localTransform)
    {
        GlyphByGlyphTextNodeTextRenderContext<TextRendererContext> context(textNode, renderTarget, localTransform);
        static_cast<void>(Candera::Internal::TextNodeRendererTools::RenderText(context, textNode, Candera::TextRendering::TextCoordinate()));
    }
}   // namespace Candera

#endif  // CANDERA_GLYPH_TEXT_NODE_CACHE_H
