//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLYPH_IMAGE_SOURCE_TEXT_RENDER_CONTEXT_H)
#define CANDERA_GLYPH_IMAGE_SOURCE_TEXT_RENDER_CONTEXT_H

#include <CanderaPlatform/Device/Common/Base/ImageSource2D.h>

namespace Candera {
    namespace TextRendering {
        struct GlyphBitmap;
    }

    namespace Internal {
        class GlyphImageSource2D : public ImageSource2D
        {
        public:
            GlyphImageSource2D();
            virtual ~GlyphImageSource2D() override;
            virtual SurfaceHandle GetSurfaceHandle() const override final { return m_surfaceHandle; }
            void SetBitmap(const TextRendering::GlyphBitmap& bitmap);
            bool HasBitmap() const;
            virtual Int GetHeight() const override final { return m_height; }
            virtual Int GetWidth() const override final { return m_width; }
            virtual void Sync() override final {}
            virtual void WaitSync() override final {}

        private:
            SurfaceHandle m_surfaceHandle;
            UInt16 m_width;
            UInt16 m_height;
        };
    }

}   // namespace Candera

#endif  // CANDERA_GLYPH_IMAGE_SOURCE_TEXT_RENDER_CONTEXT_H
