//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlyphImageSource2D.h"

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera { namespace Internal {

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaEngine2D);

    GlyphImageSource2D::GlyphImageSource2D()
        :m_surfaceHandle(), m_width(0), m_height(0)
    {
    }

    void GlyphImageSource2D::SetBitmap(const TextRendering::GlyphBitmap& bitmap)
    {
        bool isBitmapValid = (bitmap.pixels != 0)
            && (bitmap.width != 0)
            && (bitmap.height != 0);
        if (!isBitmapValid) {
            return;
        }
        bool isCreateBufferRequired = (m_surfaceHandle == 0);
        if (isCreateBufferRequired) {
            if (!RenderDevice2D::CreateSurfaces(1, &m_surfaceHandle)) {
                FEATSTD_LOG_WARN("Fail to create surface handle for glyph!");
                return;
            }
        }

        isCreateBufferRequired = isCreateBufferRequired || (!Internal::RenderDevice2DHelper::HasBuffer(m_surfaceHandle));
        if (isCreateBufferRequired) {
            bool isBufferCreated = RenderDevice2D::CreateBuffer(
                        m_surfaceHandle,
                        bitmap.width,
                        bitmap.height,
                        bitmap.pitch,
                        bitmap.format,
                        bitmap.pixels);
            if (!isBufferCreated) {
                FEATSTD_LOG_WARN("Fail to create surface buffer for for glyph %d!", bitmap.glyphIndex);
                static_cast<void>(RenderDevice2D::DestroySurfaces(1, &m_surfaceHandle));
                m_surfaceHandle = 0;
            }
        }
    }

    GlyphImageSource2D::~GlyphImageSource2D()
    {
        static_cast<void>(RenderDevice2D::DestroySurfaces(1, &m_surfaceHandle));
    }

    bool GlyphImageSource2D::HasBitmap() const
    {
        return (m_surfaceHandle != 0) && Internal::RenderDevice2DHelper::HasBuffer(m_surfaceHandle);
    }

}}   // namespace Candera::Internal
