//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BITMAP_TEXT_NODE_CACHE_H)
    #define CANDERA_BITMAP_TEXT_NODE_CACHE_H

#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRenderer.h>
#include <Candera/Engine2D/Core/BitmapImage2D.h>

namespace Candera {

    class RenderTarget2D;
    class BitmapTextRenderContext;

    /** @addtogroup Core2D
     *  @{
     */
    
    /**
     * BitmapTextNodeRenderer renders the text on a Bitmap object, which it is uploaded to a native surface during
     *  the pre-render phase.
     */
    class BitmapTextNodeRenderer : public TextNodeRenderer
    {
        FEATSTD_TYPEDEF_BASE(Candera::TextNodeRenderer);
    public:        
        CANDERA_DEPRECATED_3_3_0(
            "Please use Create() method to instantiate BitmapTextNodeRenderer",
            BitmapTextNodeRenderer());

#ifdef CANDERA_DEPRECATED_3_3_0
        /**
        * Destructor
        */
        virtual ~BitmapTextNodeRenderer();
#else
#error  Make destructor protected.
#endif

        // overrides TextNodeRenderer::Clone
        virtual BitmapTextNodeRenderer* Clone() const override;

        /**
        *  Creates an instance of this class.
        *  Use Dispose() to delete the instance.
        *  @return A pointer to the created object.
        */
        static BitmapTextNodeRenderer* Create();

        // overrides TextNodeRenderer::Dispose
        virtual void Dispose() override;

        FEATSTD_RTTI_DECLARATION();

   private:
        bool m_mustBeDisposed;
        MemoryManagement::SharedPointer<BitmapImage2D> m_bitmapImage;

        /**
        *  Copy Constructor
        *  Sets m_mustBeDisposed to true
        */
        explicit BitmapTextNodeRenderer(
            const BitmapTextNodeRenderer& bitmapTextNodeRenderer);

        /**
        *  User defined constructor - to be called by Create()
        *  Sets m_mustBeDisposed to true
        */
        explicit BitmapTextNodeRenderer(const Int& dummy);

        // overrides TextNodeRenderer::GetMeasureReferenceContext
        virtual const TextRendering::TextRenderContext* GetMeasureReferenceContext() const override;

        // overrides TextNodeRenderer::PreRender
        virtual bool PreRenderInternal(const TextNode2D& textNode);

        // overrides TextNodeRenderer::Render
        virtual void RenderInternal(
            TextNode2D& textNode, 
            RenderTarget2D* renderTarget, 
            const Matrix3x2& localTransform);

        // overrides TextNodeRenderer::UploadSelf
        virtual bool UploadSelf() override;

        // overrides TextNodeRenderer::UnloadSelf
        virtual bool UnloadSelf() override;
    };

    /** @} */ // end of Core2D

}   // namespace Candera

#endif  // CANDERA_BITMAP_TEXT_NODE_CACHE_H
