//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Scene2D.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
namespace Candera {
    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    Scene2D::Scene2D() :
        Base(),
        m_isLayoutValid(true),
        m_renderOrder(0)
    {
    }

    /******************************************************************************
     *  Copy Constructor
     ******************************************************************************/
    Scene2D::Scene2D(const Scene2D& src) :
        Base(src),
        m_isLayoutValid(src.GetLayoutValid()),
        m_renderOrder(0)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    Scene2D::~Scene2D()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Scene2D* Scene2D::Create()
    {
        return FEATSTD_NEW(Scene2D);
    }

    /******************************************************************************
     *  DisposeSelf
     ******************************************************************************/
    void Scene2D::DisposeSelf()
    {
        FEATSTD_DELETE(this);
    }

    FEATSTD_RTTI_DEFINITION(Scene2D, Group2D)

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Scene2D* Scene2D::Clone() const
    {
        return FEATSTD_NEW(Scene2D)(*this);
    }
    /******************************************************************************
     *  ValidateLayout
     ******************************************************************************/
#if defined(CANDERA_LAYOUT_ENABLED)
    void Scene2D::ValidateLayout()
    {
        if (!GetLayoutValid()) {
             SetLayoutValid(true);
             Layout();
         }
    }
#endif

}   // namespace Candera
