//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_IMAGE_2D_H)
#define CANDERA_IMAGE_2D_H

#include <Candera/Engine2D/Core/2DStringBufferAppenders.h>
#include <Candera/Engine2D/Core/DeviceObject2D.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>

namespace Candera {
/** @addtogroup Core2D
 *  @{
 */

/**
 * @brief  Image2D encapsulates a surface handle which is retrieved when uploading an image.
 *
 *         Image2D can be shared. In this case multiple uploads will be prevented by the DeviceObject interface.
 */
    class Image2D : public DeviceObject2D {
        FEATSTD_TYPEDEF_BASE(DeviceObject2D);

    public:
        virtual ~Image2D() override {}

        /**
         *  Get the attached surface handle.
         *  @return The surface handle to the uploaded data
         */
        virtual SurfaceHandle Get2DSurfaceHandle() const = 0;

        /**
         *  Get the attached surface width.
         *  @return The width of the image
         */
        virtual UInt32 GetWidth() const = 0;

        /**
         *  Get the attached surface height.
         *  @return The height of the image
         */
        virtual UInt32 GetHeight() const = 0;
        
        /**
         *  Retrieve if MipMapping is enabled or not
         *  @return   true, if mipmapping is enabled and mipmap filters are evaluated.
         *  @return   false, if mipmapping is disabled and mipmap filters are ignored.
         */
        virtual bool IsMipMappingEnabled() const { return false; }

        /**
         * Activates the current image to be used as a certain surface type within
         * the provided context.
         * @param context The context in which the image will be bound.
         * @param surfaceType The usage this image will have within the context.
         * @return  True, if activation of the image succeeded, false otherwise.
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual bool Activate(ContextHandle2D context, RenderDevice2D::SurfaceType surfaceType = RenderDevice2D::SourceSurface);
        
        FEATSTD_RTTI_DECLARATION();
    private:

        // Make this class manageable by MemoryManagement::SharedPointer
        CANDERA_SHARED_POINTER_DECLARATION();
    };

 /** @} */ // end of Core2D
}

#endif //CANDERA_IMAGE_2D_H
