//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GROUP2D_H)
    #define CANDERA_GROUP2D_H

#include <Candera/Engine2D/Core/2DStringBufferAppenders.h>
#include <Candera/Engine2D/Core/Node2D.h>

namespace Candera {

/** @addtogroup Core2D
 *  @{
 */

    /**
     * @brief   The class Group2D is a scene graph node that stores a set of nodes as its children.
     *          The parent-child relationship between groups and nodes is bidirectional. Whereas
     *          a group can hold a group of nodes, a node can at most have one parent at a time.
     *          Cycles are prohibited. Changing the groups transformation or alpha value affects
     *          the children nodes of the group.
     */
    class Group2D:  public Node2D {

        FEATSTD_TYPEDEF_BASE(Node2D);

    public:
        /**
         *  Creates an instance of this class.
         *  Use Dispose() to delete the instance and possible children, if any.
         *  @return Pointer to the created object
         */
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1511, Candera::Group2D::Create, CANDERA_LINT_REASON_EXPLICITHIDING)
        static Group2D* Create();

        /**
         *  Destructor.
         */
        virtual ~Group2D() override;

        virtual Group2D* Clone() const override;

        FEATSTD_LINT_NEXT_EXPRESSION(1735, "Virtual function uses same default parameter as abstract base class.")
        virtual void GetComputedBoundingRectangle(Rectangle& boundingRectangle, bool ignoreInvisible = false) const override;

#if defined(CANDERA_LAYOUT_ENABLED)
        virtual void GetComputedLayoutRectangle(Rectangle& rectangle) const override;
#endif

        FEATSTD_RTTI_DECLARATION();

    protected:
        // Explicit protected Constructor and Copy-Constructor, use Create() to create an instance of this object.
        Group2D();
        explicit Group2D(const Group2D& group);
        Group2D& operator = (const Group2D& group);

        virtual void DisposeSelf() override;
    };


 /** @} */ // end of Core2D

}   // namespace Candera

#endif  // CANDERA_GROUP2D_H
