//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_GpuLoadCamera2DRenderStrategy_h
    #define Candera_GpuLoadCamera2DRenderStrategy_h

#include <Candera/Engine2D/Core/Camera2DRenderStrategy.h>
#include <Candera/System/Container/SingleLinkedList.h>
#include <Candera/System/Rtti/Rtti.h>

namespace Candera {

/** @addtogroup Core2D
 *  @{
 */

// Forward declaration.
class Node2D;

/**
 * @brief The GpuLoadCamera2DRenderStrategy is an implementation of the abstract class Camera2DRenderStrategy.
 */
class GpuLoadCamera2DRenderStrategy: public Camera2DRenderStrategy
{
    FEATSTD_TYPEDEF_BASE(Camera2DRenderStrategy);

    public:
        /**
         *  Constructor
         */
        GpuLoadCamera2DRenderStrategy() : m_breakLevel() {}

        /**
         *  Destructor
         */
        virtual ~GpuLoadCamera2DRenderStrategy() override {}

        void SetGpuLoadBreakLevel(UInt8 breakLevel) { m_breakLevel = breakLevel; }
        UInt8 GetGpuLoadBreakLevel() const { return m_breakLevel; }

        FEATSTD_RTTI_DECLARATION();

    protected:
        virtual RenderPassAction GetRenderPassAction(const Node2D* nextNode) override;

    private:
        UInt8 m_breakLevel;
};

/** @} */ // end of Core2D

} // namespace Candera

#endif // Candera_GpuLoadCamera2DRenderStrategy_h
