//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/Engine2D/Core/Camera2DRenderStrategy.h>

namespace Candera {

    FEATSTD_RTTI_BASECLASS_DEFINITION(Camera2DRenderStrategy)

/******************************************************************************
 *  Constructor
 ******************************************************************************/
Camera2DRenderStrategy::Camera2DRenderStrategy() :
    m_isRenderPassCompleted(true),
    m_previousNodeRendered(0)
{
}

/******************************************************************************
 *  IsRenderPassCompleted
 ******************************************************************************/
bool Camera2DRenderStrategy::IsRenderPassCompleted() const
{
    return m_isRenderPassCompleted;
}

/******************************************************************************
 *  SetRenderPassCompleted
 ******************************************************************************/
void Camera2DRenderStrategy::SetRenderPassCompleted(bool complete)
{
    m_isRenderPassCompleted = complete;
}

} // namespace Candera
