//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BreakNodeCamera2DRenderStrategy.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
using namespace Diagnostics;

FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine2D);

FEATSTD_RTTI_DEFINITION(BreakNodeCamera2DRenderStrategy, Camera2DRenderStrategy)

/******************************************************************************
 *  Constructor
 ******************************************************************************/
BreakNodeCamera2DRenderStrategy::BreakNodeCamera2DRenderStrategy() :
    m_isRenderPassResuming(false),
    m_actionOnBreakNode(PauseRenderPass)
{
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
Camera2DRenderStrategy::RenderPassAction BreakNodeCamera2DRenderStrategy::GetRenderPassAction(const Node2D* nextNode)
{
    RenderPassAction renderPassAction = ProceedRenderPass;

    if (m_isRenderPassResuming) {
        m_isRenderPassResuming = false;
    }
    else {
        if (m_breakNodeList.Contains(const_cast<Node2D*>(nextNode))) {
            renderPassAction = m_actionOnBreakNode;
        }
    }

    return renderPassAction;
}

/******************************************************************************
 *  OnRenderPassBegins
 ******************************************************************************/
void BreakNodeCamera2DRenderStrategy::OnRenderPassBegins()
{
    m_isRenderPassResuming = false;
}

/******************************************************************************
 *  OnRenderPassResumes
 ******************************************************************************/
void BreakNodeCamera2DRenderStrategy::OnRenderPassResumes()
{
    m_isRenderPassResuming = true;
}

/******************************************************************************
 *  AddBreakNode
 ******************************************************************************/
void BreakNodeCamera2DRenderStrategy::AddBreakNode(const Node2D* node)
{
    static_cast<void>(m_breakNodeList.Append(const_cast<Node2D*>(node)));
}

/******************************************************************************
 *  RemoveBreakNode
 ******************************************************************************/
void BreakNodeCamera2DRenderStrategy::RemoveBreakNode(const Node2D* node)
{
    static_cast<void>(m_breakNodeList.Remove(const_cast<Node2D*>(node)));
}
} // namespace Candera
