//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXT_NODE_2D_CLONE_STRATEGY_H)
#define CANDERA_TEXT_NODE_2D_CLONE_STRATEGY_H

#include <Candera/Engine2D/Cloning/Node2DCloneStrategy.h>

namespace Candera {
    
    /** @addtogroup Cloning2D
    *  @{
    */

    /**
    * @brief This is the default clone strategy for deep cloning TextNode2d
    * See DeepNode2DCloneStrategy for rules.
    */
    class DeepTextNode2DCloneStrategy : public TextNode2DCloneStrategy{
    public:
        // Implement pure function from RenderNodeCloneStrategy.
        virtual void Execute(const Pair& current, const RootPair& root) override;

        // Implement pure function from RenderNodeCloneStrategy.
        virtual void Clear() override {};
    };

    /** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_TEXT_NODE_2D_CLONE_STRATEGY_H
