//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepTextNode2DCloneStrategy.h"
#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRenderer.h>
#include <Candera/Engine2D/Core/TextNode2D.h>
namespace Candera {
    void DeepTextNode2DCloneStrategy::Execute(const Pair& current, 
        const RootPair& /*root*/)
    {
        if ((current.source == 0) || (current.clone == 0)) {
            return;
        }

        if (current.source->GetTextNodeRenderer() == 0) {
            return;
        }

        static_cast<TextNode2D*>(current.clone)->SetTextNodeRenderer(
           (static_cast<const TextNode2D*>(current.source)->
           GetTextNodeRenderer())->Clone());
    }
} // namespace Candera
