//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_RENDER_NODE_CLONE_STRATEGY_H)
#define CANDERA_DEEP_RENDER_NODE_CLONE_STRATEGY_H

#include <Candera/Engine2D/Effects/Effect2D.h>

#include <Candera/Engine2D/Cloning/Node2DCloneStrategy.h>
#include <Candera/EngineBase/Cloning/MappedSharedObjectCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning2D
 *  @{
 */

/**
 * @brief This is the default clone strategy for deep cloning render nodes.
 * See DeepNode2DCloneStrategy for rules.
 */
class DeepRenderNodeCloneStrategy : public RenderNodeCloneStrategy{
public:
    // Implement pure function from RenderNodeCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root);

    // Implement pure function from RenderNodeCloneStrategy.
    virtual void Clear() { m_effect2D.Clear(); }

private:
    MappedSharedObjectCloneStrategy<Effect2D, Node2D> m_effect2D;
};

/** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_DEEP_RENDER_NODE_CLONE_STRATEGY_H
