//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepNode2DCloneStrategy.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/CompositeGroup2D.h>
#include <Candera/Engine2D/Core/TextNode2D.h>
#if defined(CANDERA_LAYOUT_ENABLED)
#include <Candera/EngineBase/Layout/Layout.h>
#endif

namespace Candera {

void DeepNode2DCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }

    if (current.source->IsTypeOf(RenderNode::GetTypeId())) {
         m_renderNode.Execute(
            RenderNodeCloneStrategy::Pair(
                Dynamic_Cast<const RenderNode*>(current.source),
                Dynamic_Cast<RenderNode*>(current.clone)),
            root);
    };
    if (current.source->IsTypeOf(CompositeGroup2D::GetTypeId())) {
         m_compositeGroup2D.Execute(
            CompositeGroup2DCloneStrategy::Pair(
                Dynamic_Cast<const CompositeGroup2D*>(current.source),
                Dynamic_Cast<CompositeGroup2D*>(current.clone)),
            root);
    };
    if (current.source->IsTypeOf(TextNode2D::GetTypeId())) {
        m_textNode2D.Execute(
            TextNode2DCloneStrategy::Pair(
            Dynamic_Cast<const TextNode2D*>(current.source),
            Dynamic_Cast<TextNode2D*>(current.clone)),
            root);
    };

#if defined(CANDERA_LAYOUT_ENABLED)
    Layouter* layouter = current.source->GetLayouter();
    if (layouter != 0) {
        Layouter* layouterClone = layouter->Clone();
        current.clone->SetLayouter(layouterClone);
    }
#endif
    
    // No special action for unsupported nodes.    
}

void DeepNode2DCloneStrategy::Clear()
{
    m_renderNode.Clear();
    m_compositeGroup2D.Clear();
}


} // namespace Candera
