//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_COMPOSITE_GROUP2D_CLONE_STRATEGY_H)
#define CANDERA_DEEP_COMPOSITE_GROUP2D_CLONE_STRATEGY_H

#include <Candera/Engine2D/Cloning/Node2DCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning2D
 *  @{
 */

/**
 * @brief This is the default clone strategy for deep cloning composite groups.
 * See DeepNode2DCloneStrategy for rules.
 */
class DeepCompositeGroup2DCloneStrategy : public CompositeGroup2DCloneStrategy{
public:
    // Implement pure function from CompositeGroup2DCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;

    // Implement pure function from CompositeGroup2DCloneStrategy.
    virtual void Clear() override {}
};

/** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_DEEP_COMPOSITE_GROUP2D_CLONE_STRATEGY_H
