//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepCompositeGroup2DCloneStrategy.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/CompositeGroup2D.h>
#include <Candera/Engine2D/Cloning/TreeMatch2D.h>

namespace Candera {

void DeepCompositeGroup2DCloneStrategy::Execute(const Pair& current, const RootPair& /*root*/)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    CompositeGroup2D::AnchorPointIterator iterator = current.source->GetAnchorPointIterator();
    for (; iterator.IsValid(); ++iterator) {
        CompositeGroup2D::AnchorPoint anchorPoint = *iterator;
        // Anchors should be children of the current node.
        Node2D* anchorPointCloneNode = TreeMatch2D::Find(
            anchorPoint.m_node,
            current.source,
            current.clone);
        static_cast<void>(Internal::CompositeGroup2DFunctions::DefineAnchorPoint(
            *current.clone,
            anchorPoint.m_id,
            anchorPoint.m_name,
            anchorPointCloneNode));
    }
}


} // namespace Candera
