//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Transformable2DScalePropertySetter_H)
#define CANDERA_Transformable2DScalePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseTransformable2DPropertySetter.h>

namespace Candera { namespace Animation {

    /** @addtogroup AnimationPropertySetters2D
     *  @{
     */

    /**
     *  @brief Scale property setter for x and y scale factor.
     */
    class Transformable2DScalePropertySetter: public BaseTransformable2DPropertySetter
    {
        FEATSTD_TYPEDEF_BASE(BaseTransformable2DPropertySetter);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DScalePropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            FEATSTD_RTTI_DECLARATION();

            /**
             * Sets the scale values for the transformable object
             * @param value Pointer to float. value[0] for the x and value[1] for the y scale of the transformable object
             */
            virtual void Set(const Float* value) override;

    };

    /**
     *  @brief Scale property setter only for x scale factor.
     */
    class Transformable2DScaleXPropertySetter : public BaseTransformable2DPropertySetter {

            typedef BaseTransformable2DPropertySetter Base;

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DScaleXPropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            FEATSTD_RTTI_DECLARATION();

            /**
             * Sets the x scale value for the transformable object
             * @param value Pointer to float value for the local x scale of the transformable object.
             */
            virtual void Set(const Float* value) override;

    };

    /**
     *  @brief Scale property setter only for y scale factor.
     */
    class Transformable2DScaleYPropertySetter : public BaseTransformable2DPropertySetter {

            typedef BaseTransformable2DPropertySetter Base;

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DScaleYPropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            FEATSTD_RTTI_DECLARATION();

            /**
            * Sets the y scale value for the transformable object
            * @param value Pointer to float value for the local y scale of the transformable object.
            */
            virtual void Set(const Float* value) override;

    };

    /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Transformable2DScalePropertySetter_H
