//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DScalePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DScalePropertySetter, BaseTransformable2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DScaleXPropertySetter, BaseTransformable2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DScaleYPropertySetter, BaseTransformable2DPropertySetter)

    /******************************************************************************
     *  Transformable2DScalePropertySetter::Set
     ******************************************************************************/
    void Transformable2DScalePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetScale(value[0], value[1]);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DScalePropertySetter::SharedPointer Transformable2DScalePropertySetter::Create()
    {
        return Transformable2DScalePropertySetter::SharedPointer(CANDERA_NEW(Transformable2DScalePropertySetter));
    }

    /******************************************************************************
     *  Transformable2DScaleXPropertySetter::Set
     ******************************************************************************/
    void Transformable2DScaleXPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            Vector2 scale = transformable->GetScale();
            scale.SetX(*value);
            transformable->SetScale(scale);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DScaleXPropertySetter::SharedPointer Transformable2DScaleXPropertySetter::Create()
    {
        return Transformable2DScaleXPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DScaleXPropertySetter));
    }

    /******************************************************************************
     *  Transformable2DScaleYPropertySetter::Set
     ******************************************************************************/
    void Transformable2DScaleYPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            Vector2 scale = transformable->GetScale();
            scale.SetY(*value);
            transformable->SetScale(scale);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DScaleYPropertySetter::SharedPointer Transformable2DScaleYPropertySetter::Create()
    {
        return Transformable2DScaleYPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DScaleYPropertySetter));
    }

}}   // namespace Candera { namespace Animation {
