//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Transformable2DRotatePropertySetter_H)
    #define CANDERA_Transformable2DRotatePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseTransformable2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /**
     *  @brief Rotation property setter.
     */
    class Transformable2DRotatePropertySetter : public BaseTransformable2DPropertySetter {
        
        FEATSTD_TYPEDEF_BASE(BaseTransformable2DPropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DRotatePropertySetter);

        FEATSTD_RTTI_DECLARATION();

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         * Sets the rotation value for the the transformable object.
         * @param value Pointer to float value for the local rotation of the transformable object.
         */
        virtual void Set(const Float* value) override;

    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Transformable2DRotatePropertySetter_H
