//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DRelativeScalePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeScalePropertySetter, BaseTransformable2DRelativePropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeScaleXPropertySetter, BaseTransformable2DRelativePropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeScaleYPropertySetter, BaseTransformable2DRelativePropertySetter)

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeScalePropertySetter::SharedPointer Transformable2DRelativeScalePropertySetter::Create()
    {
        return Transformable2DRelativeScalePropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeScalePropertySetter));
    }

    void Transformable2DRelativeScalePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetScale(value[0] * m_scale.GetX(), value[1] * m_scale.GetY());
        }
    }

    void Transformable2DRelativeScalePropertySetter::Initialize()
    {
        m_scale = (GetTransformable() != 0) ? GetTransformable()->GetScale() : Vector2(1.0F, 1.0F);
    }


    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeScaleXPropertySetter::SharedPointer Transformable2DRelativeScaleXPropertySetter::Create()
    {
        return Transformable2DRelativeScaleXPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeScaleXPropertySetter));
    }

    void Transformable2DRelativeScaleXPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetScale(value[0] * m_scaleX, transformable->GetScale().GetY());
        }
    }

    void Transformable2DRelativeScaleXPropertySetter::Initialize()
    {
        m_scaleX = (GetTransformable() != 0) ? GetTransformable()->GetScale().GetX() : Float(1);
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeScaleYPropertySetter::SharedPointer Transformable2DRelativeScaleYPropertySetter::Create()
    {
        return Transformable2DRelativeScaleYPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeScaleYPropertySetter));
    }

    void Transformable2DRelativeScaleYPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetScale(transformable->GetScale().GetX(), value[0] * m_scaleY);
        }
    }

    void Transformable2DRelativeScaleYPropertySetter::Initialize()
    {
        m_scaleY = (GetTransformable() != 0) ? GetTransformable()->GetScale().GetY() : Float(1);
    }

}}   // namespace Candera { namespace Animation {
