//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SnapToDevicePixelEnabled2DPropertySetter.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/RenderNode.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(SnapToDevicePixelEnabled2DPropertySetter, BaseNode2DPropertySetter)

    void SnapToDevicePixelEnabled2DPropertySetter::Set(const Float* value)
    {
        if ((value == 0) || (GetNode() == 0)) {
            return;
        }

        RenderNode* renderNode = Dynamic_Cast<RenderNode*, Node2D*>(GetNode());
        if (0 != renderNode) {
            renderNode->SetSnapToDevicePixelEnabled(value[0] > 0.0F);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    SnapToDevicePixelEnabled2DPropertySetter::SharedPointer SnapToDevicePixelEnabled2DPropertySetter::Create()
    {
        return SnapToDevicePixelEnabled2DPropertySetter::SharedPointer(CANDERA_NEW(SnapToDevicePixelEnabled2DPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
