//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Node2DClippingRectanglePropertySetter_H)
#define CANDERA_Node2DClippingRectanglePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseNode2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "ClippingRectangle" property of a Node2D.
     */
    class Node2DClippingRectanglePropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DClippingRectanglePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "ClippingRectangle" property of a Node2.
         *
         * @param value - pointer to an array of 4 float values for the ClippingRectangle rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DClippingRectanglePropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Left" value for the "ClippingRectangle" property of a Node2D.
    */
    class Node2DClippingRectangleLeftPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DClippingRectangleLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Left" value for the "ClippingRectangle" property of a Node2D.
        *
        * @param value - Left value for the "ClippingRectangle" rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DClippingRectangleLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Top" value for the "ClippingRectangle" property of a Node2D.
    */
    class Node2DClippingRectangleTopPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DClippingRectangleTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Top" value for the "ClippingRectangle" property of a Node2D.
        *
        * @param value - Top value for the "ClippingRectangle" rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DClippingRectangleTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Width" value for the "ClippingRectangle" property of a Node2D.
    */
    class Node2DClippingRectangleWidthPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DClippingRectangleWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Width" value for the "ClippingRectangle" property of a Node2D.
        *
        * @param value - Width value for the "ClippingRectangle" rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DClippingRectangleWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Height" value for the "ClippingRectangle" property of a Node2D.
    */
    class Node2DClippingRectangleHeightPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DClippingRectangleHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Height" value for the "ClippingRectangle" property of a Node2D.
        *
        * @param value - Height value for the "ClippingRectangle" rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DClippingRectangleHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Node2DClippingRectanglePropertySetter_H
