//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Node2DBoundingRectanglePropertySetter_H)
#define CANDERA_Node2DBoundingRectanglePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseNode2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "BoundingRectangle" property of a Node2D.
     */
    class Node2DBoundingRectanglePropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DBoundingRectanglePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "BoundingRectangle" property of a Node2.
         *
         * @param value - pointer to an array of 4 float values for the BoundingRectangle rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DBoundingRectanglePropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Left" value for "BoundingRectangle" property of a Node2D.
    */
    class Node2DBoundingRectangleLeftPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DBoundingRectangleLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Left" value for "BoundingRectangle" property of a Node2.
        *
        * @param value -Left value for "BoundingRectangle" rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DBoundingRectangleLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Top" value for the "BoundingRectangle" property of a Node2D.
    */
    class Node2DBoundingRectangleTopPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DBoundingRectangleTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Top" value for the "BoundingRectangle" property of a Node2.
        *
        * @param value - Top value for the BoundingRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DBoundingRectangleTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Width" value for the "BoundingRectangle" property of a Node2D.
    */
    class Node2DBoundingRectangleWidthPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DBoundingRectangleWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Width" value for the "BoundingRectangle" property of a Node2.
        *
        * @param value - Width value for the BoundingRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DBoundingRectangleWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Height" value for the "BoundingRectangle" property of a Node2D.
    */
    class Node2DBoundingRectangleHeightPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Node2DBoundingRectangleHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Height" value for the "BoundingRectangle" property of a Node2.
        *
        * @param value - Height value for the BoundingRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Node2DBoundingRectangleHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Node2DBoundingRectanglePropertySetter_H
