//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseTransformable2DRelativePropertySetter_H)
#define CANDERA_BaseTransformable2DRelativePropertySetter_H

#include <Candera/EngineBase/Animation/RelativePropertySetter.h>

namespace Candera { 
    class Transformable2D;

    namespace Animation {
     /**
     *  @addtogroup AnimationPropertySetters2D
     *  @{
     */

    /**
     *  @brief Base class for Relative Transformable2D PropertySetters.
     *
     *  The property setter shall be a base class for all PropertySetters that set properties of Transformable2D objects.
     */
    class BaseTransformable2DRelativePropertySetter : public Animation::RelativePropertySetter {
        FEATSTD_TYPEDEF_BASE(RelativePropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(BaseTransformable2DRelativePropertySetter);

        FEATSTD_RTTI_DECLARATION();

        BaseTransformable2DRelativePropertySetter() : m_transformable(0) {}
        virtual ~BaseTransformable2DRelativePropertySetter() override { m_transformable = 0; }

        /**
         * Set the transformable object the property setter operates on.
         *
         * @param transformable The transformable object the property setter operates on.
         */
        void SetTransformable(Transformable2D* transformable) { m_transformable = transformable; }

        /**
         * Get the transformable object the property setter operates on.
         *
         * @return The transformable object the property setter operates on.
         */
        Transformable2D* GetTransformable() { return m_transformable; }

        const Transformable2D* GetTransformable() const { return m_transformable; }

    private:
        Transformable2D* m_transformable;
    };

    /**
     * @}
     */ // end of addtogroup AnimationPropertySetters2D
    }   // namespace Animation
    
}   // namespace Candera

#endif  // CANDERA_BaseTransformable2DRelativePropertySetter_H
