//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseNode2DPropertySetter_H)
#define CANDERA_BaseNode2DPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera { 
    
    class Node2D;
    
    namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /**
     *  @brief Base class for Node2D property setters.
     */
    class BaseNode2DPropertySetter : public AnimationPropertySetter {
        FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(BaseNode2DPropertySetter);

        FEATSTD_RTTI_DECLARATION();

        /**
         * Constructor.
         */
        BaseNode2DPropertySetter();

        /**
         * Sets the node the property setter operates on.
         * @param node The transformable object.
         */
        void SetNode(Candera::Node2D* node) { m_node = node; }

        /**
         * Gets the node the property setter operates on.
         * @return The node object.
         */
        Candera::Node2D* GetNode() { return m_node; }

        const Candera::Node2D* GetNode() const { return m_node; }

    private:
        Candera::Node2D* m_node;
    };

    /** @} */ // end of AnimationPropertySetters2D
    }// namespace Animation

}// namespace Candera

#endif  // CANDERA_BaseNode2DPropertySetter_H
