//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseCamera2DPropertySetter_H)
#define CANDERA_BaseCamera2DPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera {

    class Camera2D;

    namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /**
     *  @brief Base class for Camera2D property setters.
     */
        class BaseCamera2DPropertySetter : public AnimationPropertySetter {
            FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(BaseCamera2DPropertySetter);

            FEATSTD_RTTI_DECLARATION();

            /**
            * Constructor.
            */
            BaseCamera2DPropertySetter();

            /**
            * Sets the Camera2D object the property setter operates on.
            * @param node The Camera2D object.
            */
            void SetCamera(Candera::Camera2D* node) { m_camera = node; }

            /**
            * Gets the Camera2D object the property setter operates on.
            * @return The Camera2D object.
            */
            Candera::Camera2D* GetCamera() { return m_camera; }

            const Candera::Camera2D* GetCamera() const { return m_camera; }

        private:
            Candera::Camera2D* m_camera;
        };

        /** @} */ // end of AnimationPropertySetters2D
    }// namespace Animation

}// namespace Candera

#endif  // CANDERA_BaseCamera2DPropertySetter_H
