//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AlphaNode2DPropertySetter.h"

#include <Candera/Engine2D/Core/Node2D.h>


namespace Candera { namespace Animation {
    
    FEATSTD_RTTI_DEFINITION(AlphaNode2DPropertySetter, BaseNode2DPropertySetter)

    void AlphaNode2DPropertySetter::Set(const Float* value)
    {
        if (value == 0) {
            return;
        }

        Candera::Node2D* const n = Base::GetNode();

        if (n == 0) {
            return;
        }

        n->SetAlphaValue(value[0]);
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    AlphaNode2DPropertySetter::SharedPointer AlphaNode2DPropertySetter::Create()
    {
        return AlphaNode2DPropertySetter::SharedPointer(CANDERA_NEW(AlphaNode2DPropertySetter));
    }

}}
