//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef gl2config_h
#define gl2config_h

/*
 * This header file allows a platform to disable extensions listed in gl2ext.h,
 * by simply placing a #define macro with extension name and with the distinct value 0.
 * Extension name strings are listed at http://www.khronos.org/registry/gles/.
 * For example, if you want to disable the extension GL_OES_depth24 for programs that are
 * compiled against "gl2ext.h" header, simply place the macro definition
 * "#define GL_OES_depth24 0" below. The include guard in file "gl2ext.h" prevents then the
 * definiton of GL_OES_depth24 with value 1 and the token GL_DEPTH_COMPONENT24_OES.
 *
 * Note: This file must be included before "gl2ext.h" in order to take affect.
 *
 * To test within application code against an extension, see following example:
 * #if GL_OES_depth24
 *      // process code with extension enabled.
 * #else
 *      // process code with extension disabled.
 * #endif
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Place #define statements as needed below this comment to disable certain extensions listed in gl2ext.h
 * Example: #define GL_OES_depth24 0  // Each define MUST HAVE value "0".
 */
 
#define GL_GLEXT_PROTOTYPES

#undef  GL_NV_coverage_sample
#define GL_NV_coverage_sample 0

#undef GL_COVERAGE_COMPONENT_NV
#define GL_COVERAGE_COMPONENT_NV             0xFFffFFff

#undef GL_COVERAGE_ALL_FRAGMENTS_NV
#define GL_COVERAGE_ALL_FRAGMENTS_NV         0xFFffFFff

#undef GL_COVERAGE_EDGE_FRAGMENTS_NV
#define GL_COVERAGE_EDGE_FRAGMENTS_NV        0xFFffFFff

#undef GL_COVERAGE_AUTOMATIC_NV
#define GL_COVERAGE_AUTOMATIC_NV             0xFFffFFff

#undef     GL_COVERAGE_BUFFER_BIT_NV
#define GL_COVERAGE_BUFFER_BIT_NV            0xFFffFFff

#undef glCoverageMaskNV
#define glCoverageMaskNV(A) (void)0;

#undef glCoverageOperationNV
#define glCoverageOperationNV(A) (void)0;


#ifdef __cplusplus
}
#endif

#endif  // gl2config_h
