/*******************************************************************************
*
* FILE:          FC_Gateway_TunerMasterClientHandler.cpp
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for tuner master
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "FC_Gateway_TunerMasterClientHandler.h"
#include "procgenericgateway_tclMainApp.h"

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#include "Tuner_GenericClientInterface.h"

#include "FC_Gateway_TunerDABClientHandler.h"
#include "FC_Gateway_TunerClientHandler.h"

#include "Utility.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Tuner);


/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(FC_Gateway_TunerMasterClientHandler, ahl_tclBaseWork)

//Property Update for BAND.
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUNMSTR_G_BAND_INFOOpStatus)

//Property Update for Preset list change
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus)

//ConfigSettings - Property Update for Announcements
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus)

//ConfigSettings - Property Update for SeamlessSwitching
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus)

//Preset - SavePreset & TuneToPreset
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult)

//ConfigSettings - Set Announcements
ON_MESSAGE_SVCDATA(
        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT,
        AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
        vHandleFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTOpResult)


//ConfigSettings - Set SeamlessSwitching
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult)

//ConfigSettings - Set AM
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult)

//SetFrequency + Change in band
ON_MESSAGE_SVCDATA(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult)

END_MSG_MAP()

FC_Gateway_TunerMasterClientHandler* 
FC_Gateway_TunerMasterClientHandler::m_poFC_Gateway_TunerMasterClientHandler
= NULL;


/******************************************************************************
 * Function:     getInstance
 * Description:  singleton
 * Parameters:   Instance of main app
 * Return:       FC_Gateway_TunerMasterClientHandler instance
 *****************************************************************************/

FC_Gateway_TunerMasterClientHandler* 
FC_Gateway_TunerMasterClientHandler::getInstance(procgenericgateway_tclMainApp*
                                                 poMainAppl)
{

    if(m_poFC_Gateway_TunerMasterClientHandler == NULL)
    {
        m_poFC_Gateway_TunerMasterClientHandler =
                new FC_Gateway_TunerMasterClientHandler(poMainAppl);
    }

    return m_poFC_Gateway_TunerMasterClientHandler;
}

/******************************************************************************
 * Function:     FC_Gateway_TunerMasterClientHandler
 * Description:  Constructor
 * Parameters:   Instance of main app
 * Return:       NA
 *****************************************************************************/

FC_Gateway_TunerMasterClientHandler::FC_Gateway_TunerMasterClientHandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler(
         (ahl_tclBaseOneThreadApp*)poMainAppl,
         MIDW_TUNERMASTERFI_C_U16_SERVICE_ID,
         MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION,
         MIDW_TUNERMASTERFI_C_U16_SERVICE_MINORVERSION )
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler:"),
            DLT_STRING( __FUNCTION__));

    vRegisterPropertyOnStartup();
    m_poMainApp = poMainAppl;
    m_poAudioGeniviProxy = NULL;
    m_poAudioGeniviConnection = NULL;
    _bIsAMActive = FALSE;
    m_bIsPresetSave = false;
    m_bIsAudioConnected = false;
    m_iSrcAddedSubscriptionID = 0;
    m_iSrcRemovedSubscriptionID = 0;
    bSubscribeForSourceChange();
}

/******************************************************************************
 * Function:     FC_Gateway_TunerMasterClientHandler
 * Description:  Destructor
 * Parameters:   void
 * Return:       NA
 *****************************************************************************/

FC_Gateway_TunerMasterClientHandler::~FC_Gateway_TunerMasterClientHandler()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler Destructor :"),
            DLT_STRING(__FUNCTION__));

    vDeRegisterAllProperty();
    vUnsubscribeForSourceChangeSignal();
    if(m_poFC_Gateway_TunerMasterClientHandler!= NULL)
    {
        delete m_poFC_Gateway_TunerMasterClientHandler;
        m_poFC_Gateway_TunerMasterClientHandler = NULL;
    }
}


/******************************************************************************
 * Function:    vOnServiceAvailable
 * Description: Call back on service available
 * Parameters:  void
 * Return:      void
 *****************************************************************************/

tVoid FC_Gateway_TunerMasterClientHandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler:"),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
 * Function:    vOnServiceUnavailable
 * Description: Call back on service unavailable
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler :"),
            DLT_STRING( __FUNCTION__));

}

/******************************************************************************
 * Function:     vRegisterProperty
 * Description:  Register for a property
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::vRegisterProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler :"),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
 * Function:     vDeRegisterProperty
 * Description:  Derigester a property
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::vDeRegisterProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler :"),
            DLT_STRING( __FUNCTION__));
}

/******************************************************************************
 * Function:     vRegisterPropertyOnStartup
 * Description:  Registers property on process startup
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::vRegisterPropertyOnStartup()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler :"),
            DLT_STRING( __FUNCTION__));

    vAddAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST);

    vAddAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO);

    vAddAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS);

    vAddAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS);
}

/******************************************************************************
 * Function:     vDeRegisterAllProperty
 * Description:  Deregisters all properties
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::vDeRegisterAllProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler :"),
            DLT_STRING( __FUNCTION__));

    vDeRegisterProperty();

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST);

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO);

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS);

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS);
}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_G_BAND_INFOOpStatus
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::vHandleFID_TUNMSTR_G_BAND_INFOOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR) {
                _Band_FID_TUNMSTR_G_BAND_INFOStatus = oStatus.Band;

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_BAND_INFOOpStatus(): "
                            "Status update message received for"
                            "'FI_C_U16_FID_TUNMSTR_G_BAND_INFO'(FID: 0x0015)"));

#endif
                onFID_TUNMSTR_G_BAND_INFOStatus(oStatus.Band);

                // vHandleFID_TUNMSTR_G_BAND_INFOOpStatus: user specific code start
                // vHandleFID_TUNMSTR_G_BAND_INFOOpStatus: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                        DLT_STRING("FC_Gateway_TunerMasterClientHandler::"
                                   "vHandleFID_TUNMSTR_G_BAND_INFOOpStatus:"
                                   "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_G_BAND_INFOStatus
 * Description:  On update of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO
 * Parameters:   midw_fi_tcl_e8_Band
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::onFID_TUNMSTR_G_BAND_INFOStatus(
        midw_fi_tcl_e8_Band Band)
{
    // onFID_TUNMSTR_G_BAND_INFOStatus: user specific code start
    // onFID_TUNMSTR_G_BAND_INFOStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_UPREG) {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                _List_FID_TUNMSTR_G_PRESET_LISTStatus = oStatus.List;
                _ListOfStations_FID_TUNMSTR_G_PRESET_LISTStatus =
                        oStatus.ListOfStations;

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus():"
                            "Statusupdate message received for"
                            "'FI_C_U16_FID_TUNMSTR_G_PRESET_LIST' FID:0x0017"));
#endif

                onFID_TUNMSTR_G_PRESET_LISTStatus(oStatus.List,
                                                  oStatus.ListOfStations);

                // vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus: user specific code start
                // vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_G_PRESET_LISTStatus
 * Description:  On update of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST
 * Parameters:   midw_fi_tcl_e8_List, vector<midw_fi_tcl_PresetList>
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::onFID_TUNMSTR_G_PRESET_LISTStatus(
        midw_fi_tcl_e8_List List,
        std::vector<midw_fi_tcl_PresetList,
        std::allocator<midw_fi_tcl_PresetList> >
        ListOfStations)
{

    // onFID_TUNMSTR_G_PRESET_LISTStatus: user specific code start
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+onFID_TUNMSTR_G_PRESET_LISTStatus"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("midw_fi_tcl_e8_List : "),
            DLT_INT( List.enType));
#endif

    std::vector<stPresetElement> l_PresetList;
    for(std::vector< midw_fi_tcl_PresetList,
        std::allocator<midw_fi_tcl_PresetList> >
        ::iterator iIterator = ListOfStations.begin();
        iIterator != ListOfStations.end(); ++iIterator)
    {
        stPresetElement l_PresetElement;

#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("List id:"),
                DLT_INT(iIterator->List.enType));

        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Band:"),
                DLT_INT(iIterator->Band.enType));
#endif
        switch(iIterator->Band.enType)
        {
        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
            l_PresetElement.band = AP_TUNER_BAND_FM;
            break;

        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
            l_PresetElement.band = AP_TUNER_BAND_DAB;
            break;

        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
            l_PresetElement.band = AP_TUNER_BAND_AM;
            break;

        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
            l_PresetElement.band = AP_TUNER_BAND_LW;
            break;

        default:
            continue;
            break;
        }


        l_PresetElement.index = iIterator->Element_ID;


        l_PresetElement.frequency = iIterator->Frequency*1000;


        l_PresetElement.stationName = iIterator->PSName.szValue;

#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PS name:"),
                DLT_STRING(iIterator->PSName.szValue));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Frequency:"),
                DLT_UINT(iIterator->Frequency));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Element id:"),
                DLT_INT(iIterator->Element_ID));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Tp Tmc info:"),
                DLT_INT(iIterator->u8TpTmcInfo));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PTY:"),
                DLT_UINT(iIterator->PTY));
#endif
        l_PresetList.push_back(l_PresetElement);
        vUpdatePresetListDataHandler(l_PresetList);
    }

    // onFID_TUNMSTR_G_PRESET_LISTStatus: user specific code end
}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult
 * Description:  Handling of method result
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler::"
                       "vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult()"));
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage  oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult():"
                            "Method result update message received for"
                            "'FI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING'"
                            "FID: 0x0021"));

                onFID_TUNMSTR_S_PRESET_HANDLINGMResult(
                            oMResult.TunerMaster_StatusResponse,
                            oMResult.Source,
                            oMResult.Action);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult:"
                            "Received message is invalid!"));

                if(m_bIsPresetSave)
                {
                    char sErrMsg[] = "Internal Error: Save preset failed.";
                    vSendSavePresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,
                                         sErrMsg);

                    m_bIsPresetSave = false;
                }
                else
                {
                    vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                }
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_S_PRESET_HANDLINGMResult
 * Description:  On method result of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING
 * Parameters:   tBool,midw_fi_tcl_e8_Source,midw_fi_tcl_e8_AnnoTypes
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::onFID_TUNMSTR_S_PRESET_HANDLINGMResult(
        midw_fi_tcl_TunerMaster_StatusResponse
        TunerMaster_StatusResponse,
        midw_fi_tcl_e8_Source Source,
        midw_fi_tcl_e8_Action Action)
{
    // onFID_TUNMSTR_S_PRESET_HANDLINGMResult: user specific code start
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("onFID_TUNMSTR_S_PRESET_HANDLINGMResult Status"),
            DLT_INT(TunerMaster_StatusResponse.u8TunermasterStatus.enType));
    if(TunerMaster_StatusResponse.u8TunermasterStatus.enType ==
            midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED)
    {
        if(m_bIsPresetSave)
        {
            vSendSavePresetResult();
            m_bIsPresetSave = false;
        }
        else
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Source"),
                    DLT_INT(Source.enType));

            if(Source.enType == midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE)
            {
                vSendTuneToPresetResult();
                return;
            }
            unsigned int iSourceID;
            GError* poError = NULL;
            if(!m_bIsAudioConnected)
            {
                bSourceMapping();
            }

            switch(Source.enType)
            {
            case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM:
                iSourceID = iGetSourceIdAM();
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                        DLT_STRING("+bSetBand: AM source "),DLT_INT(iSourceID));
                break;

            case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1:
            case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM2:
                iSourceID = iGetSourceIdFM();
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                        DLT_STRING("+bSetBand: FM source "),DLT_INT(iSourceID));
                break;

            case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB:
                iSourceID = iGetSourceIdDAB();
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                        DLT_STRING("+bSetBand: DAB source "),
                        DLT_INT(iSourceID));
                break;

            default:
                vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                return;
            }

            if(iSourceID == 0)
            {
                vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                return;
            }

            GVariant *_ret = g_dbus_proxy_call_sync (
                        poGetAudioGeniviProxy(),
                        "Connect",
                        g_variant_new ("(qq)",
                                       iSourceID,
                                       1),
                        G_DBUS_CALL_FLAGS_NONE,
                        -1,
                        NULL,
                        &poError);

            g_variant_unref(_ret);


            if(poError != NULL)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                        DLT_STRING("FC_Gateway_TunerMasterClientHandler::"
                                   "connect: error: "),
                        DLT_STRING(poError->message));

                vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                g_clear_error(&poError);

            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::connect:"
                            "Success"));
                vSendTuneToPresetResult();
            }
        }
    }
    else
    {
        if(m_bIsPresetSave)
        {
            char sErrMsg[] = "Internal Error.Save Preset failed.";
            vSendSavePresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,sErrMsg);
            m_bIsPresetSave = false;
        }
        else
        {
            vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        }
    }
    // onFID_TUNMSTR_S_PRESET_HANDLINGMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTOpResult
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::
vHandleFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTOpResult(amt_tclServiceData*
                                                   poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage oInMsg(poMessage);
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult
                    oMResult;

            if(oInMsg.s32GetData(oMResult,
                                 MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTOpResult():"
                            "Method result update message received for "
                            "'FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT'FID:0x0021"));
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler:: "
                            "vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult:"
                            "Received message is invalid!"));
            }
            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::
vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult(amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerMasterClientHandler::"
                "vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult"));

    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult():"
                            "Method result update message received for"
                            "'FI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION'"
                            "FID: 0x000A)!"));

                onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult(
                            oMResult.TunerMaster_StatusResponse);

                // vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult: user specific code start
                // vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult
 * Description:  On method result of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION
 * Parameters:   midw_fi_tcl_TunerMaster_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult(
        midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse)
{

    // onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult: user specific code start
    // onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::
vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult(amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerMasterClientHandler::"
                       "vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult"));

    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult():"
                            "Method result update message received for"
                            "'FID_TUNMSTR_S_STATION_SELECTION' FID: 0x0026)!"));

                onFID_TUNMSTR_S_STATION_SELECTIONMResult(
                            oMResult.TunerMaster_StatusResponse);

                // vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult: user specific code start
                // vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_S_STATION_SELECTIONMResult
 * Description:  On method result of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION
 * Parameters:   midw_fi_tcl_TunerMaster_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::onFID_TUNMSTR_S_STATION_SELECTIONMResult(
        midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse)
{

    // onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult: user specific code start
    if(TunerMaster_StatusResponse.u8TunermasterStatus.enType ==
            midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                    "onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult Req succeed"));

        vSendSetFreqResult();
    }
    else
    {
        vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
    }
    // onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult"));
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult
                    oMResult;

            if(oInMsg.s32GetData(oMResult, MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult():"
                            "Method result update message received for"
                            "'FI_C_U16_FID_TUNMSTR_S_MTC_SETMODE' FID: 0x0021"));
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult:"
                            "Received message is invalid!"));
            }
            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerMasterClientHandler::
vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus(amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus"));
#endif
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus oStatus;

            if (oInMsg.s32GetData(oStatus,
                                  MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus():"
                            "Status update message received for"
                            "'FI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS' FID: 0x0019"));
#endif
                _b32AnnouncementType_FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus =
                        oStatus.b32AnnouncementType;

                _Source_FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus = oStatus.Source;

                onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(
                            oStatus.b32AnnouncementType,
                            oStatus.Source);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus
 * Description:  On property update of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS
 * Parameters:   midw_fi_tcl_b32_AnnoType, midw_fi_tcl_e8_Source
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerMasterClientHandler::
onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(midw_fi_tcl_b32_AnnoType oAnnoType,
                                         midw_fi_tcl_e8_Source oSource)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("Anno Type :"),
            DLT_INT( oAnnoType.u32Value),
            DLT_STRING("source :"),DLT_INT(oSource.enType));
#endif

    tclConfigSettings *poConfigSettings = tclConfigSettings::getInstance();

    poConfigSettings->vSetTA(oAnnoType.bTUNMSTR_ANNOTYPE_TA());

    poConfigSettings->vSetTransportAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_TRANSPORT());

    poConfigSettings->vSetWarningAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_WARNING());

    poConfigSettings->vSetNewsAnnouncement(oAnnoType.bTUNMSTR_ANNOTYPE_NEWS());

    poConfigSettings->vSetWeatherAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_WEATHER());

    poConfigSettings->vSetEventAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_EVENT());

    poConfigSettings->vSetMusicalEventAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_SPECIALEVENT());

    poConfigSettings->vSetRadioInfoAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_PROGRAMME());

    poConfigSettings->vSetSportAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_SPORTS());

    poConfigSettings->vSetFinanceAnnouncement(
                oAnnoType.bTUNMSTR_ANNOTYPE_FINANCE());
    vUpdateConfigSettings(poConfigSettings);
    //vUpdateTAStatus();
}

/******************************************************************************
 * Function:     vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerMasterClientHandler::
vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus(amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "+vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus"));
#endif
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus
                    oStatus;

            if (oInMsg.s32GetData(oStatus,
                                  MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus():"
                            "Status update message received for"
                            "'FI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS'"
                            "(FID: 0x0019)!"));
#endif
                onFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(oStatus.Mode);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerMasterClientHandler::"
                            "vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus
 * Description:  On property update of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS
 * Parameters:   midw_fi_tcl_b8_ModeType, midw_fi_tcl_e8_Source
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerMasterClientHandler::
onFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(midw_fi_tcl_b8_ModeType oMode)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("ModeType :"),
            DLT_INT( oMode.u8Value));

#endif
    tclConfigSettings *poConfigSettings = tclConfigSettings::getInstance();
    if(oMode.bTUNMSTR_SF_FM() || oMode.bTUNMSTR_SF_DAB())
    {
        poConfigSettings->vSetSeamlessSwitching(true);
    }
    else
    {
        poConfigSettings->vSetSeamlessSwitching(false);
    }
    vUpdateConfigSettings(poConfigSettings);
}

/******************************************************************************
 * Function:     sendFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION
 * Parameters:   bool enable, midw_fi_tcl_e8_Source
 * Return:       bool
 *****************************************************************************/
tBool 
FC_Gateway_TunerMasterClientHandler::sendFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMStart
(
        tBool Enable,
        midw_fi_tcl_e8_Source Source)
{
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart
                oMStart;
        //the data content
        oMStart.Enable = Enable;
        oMStart.Source = Source;

        if(Enable)
        {
            _bIsAMActive = TRUE;
        }
        else
        {
            _bIsAMActive = FALSE;
        }

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) 0,
                    (tU16) MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::"
                        "sendFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMStart():"
                        "enPostMessage failed for FuncId - "),
                    DLT_UINT(
                        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUNMSTR_S_PRESET_HANDLINGMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING
 * Parameters:   preset action(save/recall), elementID, list, band, freq,
                 PI, secondary PI
 * Return:       bool
 *****************************************************************************/
tBool 
FC_Gateway_TunerMasterClientHandler::sendFID_TUNMSTR_S_PRESET_HANDLINGMStart(
        midw_fi_tcl_e8_Preset_Action Preset_Action,
        tU8 u8Element_ID,
        midw_fi_tcl_e8_List List,
        midw_fi_tcl_e8_Band Band,
        tU32 Frequency, tU32 PI,
        tU16 SecondaryPI)
{
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart
                oMStart;
        //the data content
        oMStart.Preset_Action = Preset_Action;
        oMStart.u8Element_ID = u8Element_ID;
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("midw_fi_tcl_e8_List : "),
                DLT_INT( _List_FID_TUNMSTR_G_PRESET_LISTStatus.enType));
        oMStart.List = List;
        oMStart.Band = Band;
        oMStart.Frequency = Frequency;


        oMStart.PI = PI;
        oMStart.SecondaryPI = SecondaryPI;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) 0,
                    (tU16) MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
          we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::"
                        "sendFID_TUNMSTR_S_PRESET_HANDLINGMStart():"
                        "enPostMessage failed for FuncId -"),
                    DLT_UINT(
                        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT
 * Parameters:   Announcement type, announcement source
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerMasterClientHandler::
sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart(
        midw_fi_tcl_b32_AnnoType enAnnoType,
        midw_fi_tcl_b8_SourceAnno enAnnoSource)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart:AnnoType:"),
            DLT_INT(enAnnoType.u32Value),DLT_STRING("Source:"),
            DLT_INT(enAnnoSource.u8Value));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart
                oMStart;

        oMStart.b32Anno_Types = enAnnoType;
        oMStart.Source = enAnnoSource;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) 0,
                    (tU16) MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        // Post message - since the second parameter is true we need not explicitly delete the message
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::"
                        "sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart():"
                        "enPostMessage failed for FuncId -"),
                    DLT_UINT(
                        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else {
            bRetVal = TRUE;
        }
        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUNMSTR_S_STATION_SELECTIONStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT
 * Parameters:   Announcement type, announcement source
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerMasterClientHandler::
sendFID_TUNMSTR_S_STATION_SELECTIONStart(midw_fi_tcl_e8_Band enBand, 
                                         tU32 uFrequency)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("sendFID_TUNMSTR_S_STATION_SELECTIONStart:Frequency:"),
            DLT_UINT(uFrequency),DLT_STRING("Band:"),DLT_INT(enBand.enType));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart
                oMStart;

        oMStart.Option.enType =
                midw_fi_tcl_e8_StationSelection_Option::FI_EN_FREQUENCY_INPUT;
        oMStart.Band = enBand;
        oMStart.Frequency = uFrequency;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        // Post message - since the second parameter is true we need not explicitly delete the message
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::"
                        "sendFID_TUNMSTR_S_STATION_SELECTIONStart():"
                        "enPostMessage failed for FuncId -"),
                    DLT_UINT(
                        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else {
            bRetVal = TRUE;
        }
        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUNMSTR_S_MTC_SETMODEStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE
 * Parameters:   midw_fi_tcl_b8_ModeType
 * Return:       bool
 *****************************************************************************/
tBool 
FC_Gateway_TunerMasterClientHandler::sendFID_TUNMSTR_S_MTC_SETMODEStart(
        midw_fi_tcl_b8_ModeType oMode)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+sendFID_TUNMSTR_S_MTC_SETMODEStart mode "),
            DLT_INT( oMode.u8Value));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart oMStart;

        oMStart.Mode = oMode;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message */
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::"
                        "sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart():"
                        "enPostMessage failed for FuncId -"),
                    DLT_UINT(
                        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
            bRetVal = TRUE;
        }
        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     bSourceMapping
 * Description:  Get the audio source mapping from genivi audio
 * Parameters:   void
 * Return:       bool
 *****************************************************************************/

bool FC_Gateway_TunerMasterClientHandler::bSourceMapping()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_DEBUG,DLT_STRING("+bSourceMapping"));
    m_bIsAudioConnected = true;

    GError* poError = NULL;
    //we have the proxy object to make the call to audio command plugin.
    GVariant *l_poRet = g_dbus_proxy_call_sync(
                m_poAudioGeniviProxy,
                "GetListMainSources", g_variant_new("()"),
                G_DBUS_CALL_FLAGS_NONE,
                -1,
                NULL, &poError);

    if(NULL == poError && l_poRet != NULL &&
            g_variant_is_of_type (l_poRet,
                                  G_VARIANT_TYPE ("(na(qs(nn)q))")))
    {
        /* handle the logic to retrive the name for tuner and make connect call.*/

        DLT_LOG(AGW_Tuner,DLT_LOG_DEBUG,DLT_STRING(
                    "FC_Gateway_TunerMasterClientHandler::"
                    "GetListMainSources success"));

        gint16   out_result;
        GVariant *l_poResult = NULL;
        g_variant_get(l_poRet, "(n@a(qs(nn)q))", &out_result, &l_poResult);
        if(l_poRet != NULL)
        {
            g_variant_unref(l_poRet);
            l_poRet = NULL;
        }
        if(out_result == 0 && l_poResult != NULL)
        {
            guint16 sourceID;
            gchar* sSourceName = NULL;
            guint16 sourceClassID;
            gint16 Availability;
            gint16 AvailabilityReason;
            gint iIndex = 0;
            gboolean bIsAMSourceFound = FALSE;
            gboolean bIsFMSourceFound = FALSE;
            gboolean bIsDABSourceFound = FALSE;
            gboolean bIsDRMSourceFound = FALSE;

            gsize childNum = g_variant_n_children(l_poResult);
            for(iIndex ; iIndex < (gint)childNum ; iIndex++)
            {
                GVariant* poChildVal = g_variant_get_child_value(l_poResult,
                                                                 iIndex);
                if(poChildVal != NULL &&
                        g_variant_is_of_type (poChildVal,
                                              G_VARIANT_TYPE ("(qs(nn)q)")))
                {
                    g_variant_get(poChildVal, "(qs(nn)q)", &sourceID, &sSourceName,
                                  &Availability,&AvailabilityReason,&sourceClassID);

                    if(sSourceName == NULL)
                    {
                        continue;
                    }

                    if(!g_strcmp0 (sSourceName,"TUNER_DAB"))
                    {
                        m_sourceMapDAB.m_strBandName.assign(sSourceName);
                        m_sourceMapDAB.m_iBandSourceID = sourceID;
                        bIsDABSourceFound = TRUE;
                    }
                    else if(!g_strcmp0 (sSourceName,"TUNER_FM"))
                    {
                        m_sourceMapFM.m_strBandName.assign(sSourceName);
                        m_sourceMapFM.m_iBandSourceID = sourceID;
                        bIsFMSourceFound = TRUE;
                    }
                    else if(!g_strcmp0 (sSourceName,"TUNER_AM"))
                    {
                        m_sourceMapAM.m_strBandName.assign(sSourceName);
                        m_sourceMapAM.m_iBandSourceID = sourceID;
                        bIsAMSourceFound = TRUE;
                        tclConfigSettings *poConfigSettings =
                                tclConfigSettings::getInstance();

                        poConfigSettings->vSetAMActive(TRUE);
                        vUpdateConfigSettings(poConfigSettings);
                    }
                    else if(!g_strcmp0 (sSourceName,"TUNER_DRM"))
                    {
                        m_sourceMapDRM.m_strBandName.assign(sSourceName);
                        m_sourceMapDRM.m_iBandSourceID = sourceID;
                        bIsDRMSourceFound = TRUE;
                    }
                    else
                    {
                        //Memory leak handling
                        g_free(sSourceName);
                        g_variant_unref(poChildVal);
                        continue;
                    }

                    //Memory leak handling
                    g_free(sSourceName);
                    g_variant_unref(poChildVal);
                    poChildVal = NULL;
                }
            }
            g_variant_unref(l_poResult);

            if(!bIsDABSourceFound)
            {
                m_sourceMapDAB.m_iBandSourceID = 0;
            }
            if(!bIsAMSourceFound)
            {
                m_sourceMapAM.m_iBandSourceID = 0;
                tclConfigSettings *poConfigSettings =
                        tclConfigSettings::getInstance();

                poConfigSettings->vSetAMActive(FALSE);
                vUpdateConfigSettings(poConfigSettings);
            }
            if(!bIsFMSourceFound)
            {
                m_sourceMapFM.m_iBandSourceID = 0;
            }
            if(!bIsDRMSourceFound)
            {
                m_sourceMapDRM.m_iBandSourceID = 0;
            }
        }
        else
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::GetListMainSources"
                        "Result is invalid"));
            return false;
        }
    }
    else
    {
        if(poError != NULL)
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::GetListMainSources"
                        ":error: "),DLT_STRING( poError->message));

            g_clear_error(&poError);
        }

        if(l_poRet != NULL)
        {
            g_variant_unref(l_poRet);
            l_poRet = NULL;
        }

        return false;
    }
    return true;
}

#ifdef __cplusplus
extern "C"
{
#endif

/******************************************************************************
 * Function:     bSavePreset
 * Description:  Wrapper method to call save an element in preset list
 * Parameters:   index, band, frequency, program id, secondary program id
 * Return:       bool
 *****************************************************************************/
bool bSavePreset(unsigned char cElementID, ApTunerBand eBand,
                 unsigned long int uFrequency,
                 unsigned long int uPI,
                 unsigned long int uSecondaryPI)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("+bSavePreset Index="),
            DLT_INT(cElementID),DLT_STRING("band="),DLT_INT(eBand),
            DLT_STRING("frequency ="),DLT_UINT(uFrequency),
            DLT_STRING("PI ="),DLT_UINT(uPI), DLT_STRING("Sec PI ="),
            DLT_UINT(uSecondaryPI));
    bool bRet = true;
    
    midw_fi_tcl_e8_Preset_Action preset_action;
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();
    poTunerMasterClientHandlerObj->vSetSavePresetState(true);
    if(uFrequency == 0 || uPI == 0)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Frequency equal to 0"));
        preset_action.enType = midw_fi_tcl_e8_Preset_Action::
                FI_EN_TUNMSTR_PRESETSAVE;
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("Frequency not equal to 0. Sending error"));

        char sErrMsg[] = "Only current station can be saved in preset.";
        vSendSavePresetError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED,sErrMsg);
        return FALSE;
    }

    midw_fi_tcl_e8_List List;
    midw_fi_tcl_e8_Band Band;

    if(cElementID > 0 && cElementID <= 27)
    {
        List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
    }
    else
    {
        char sErrMsg[] = "Index out of Range.";
        vSendSavePresetError(AP_TUNER_ERROR_BAD_PARAMS,sErrMsg);
        return FALSE;
    }

    Band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    uFrequency = uFrequency/1000;
    bRet = poTunerMasterClientHandlerObj->sendFID_TUNMSTR_S_PRESET_HANDLINGMStart(
                preset_action,(unsigned int)cElementID,List,
                Band,(tU32)uFrequency,(tU32)uPI,(tU16)uSecondaryPI);
    if(!bRet)
    {
        char sErrMsg[] = "Internal Error: Save Preset failed.";
        vSendSavePresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,sErrMsg);
        return FALSE;
    }
    return TRUE;
}

/******************************************************************************
 * Function:     bTuneToPreset
 * Description:  Wrapper method to call tune to an element in preset list
 * Parameters:   index, band
 * Return:       bool
 *****************************************************************************/
bool bTuneToPreset(unsigned char cElementID,
                   ApTunerBand eBand)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("bTuneToPreset: Band:"),
            DLT_INT(eBand),DLT_STRING("Index:"),DLT_INT(cElementID));

    unsigned int uElementID = cElementID;
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Preset_Action preset_action;
    preset_action.enType =
            midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL;

    midw_fi_tcl_e8_List List;
    midw_fi_tcl_e8_Band Band;

    if(cElementID > 0 && cElementID <= 27)
    {
        List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
    }
    else
    {
        vSendTuneToPresetError(AP_TUNER_ERROR_BAD_PARAMS);
        return FALSE;
    }

    switch(eBand)
    {
    case AP_TUNER_BAND_AM:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
        break;

    case AP_TUNER_BAND_FM:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
        break;

    case AP_TUNER_BAND_SW:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bTuneToPreset: Band Not yet supported!"));
        vSendTuneToPresetError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return false;
        break;

    case AP_TUNER_BAND_LW:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
        break;

    case AP_TUNER_BAND_DAB:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("bTuneToPreset:AP_TUNER_BAND_DAB"));
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
        break;

    case AP_TUNER_BAND_DRM:
        break;

    default:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bTuneToPreset: Invalid Band!"));

        vSendTuneToPresetError(AP_TUNER_ERROR_BAD_PARAMS);
        return false;
    }
    bool bRet =
            poTunerMasterClientHandlerObj->sendFID_TUNMSTR_S_PRESET_HANDLINGMStart(
                preset_action,(tU8)uElementID,List,Band,
                0,0,0);
    if(!bRet)
    {
        vSendTuneToPresetError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        return FALSE;
    }

    return TRUE;
}

/******************************************************************************
 * Function:     vScan
 * Description:  Wrapper method for search station
 * Parameters:   void
 * Return:       void
 *****************************************************************************/

void vScan()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vScan"));
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    if(current_band.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
    {
        FC_Gateway_TunerDABClientHandler *poTunerDABClientHandlerObj =
                procgenericgateway_tclMainApp::
                poGetInstance()->poGetTunerDABClientHandler();
        if(poTunerDABClientHandlerObj != NULL)
        {
            midw_ext_fi_tcl_e8_DAB_TestOperation e8Operation;
            e8Operation.enType = midw_ext_fi_tcl_e8_DAB_TestOperation::FI_EN_TUNE_ENSEMBLE;
            tU32 u32Param1 = 3;
            tU32 u32Param2 = poTunerDABClientHandlerObj->u32GetCurrentFrequency();
            tU32 u32Param3 = 1;
            poTunerDABClientHandlerObj->sendFID_DAB_S_TEST_OPERATIONMStart(e8Operation,u32Param1,u32Param2,
                                                                           u32Param3,CMD_CNTR_SCAN_OPRN);
        }
    }
    else
    {
        FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();

        midw_fi_tcl_e8_Tun_TunerHeader tunerHeader;
        tunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;

        midw_fi_tcl_e8_Tun_TunerSeek oSeekType;
        oSeekType.enType =
                midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY;

        poTunerClientHandlerObj->sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(
                    oSeekType,
                    tunerHeader,
                    0);
        poTunerClientHandlerObj->vSetSearchState(true);
    }
}

/******************************************************************************
 * Function:     bCancelSearch
 * Description:  Wrapper method for cancel search stations
 * Parameters:   void
 * Return:       bool
 *****************************************************************************/
bool bCancelSearch()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bCancelSearch"));

    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();
    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    if(current_band.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
    {
        //return error for now
        vSendCancelSearchStnError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return FALSE;
    }
    else
    {
        FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();
        
        if(poTunerClientHandlerObj->bGetSearchState())
        {
            poTunerClientHandlerObj->vSetCancelState(true);
        }
        else
        {
            vSendCancelSearchStnError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
            return FALSE;
        }

        midw_fi_tcl_e8_Tun_TunerHeader tunerHeader;

        tunerHeader.enType =
                midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;

        midw_fi_tcl_e8_Tun_TunerSeek oSeekType;
        oSeekType.enType = midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF;
        bool bRet =
                poTunerClientHandlerObj->sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(
                    oSeekType,
                    tunerHeader,
                    0);
        if(!bRet)
        {
            vSendCancelSearchStnError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            return FALSE;
        }
    }
    return TRUE;
}

/******************************************************************************
 * Function:     bSeekToNextStation
 * Description:  Wrapper method for seeking to next/prev station
 * Parameters:   direction
 * Return:       bool
 *****************************************************************************/
bool bSeekToNextStation(guchar arg_direction)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSeekToNextStation"));
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSeekToNextStation: band = "),
            DLT_INT(current_band.enType));

    if(current_band.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(" Current band is DAB"));
        FC_Gateway_TunerDABClientHandler *poTunerDABClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerDABClientHandler();

        midw_ext_fi_tcl_e8_DAB_TuneCmd oTuneDirection;
        switch(arg_direction)
        {
        case AP_TUNER_DIRECTION_DOWN: //next
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Next"));
            oTuneDirection.enType =
                    midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_NEXT;
            break;

        case AP_TUNER_DIRECTION_UP: //prev
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Prev"));
            oTuneDirection.enType =
                    midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_PREV;
            break;

        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("Invalid direction"));
            return false;
        }
        poTunerDABClientHandlerObj->sendFID_DAB_S_SEEK_SERVICEMStart(
                    oTuneDirection);
    }
    else
    {
        FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();

        midw_fi_tcl_e8_Tun_TunerHeader tunerHeader;
        tunerHeader.enType =
                midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;

        midw_fi_tcl_e8_Tun_TunerSeek oSeekType;

        switch(arg_direction)
        {
        case AP_TUNER_DIRECTION_DOWN: //next
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Next"));
            oSeekType.enType =
                    midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_AUTO;
            break;

        case AP_TUNER_DIRECTION_UP: //prev
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Prev"));
            oSeekType.enType =
                    midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_AUTO;
            break;

        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("Invalid direction"));
            return false;
            break;
        }
        poTunerClientHandlerObj->sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(
                    oSeekType,tunerHeader,0);
        poTunerClientHandlerObj->vSetSeekState(true);
    }
    return TRUE;
}

/******************************************************************************
 * Function:     bCancelSeek
 * Description:  Wrapper method for cancel seek station
 * Parameters:   void
 * Return:       bool
 *****************************************************************************/
bool bCancelSeek()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bCancelSeek"));
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();
    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    if(current_band.enType != midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
    {
        FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();
        
        if(poTunerClientHandlerObj->bGetSeekState())
        {
            poTunerClientHandlerObj->vSetCancelState(true);
        }
        else
        {
            vSendCancelSeekError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
            return false;
        }

        midw_fi_tcl_e8_Tun_TunerHeader tunerHeader;
        tunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;

        midw_fi_tcl_e8_Tun_TunerSeek oSeekType;
        oSeekType.enType = midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF;

        bool bRet =
                poTunerClientHandlerObj->sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(
                    oSeekType,
                    tunerHeader,
                    0);
        if(!bRet)
        {
            vSendCancelSeekError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        }
        return bRet;
    }
    else
    {
        vSendCancelSeekError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return false;
    }
}

/******************************************************************************
 * Function:     vActivateSeamlessSwitch
 * Description:  Wrapper method for DAB-FM linking
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/

tVoid vActivateSeamlessSwitch(bool bActivate)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vActivateSeamlessSwitch()"),
            DLT_INT( (unsigned int)bActivate));

    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_b8_ModeType oMode;
    if(bActivate)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("Activate Seemless switching ON"));
        oMode.u8Value = 1;
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("Activate Seemless switching OFF"));
        oMode.u8Value = 0;
    }

    poTunerMasterClientHandlerObj->sendFID_TUNMSTR_S_MTC_SETMODEStart(oMode);

}

bool bSetFrequency(unsigned int frequency,ApTunerBand eBand)
{
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Band Band;

    switch(eBand)
    {
    case AP_TUNER_BAND_AM:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
        break;

    case AP_TUNER_BAND_FM:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
        break;

    case AP_TUNER_BAND_SW:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bSetFrequency: Band Not yet supported!"));
        vSendSetFreqError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return false;
        break;

    case AP_TUNER_BAND_LW:
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
        break;

    case AP_TUNER_BAND_DAB:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("bTuneToPreset:AP_TUNER_BAND_DAB"));
        Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
        break;

    case AP_TUNER_BAND_DRM:
        vSendSetFreqError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        break;

    default:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bTuneToPreset: Invalid Band!"));
        vSendSetFreqError(AP_TUNER_ERROR_BAD_PARAMS);
        return false;
    }

    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    if(current_band.enType != Band.enType)
    {
        if(!poTunerMasterClientHandlerObj->sendFID_TUNMSTR_S_STATION_SELECTIONStart(
                    Band,frequency/1000))
        {
            vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            return false;
        }
        bSetBand(eBand);
    }
    else
    {
        if(eBand == AP_TUNER_BAND_DAB)
        {
            bSetFrequencyDAB(frequency);
        }
        else
        {
            bSetFrequencyAMFM(frequency,eBand);
        }
    }

    return true;
}

/******************************************************************************
 * Function:     bSetBand
 * Description:  Wrapper method for cancel seek station
 * Parameters:   Tuner Band
 * Return:       bool
 *****************************************************************************/
bool bSetBand(ApTunerBand eband)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSetBand"));
    unsigned int iSourceID;
    GError *poError = NULL;

    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();

    if(!poTunerMasterClientHandlerObj->bGetAudioDBusConnectionState())
    {
        poTunerMasterClientHandlerObj->bSourceMapping();
    }

    switch(eband)
    {
    case AP_TUNER_BAND_AM:
        iSourceID = poTunerMasterClientHandlerObj->iGetSourceIdAM();
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSetBand: AM source "),DLT_INT(iSourceID));
        break;

    case AP_TUNER_BAND_FM:
        iSourceID = poTunerMasterClientHandlerObj->iGetSourceIdFM();
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSetBand: FM source "),DLT_INT(iSourceID));
        break;

    case AP_TUNER_BAND_DAB:
        iSourceID = poTunerMasterClientHandlerObj->iGetSourceIdDAB();
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSetBand: DAB source "),DLT_INT(iSourceID));
        break;

    case AP_TUNER_BAND_SW:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bSetBand: Band not supported!"));
        vSendSetBandError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return false;

    case AP_TUNER_BAND_LW:
        iSourceID = poTunerMasterClientHandlerObj->iGetSourceIdAM();
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSetBand: LW source "),DLT_INT(iSourceID));
        break;

    case AP_TUNER_BAND_DRM:
        iSourceID = poTunerMasterClientHandlerObj->iGetSourceIdDRM();
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSetBand: DRM source "),DLT_INT(iSourceID));
        break;

    default:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("bSetBand: Received band is invalid!"));

        vSendSetBandError(AP_TUNER_ERROR_UNKOWN);
        return false;
    }

    if(iSourceID == 0)
    {
        vSendSetBandError(AP_TUNER_ERROR_FUNC_NOT_SUPPORTED);
        return false;
    }
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSetBand: Calling connect"));

    GVariant *_ret;
    _ret = g_dbus_proxy_call_sync (
                poTunerMasterClientHandlerObj->poGetAudioGeniviProxy(),
                "Connect",
                g_variant_new ("(qq)",
                               iSourceID,
                               1),
                G_DBUS_CALL_FLAGS_NONE,
                -1,
                NULL,
                &poError);

    if(_ret != NULL)
    {
        g_variant_unref(_ret);
        _ret = NULL;
    }

    //return should be handled.
    if(poError != NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "FC_Gateway_TunerMasterClientHandler::connect: error: "),
                DLT_STRING(poError->message));

        vSendSetBandError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        g_clear_error(&poError);
        return false;
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                    "FC_Gateway_TunerMasterClientHandler::connect: Success"));
        vSendSetBandResult();
    }
    return true;
}

/******************************************************************************
 * Function:     bSetConfigurationSettings
 * Description:  Wrapper method for setting configurations
 * Parameters:   Gvariant
 * Return:       bool
 *****************************************************************************/
bool bSetConfigurationSettings(GVariant *configurations)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSetConfigurationSettings"));
    GVariantIter *iter;
    gchar *sSettingName = NULL;
    GVariant *value = NULL;
    const GVariantType *type;
    gboolean bValue;
    if(configurations == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("configurations Variant  is NULL, returning"));
        vSendSetConfigError(AP_TUNER_ERROR_BAD_PARAMS);
        return FALSE;
    }


    bool bIsValidVariant = true;

    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();
    
    FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();

    midw_fi_tcl_b32_AnnoType
            oAnnoType  = poTunerMasterClientHandlerObj->GetAnnoStatus();

    iter = g_variant_iter_new (configurations);
    while (g_variant_iter_loop (iter,"{&sv}",&sSettingName,&value))
    {
        if(sSettingName == NULL || value == NULL)
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("sSettingName or value is NULL, returning"));

            vSendSetConfigError(AP_TUNER_ERROR_BAD_PARAMS);
            if(iter != NULL)
            {
                g_variant_iter_free(iter);
            }
            return FALSE;
        }
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Iterator"),
                DLT_STRING(sSettingName));

        type = g_variant_get_type (value);

        if(g_variant_type_equal (type, G_VARIANT_TYPE_BOOLEAN))
        {
            bValue = g_variant_get_boolean (value);

        }
        else
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "bSetConfigurationSettings Error: Bad paramters"));
            vSendSetConfigError(AP_TUNER_ERROR_BAD_PARAMS);
            bIsValidVariant = false;
            if(iter != NULL)
            {
                g_variant_iter_free(iter);
            }
            return FALSE;
        }

        if(!g_strcmp0 (sSettingName,"AMActive"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                    DLT_STRING("bSetConfigurationSettings:AMActive value "),
                    DLT_INT(bValue));

            midw_fi_tcl_e8_Source e8Source;
            e8Source.enType = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM;
            poTunerMasterClientHandlerObj->sendFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMStart(
                        (tBool)bValue,e8Source);
        }
        else if(!g_strcmp0 (sSettingName,"HDRadio"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:HDRadiovalue "),
                    DLT_INT(bValue));
            poTunerClientHandlerObj->vSetHDRadio(bValue);
        }
        else if(!g_strcmp0 (sSettingName,"Region"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:Region value "),
                    DLT_INT(bValue));
            poTunerClientHandlerObj->vSetRegion(bValue);
        }
        else if(!g_strcmp0 (sSettingName,"TA"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:TA value "),
                    DLT_INT(bValue));
            vSetTA(bValue);
            oAnnoType.vSetTUNMSTR_ANNOTYPE_TA((tBool)bValue);
        }
        else if(!g_strcmp0 (sSettingName,"SeamlessSwitching"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:SeamlessSwitchin gvalue "),
                    DLT_INT(bValue));
            vActivateSeamlessSwitch(bValue);
        }
        else if(!g_strcmp0 (sSettingName,"TransportAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:TransportAnnouncementvalue ")
                    ,DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_TRANSPORT((tBool)bValue);
        }
        else if(!g_strcmp0 (sSettingName,"WarningAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:WarningAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_WARNING((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"NewsAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:NewsAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_NEWS((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"WeatherAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:WeatherAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_WEATHER((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"EventAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:EventAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_EVENT((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"MusicalEventAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:MusicalEventAnnouncement"
                        "value"),DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_SPECIALEVENT((tBool)bValue);
        }
        else if(!g_strcmp0 (sSettingName,"RadioInfoAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:RadioInfoAnnouncement value")
                    ,DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_PROGRAMME((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"SportAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:SportAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_SPORTS((tBool)bValue);

        }
        else if(!g_strcmp0 (sSettingName,"FinanceAnnouncement"))
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "bSetConfigurationSettings:FinanceAnnouncement value "),
                    DLT_INT(bValue));
            oAnnoType.vSetTUNMSTR_ANNOTYPE_FINANCE((tBool)bValue);
        }
        else
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "bSetConfigurationSettings Error: Bad paramters"));
            vSendSetConfigError(AP_TUNER_ERROR_BAD_PARAMS);
            bIsValidVariant = false;
            if(iter != NULL)
            {
                g_variant_iter_free(iter);
            }
            return FALSE;
        }
    }

    if(iter != NULL)
    {
        g_variant_iter_free(iter);
    }

    if(bIsValidVariant == true)
    {
        FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
                procgenericgateway_tclMainApp::
                poGetInstance()->poGetTunerMasterClientHandler();

        poTunerMasterClientHandlerObj->vActivateAnnouncementStart(oAnnoType);
        vSendSetConfigResult();
    }

    return TRUE;
}
#ifdef __cplusplus
}
#endif //__cplusplus

/******************************************************************************
 * Function:     vActivateAnnouncementStart
 * Description:  Wrapper function to activate announcement
 * Parameters:   midw_fi_tcl_b32_AnnoType
 * Return:       void
 *****************************************************************************/

void 
FC_Gateway_TunerMasterClientHandler::vActivateAnnouncementStart(
        midw_fi_tcl_b32_AnnoType b32AnnoType)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vActivateAnnouncementStart "),
            DLT_INT( b32AnnoType.u32Value));

    midw_fi_tcl_e8_Band
            current_band = getCurrentStateBand();

    midw_fi_tcl_b8_SourceAnno oAnnoSource;


    oAnnoSource.vSetTUNMSTR_ANNOSRC_FM(TRUE);
    oAnnoSource.vSetTUNMSTR_ANNOSRC_DAB(TRUE);

    sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart(
                b32AnnoType,
                oAnnoSource);
}


void FC_Gateway_TunerMasterClientHandler::onSrcChange(
        GDBusConnection *connection,
        const gchar *sender_name,
        const gchar *object_path,
        const gchar *interface_name,
        const gchar *signal_name,
        GVariant *parameters,
        gpointer user_data)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("TunerMaster :+"),
            DLT_STRING( __FUNCTION__));
#endif
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::
            poGetInstance()->poGetTunerMasterClientHandler();

    poTunerMasterClientHandlerObj->bSourceMapping();
}

bool FC_Gateway_TunerMasterClientHandler::bSubscribeForSourceChange()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("TunerMaster :+"),
            DLT_STRING( __FUNCTION__));
    GError          *poError = NULL;

    m_poAudioGeniviConnection = g_bus_get_sync(G_BUS_TYPE_SYSTEM,
                                               NULL, &poError);
    if (NULL == m_poAudioGeniviConnection)
    {
        if(poError != NULL)
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::connect: error: ")
                    ,DLT_STRING(poError->message));
            g_clear_error(&poError);
            return false;
        }

    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                    "FC_Gateway_TunerMasterClientHandler::"
                    "m_poAudioGeniviConnection is NOT NULL "));
    }

    m_poAudioGeniviProxy = g_dbus_proxy_new_sync(
                m_poAudioGeniviConnection,
                G_DBUS_PROXY_FLAGS_NONE,
                NULL,
                "org.genivi.audiomanager",
                "/org/genivi/audiomanager/CommandInterface",
                "org.genivi.audiomanager.CommandInterface",
                NULL,
                &poError);

    if (NULL != m_poAudioGeniviProxy)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("Created command plugin proxy"));
    }
    else
    {
        if(poError != NULL)
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerMasterClientHandler::connect: error: ")
                    ,DLT_STRING( poError->message));
            g_clear_error(&poError);
            return false;
        }
    }

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "bSubscribeForSourceChange:Subscribing for signal"));

    m_iSrcAddedSubscriptionID = g_dbus_connection_signal_subscribe (
                m_poAudioGeniviConnection,
                NULL,
                "org.genivi.audiomanager.CommandInterface",
                "SourceAdded",
                "/org/genivi/audiomanager/CommandInterface",
                NULL,
                G_DBUS_SIGNAL_FLAGS_NONE,
                FC_Gateway_TunerMasterClientHandler::onSrcChange,
                NULL,
                NULL);
    if(!m_iSrcAddedSubscriptionID)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "Error in subscription for signal Source Added"));
    }

    m_iSrcRemovedSubscriptionID = g_dbus_connection_signal_subscribe (
                m_poAudioGeniviConnection,
                NULL,
                "org.genivi.audiomanager.CommandInterface",
                "SourceRemoved",
                "/org/genivi/audiomanager/CommandInterface",
                NULL,
                G_DBUS_SIGNAL_FLAGS_NONE,
                FC_Gateway_TunerMasterClientHandler::onSrcChange,
                NULL,
                NULL);
    if(!m_iSrcRemovedSubscriptionID)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "Error in subscription for signal Source Removed"));
    }
    return true;
}


void FC_Gateway_TunerMasterClientHandler::vUnsubscribeForSourceChangeSignal()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING( __FUNCTION__));
    if((NULL != m_poAudioGeniviConnection) && (m_iSrcAddedSubscriptionID != 0))
    {
        g_dbus_connection_signal_unsubscribe (m_poAudioGeniviConnection,
                                              m_iSrcAddedSubscriptionID);
        m_iSrcAddedSubscriptionID = 0;
    }

    if((NULL != m_poAudioGeniviConnection)
            && (m_iSrcRemovedSubscriptionID != 0))
    {
        g_dbus_connection_signal_unsubscribe (m_poAudioGeniviConnection,
                                              m_iSrcRemovedSubscriptionID);
        m_iSrcRemovedSubscriptionID = 0;
    }

}

#ifdef __cplusplus
/******************************************************************************
* Function:    poGetTunerMasterInstance
* Description: function to get Tuner master client handler instance
* Parameters:  procgenericgateway_tclMainApp pointer
* Return:      FC_Gateway_TunerMasterClientHandler pointer
******************************************************************************/

FC_Gateway_TunerMasterClientHandler*
poGetTunerMasterInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    FC_Gateway_TunerMasterClientHandler* oTunerMasterObj  =
            FC_Gateway_TunerMasterClientHandler::getInstance(poMainAppl);

    return oTunerMasterObj;
}
#endif //__cplusplus
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
