

/*****************************************************************************
* FILE:         FC_Gateway_TunerDABClientHandler.cpp
* PROJECT:      G3G project
* SW-COMPONENT: genericgateway
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

// FC_Gateway_TunerDABClientHandlerIncludes: user specific code start
// FC_Gateway_TunerDABClientHandlerIncludes: user specific code end

#include "FC_Gateway_TunerDABClientHandler.h"
#include "FC_Gateway_TunerMasterClientHandler.h"


#include "Tuner_GenericClientInterface.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Tuner);

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(FC_Gateway_TunerDABClientHandler, ahl_tclBaseWork)

//Station Info
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_DAB_G_TUNER_STATUSOpStatus)

//Configurations
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_AVAILABILITY,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_DAB_G_AVAILABILITYOpStatus)

//Station Info
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_DAB_G_CHANNEL_INFOOpStatus)
//StationListChanged
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_DAB_G_LIST_UPDATEOpStatus)

//Station Info
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus)

//TuneToProgramID
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_DAB_S_SRV_SELECTOpMResult)

//seek
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_SERVICE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_DAB_S_SEEK_SERVICEOpMResult)


//SetFrequency
ON_MESSAGE_SVCDATA(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_DAB_S_TEST_OPERATIONOpMResult)
END_MSG_MAP()

FC_Gateway_TunerDABClientHandler* 
FC_Gateway_TunerDABClientHandler::m_poFC_Gateway_TunerDABClientHandler = NULL;
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************
 * Function:     getInstance
 * Description:  Gets the instance of TunerDABClientHandler
 * Parameters:   procgenericgateway_tclMainApp*
 * Return:       FC_Gateway_TunerDABClientHandler*
 *****************************************************************************/

FC_Gateway_TunerDABClientHandler* 
FC_Gateway_TunerDABClientHandler::getInstance(procgenericgateway_tclMainApp*
                                              poMainAppl)
{

    if(m_poFC_Gateway_TunerDABClientHandler == NULL)
    {
        m_poFC_Gateway_TunerDABClientHandler =
                new FC_Gateway_TunerDABClientHandler(poMainAppl);
    }

    return m_poFC_Gateway_TunerDABClientHandler;
}

/*******************************************************************************
*
* FUNCTION: FC_Gateway_TunerDABClientHandler::
*             FC_Gateway_TunerDABClientHandler(gateway_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
FC_Gateway_TunerDABClientHandler::FC_Gateway_TunerDABClientHandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler(
          (ahl_tclBaseOneThreadApp*)poMainAppl,
          MIDW_EXT_DABTUNERFI_C_U16_SERVICE_ID,
          MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION,
          MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MINORVERSION )
{                                     
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerDABClientHandler() entered."));

    // FC_Gateway_TunerDABClientHandlerConstructor: user specific code start
    m_poMainApp = poMainAppl;
    // FC_Gateway_TunerDABClientHandlerConstructor: user specific code end

    m_rStationInfo.u32Frequency = 0;
    m_rStationInfo.programID = 0;
    m_rStationInfo.fieldStrength = 0;
    m_rStationInfo.stationName.assign("");
    m_rStationInfo.stationText.assign("");
    m_rStationInfo.presetListID = 0;
    m_rStationInfo.programType = AP_TUNER_PT_UNDEFINED;
    m_bIsSeek = FALSE;
    m_bIsScan = FALSE;

    vAddAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS);
    vAddAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO);
    vAddAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO);
    vAddAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_AVAILABILITY);
    vAddAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE);

}

/*******************************************************************************
*
* FUNCTION: FC_Gateway_TunerDABClientHandler::
*             ~FC_Gateway_TunerDABClientHandler(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
FC_Gateway_TunerDABClientHandler::~FC_Gateway_TunerDABClientHandler(tVoid)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("~FC_Gateway_TunerDABClientHandler() entered."));
    vRemoveAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS);
    vRemoveAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO);
    vRemoveAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO);
    vRemoveAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_AVAILABILITY);
    vRemoveAutoRegisterForProperty(
                MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE);


    // FC_Gateway_TunerDABClientHandlerDestructor: user specific code start
    // FC_Gateway_TunerDABClientHandlerDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid FC_Gateway_TunerDABClientHandler::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vOnServiceAvailable() entered."));

    // FC_Gateway_TunerDABClientHandlervOnServiceAvailable: user specific code start
    // FC_Gateway_TunerDABClientHandlervOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid FC_Gateway_TunerDABClientHandler::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vOnServiceUnavailable() entered."));

    // FC_Gateway_TunerDABClientHandlervOnServiceUnavailable: user specific code start
    // FC_Gateway_TunerDABClientHandlervOnServiceUnavailable: user specific code end
}

/******************************************************************************
 * Function:     vHandleFID_DAB_G_TUNER_STATUSOpStatus
 * Description:  Handling of property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_G_TUNER_STATUSOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                onFID_DAB_G_TUNER_STATUSStatus(oStatus.TunerStatus);

                // vHandleFID_DAB_G_TUNER_STATUSOpStatus: user specific code start
                // vHandleFID_DAB_G_TUNER_STATUSOpStatus: user specific code end
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_G_TUNER_STATUSOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}


/******************************************************************************
 * Function:     onFID_DAB_G_TUNER_STATUSStatus
 * Description:  On status update of
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS
 * Parameters:   midw_ext_fi_tcl_DAB_TunerStatus
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::onFID_DAB_G_TUNER_STATUSStatus(
        midw_ext_fi_tcl_DAB_TunerStatus TunerStatus)
{

    /*DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "onFID_DAB_G_TUNER_STATUSStatus"));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "Status"),DLT_INT(TunerStatus.e8TunerActivityType.enType));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek state: SearchState:"),
            DLT_INT(m_bIsSeek),DLT_INT(m_bIsScan));*/

    // onFID_DAB_G_TUNER_STATUSStatus: user specific code start
    switch(TunerStatus.e8TunerActivityType.enType)
    {
    case midw_ext_fi_tcl_e8_DAB_TunerActivityType::FI_EN_DAB_ACTIVITYTYPE_NORMAL:
        if(m_bIsSeek)
        {
            m_bIsSeek = FALSE;
            vSendSeekStatus(AP_TUNER_SEEK_REQ_COMPLETED);
        }
        else if(m_bIsScan)
        {
            m_bIsScan = FALSE;
            vSendSearchStatus(AP_TUNER_SEARCH_REQ_COMPLETED);

        }
        else
        {
            //Do nothing
        }
        break;
    case midw_ext_fi_tcl_e8_DAB_TunerActivityType::FI_EN_DAB_ACTIVITYTYPE_SEEK:
        m_bIsScan = TRUE;
        vSendSearchStatus(AP_TUNER_SEARCH_REQ_INPROGRESS);
        break;
    case midw_ext_fi_tcl_e8_DAB_TunerActivityType::FI_EN_DAB_ACTIVITYTYPE_SERVICESEEK:
        m_bIsSeek = TRUE;
        vSendSeekStatus(AP_TUNER_SEEK_REQ_INPROGRESS);
        break;
    default:
        break;
    }
    m_rStationInfo.u32Frequency = TunerStatus.FreqTuned.u32Frequency*1000;
    m_rStationInfo.fieldStrength = TunerStatus.u8SignalQuality;
    vUpdateStationInfo(m_rStationInfo);
    // onFID_DAB_G_TUNER_STATUSStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_DAB_G_AVAILABILITYOpStatus
 * Description:  Handling of property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_AVAILABILITY
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_G_AVAILABILITYOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus  oStatus;

            if (oInMsg.s32GetData(oStatus,
                                  MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_G_AVAILABILITYOpStatus():"
                            "Status update message received for "
                            "'FI_C_U16_FID_DAB_G_AVAILABILITY'(FID: 0x0120)!"));
#endif
                onFID_DAB_G_AVAILABILITYStatus(oStatus.bIsDABAvailable,
                                               oStatus.e8SourceState);

                // vHandleFID_DAB_G_AVAILABILITYOpStatus: user specific code start
                // vHandleFID_DAB_G_AVAILABILITYOpStatus: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_G_AVAILABILITYOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_G_TUNER_STATUSStatus
 * Description:  On status update of
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS
 * Parameters:   midw_ext_fi_tcl_DAB_TunerStatus
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::onFID_DAB_G_AVAILABILITYStatus(
        tBool bIsDABAvailable,
        midw_ext_fi_tcl_e8_DAB_SourceState
        e8SourceState)
{

    // onFID_DAB_G_AVAILABILITYStatus: user specific code start
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "onFID_DAB_G_AVAILABILITYStatus: DAB Availability "),
            DLT_INT( bIsDABAvailable));

    tclConfigSettings *poConfigSettings = tclConfigSettings::getInstance();
    poConfigSettings->vSetDABAvailability(bIsDABAvailable);
    // onFID_DAB_G_AVAILABILITYStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_DAB_G_CHANNEL_INFOOpStatus
 * Description:  Handling of property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_G_CHANNEL_INFOOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_G_CHANNEL_INFOOpStatus():"
                            "Status update message received for"
                            "FI_C_U16_FID_DAB_G_CHANNEL_INFO' (FID: 0x0340)"));
#endif

                onFID_DAB_G_CHANNEL_INFOStatus(oStatus.ChannelInfo);

                // vHandleFID_DAB_G_CHANNEL_INFOOpStatus: user specific code start
                // vHandleFID_DAB_G_CHANNEL_INFOOpStatus: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_G_CHANNEL_INFOOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_G_CHANNEL_INFOStatus
 * Description:  on status update of property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerDABClientHandler::onFID_DAB_G_CHANNEL_INFOStatus(
        midw_ext_fi_tcl_DAB_ChannelInfo& ChannelInfo)
{

    // onFID_DAB_G_CHANNEL_INFOStatus: user specific code start
    m_rStationInfo.band = AP_TUNER_BAND_DAB;
    m_rStationInfo.programID = ChannelInfo.u32ServId;
    m_rStationInfo.stationName = ChannelInfo.ServiceLabel.sLabel.szValue;

    if(ChannelInfo.rRadioText.bValid)
        m_rStationInfo.stationText =
                ChannelInfo.rRadioText.sRadioTextData.szValue;
    else
        m_rStationInfo.stationText.clear();

    m_rStationInfo.presetListID = ChannelInfo.u8PresetListElementID;
    vUpdateStationInfo(m_rStationInfo);
    // onFID_DAB_G_CHANNEL_INFOStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_DAB_G_LIST_UPDATEOpStatus
 * Description:  Handler for property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE
 * Parameters:   amt_tclServiceData* poMessage
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_G_LIST_UPDATEOpStatus(
        amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "vHandleFID_DAB_G_LIST_UPDATEOpStatus()"));
#endif
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus  oStatus;

            if (oInMsg.s32GetData(oStatus,
                                  MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "vHandleFID_DAB_G_LIST_UPDATEOpStatus():"
                            "Status update message received for "
                            "'MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE'"
                            "(FID: 0x0601)!"));
#endif
                _ChangedChnList_FID_DAB_G_LIST_UPDATEStatus =
                        oStatus.AvailSrvList;

                onFID_DAB_G_LIST_UPDATEStatus(oStatus);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "vHandleFID_DAB_G_LIST_UPDATEOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_G_LIST_UPDATEStatus
 * Description:  On status update of property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE
 * Parameters:   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus
 * Return:       void
 *****************************************************************************/

tVoid 
FC_Gateway_TunerDABClientHandler::onFID_DAB_G_LIST_UPDATEStatus(
        midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus oStatus)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "onFID_DAB_G_LIST_UPDATEStatus() List size "),
            DLT_INT( oStatus.AvailSrvList.size()));
#endif
    std::vector <midw_ext_fi_tcl_DAB_ChnListElement,
            std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> >::iterator
            itrSrvList = oStatus.AvailSrvList.begin();

    std::vector<unsigned int> stationList;

    for(;itrSrvList!=oStatus.AvailSrvList.end();itrSrvList++)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("DAB ID ="),
                DLT_INT( itrSrvList->u32DABId));

        stationList.push_back(itrSrvList->u32DABId);
    }
    vHandleUpdateStationListDataHandler(AP_TUNER_BAND_DAB, stationList);
}

/******************************************************************************
 * Function:     vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus
 * Description:  Handler for property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus
                    oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus():"
                            "Status update message received for "
                            "'FI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO'"
                            "(FID: 0x0310)!"));
#endif

                onFID_DAB_G_ACTIVE_SERVICE_INFOStatus(oStatus.ServiceInfo);

                // vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus: user specific code start
                // vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "vHandleFID_DAB_G_ACTIVE_SERVICE_INFOOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_G_ACTIVE_SERVICE_INFOStatus
 * Description:  Status update for property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::onFID_DAB_G_ACTIVE_SERVICE_INFOStatus(
        midw_ext_fi_tcl_DAB_ServiceInfo& ServiceInfo)
{
    // onFID_DAB_G_ACTIVE_SERVICE_INFOStatus: user specific code start
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("onFID_DAB_G_ACTIVE_SERVICE_INFOStatus PTY : "),
            DLT_INT( ServiceInfo.u8PTYCode));
#endif
    m_rStationInfo.programType = (ApTunerProgramType)ServiceInfo.u8PTYCode;
    vUpdateStationInfo(m_rStationInfo);
    // onFID_DAB_G_ACTIVE_SERVICE_INFOStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_DAB_S_TEST_OPERATIONOpMResult
 * Description:  Handler for method result
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_S_TEST_OPERATIONOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "vHandleFID_DAB_S_TEST_OPERATIONOpMResult()"));
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "vHandleFID_DAB_S_TEST_OPERATIONOpMResult():"
                            "Method result update message received for"
                            "'FI_C_U16_FID_DAB_S_TEST_OPERATION' FID: 0x0002"));

                onFID_DAB_S_TEST_OPERATIONMResult(oMResult.e8MethodResult,poMessage->u16GetCmdCounter());
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "vHandleFID_DAB_S_TEST_OPERATIONOpMResult:"
                            "Received message is invalid!"));

                vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            }
            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_S_TEST_OPERATIONMResult
 * Description:  on method result of
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION
 * Parameters:   midw_ext_fi_tcl_e8_DAB_Response
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::onFID_DAB_S_TEST_OPERATIONMResult(
        midw_ext_fi_tcl_e8_DAB_Response
        e8MethodResult, tU16 u16CmdCntr)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "onFID_DAB_S_TEST_OPERATIONMResult()"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Set Frequency Response state :"),
            DLT_INT( e8MethodResult.enType));
    switch(e8MethodResult.enType)
    {
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK:
		if(u16CmdCntr == CMD_CNTR_SETFREQ_OPRN)
			vSendSetFreqResult();
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_FAILED:
	    if(u16CmdCntr == CMD_CNTR_SETFREQ_OPRN) 
		vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
		else
		vSendSearchStatus(AP_TUNER_SEARCH_REQ_FAIL);
		
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_NOT_AVAILABLE:
        if(u16CmdCntr == CMD_CNTR_SETFREQ_OPRN)  
		vSendSetFreqError(AP_TUNER_ERROR_UNKOWN);
	    else
		vSendSearchStatus(AP_TUNER_SEARCH_REQ_NOT_AVAILABLE);
        break;
    default:
        if(u16CmdCntr == CMD_CNTR_SETFREQ_OPRN)
		{	
	        vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
	    }
        break;
    }

}

/******************************************************************************
 * Function:     vHandleFID_DAB_S_SRV_SELECTOpMResult
 * Description:  Handler for property
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid 
FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_S_SRV_SELECTOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "vHandleFID_DAB_S_SRV_SELECTOpMResult()"));
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ||
             poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "vHandleFID_DAB_S_SRV_SELECTOpMResult():"
                            "Method result update message received for"
                            "'MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT'"));

                onFID_DAB_S_SRV_SELECTMResult(oMResult.e8MethodResult);

                // vHandleFID_DAB_S_SRV_SELECTOpMResult: user specific code start
                // vHandleFID_DAB_S_SRV_SELECTOpMResult: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "vHandleFID_DAB_S_SRV_SELECTOpMResult:"
                            "Received message is invalid!"));

                vSendTuneToPIError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_S_SRV_SELECTMResult
 * Description:  on method result of
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT
 * Parameters:   midw_ext_fi_tcl_e8_DAB_Response
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::onFID_DAB_S_SRV_SELECTMResult(
        midw_ext_fi_tcl_e8_DAB_Response e8MethodResult)
{

    // onFID_DAB_S_SRV_SELECTMResult: user specific code start
    switch(e8MethodResult.enType)
    {
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK:
        vSendTuneToPIResult();
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_FAILED:
        vSendTuneToPIError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_NOT_AVAILABLE:
        vSendTuneToPIError(AP_TUNER_ERROR_UNKOWN);
        break;
    default:
        vSendTuneToPIError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
        break;
    }
    // onFID_DAB_S_SRV_SELECTMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_DAB_S_SEEK_SERVICEOpMResult
 * Description:  Handler for property
                 MIDW_EXT_DABTUNERFID_DAB_S_SEEK_SERVICE
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::vHandleFID_DAB_S_SEEK_SERVICEOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "vHandleFID_DAB_S_SEEK_SERVICEOpMResult()"));
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ||
             poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_S_SEEK_SERVICEOpMResult():"
                            "Method result update message received for"
                            "'MIDW_EXT_DABTUNERFID_DAB_S_SEEK_SERVICE'!"));

                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("SeekStatus : "),
                        DLT_INT( oMResult.e8MethodResult.enType));

                onFID_DAB_S_SEEK_SERVICEMResult(oMResult.e8MethodResult);

                // vHandleFID_DAB_S_SEEK_SERVICEOpMResult: user specific code start
                // vHandleFID_DAB_S_SEEK_SERVICEOpMResult: user specific code end
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerDABClientHandler::"
                            "vHandleFID_DAB_S_SEEK_SERVICEOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_DAB_S_SEEK_SERVICEMResult
 * Description:  on method result of
                 MIDW_EXT_DABTUNERFID_DAB_S_SEEK_SERVICE
 * Parameters:   midw_ext_fi_tcl_e8_DAB_Response
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerDABClientHandler::onFID_DAB_S_SEEK_SERVICEMResult(
        midw_ext_fi_tcl_e8_DAB_Response oSeekResponse)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerDABClientHandler::"
                       "onFID_DAB_S_SEEK_SERVICEMResult()"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Response : "),
            DLT_INT( oSeekResponse.enType));

    switch(oSeekResponse.enType)
    {
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK:
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_FAILED:
        vSendSeekStatus(AP_TUNER_SEEK_REQ_FAIL);
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_NOT_AVAILABLE:
        vSendSeekStatus(AP_TUNER_SEEK_REQ_NOT_AVAILABLE);
        break;
    case midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_INPROCESS:
        break;
    default:
        break;
    }
}

/******************************************************************************
 * Function:     sendFID_DAB_S_SEEK_SERVICEMStart
 * Description:  send CCA method call
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_SERVICE
 * Parameters:   midw_ext_fi_tcl_e8_DAB_TuneCmd
 * Return:       tBool
 *****************************************************************************/
tBool FC_Gateway_TunerDABClientHandler::sendFID_DAB_S_SEEK_SERVICEMStart(
        midw_ext_fi_tcl_e8_DAB_TuneCmd oTuneDirection)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "sendFID_DAB_S_SEEK_SERVICEMStart"));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart  oMStart;
        oMStart.enTuneCmd = oTuneDirection;
        fi_tclVisitorMessage oOutMessage(oMStart);

        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) 0,
                    (tU16) MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_SERVICE,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "sendFID_DAB_S_SEEK_SERVICEMStart():"
                        "enPostMessage failed for FuncId -"),
                    DLT_UINT(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_SERVICE),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
            bRetVal = TRUE;
        }
        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_DAB_S_SRV_SELECTMStart
 * Description:  send CCA method call
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT
 * Parameters:   midw_ext_fi_tcl_e8_DAB_ChnSelectMode, uint32 value, bool
 * Return:       tBool
 *****************************************************************************/
tBool FC_Gateway_TunerDABClientHandler::sendFID_DAB_S_SRV_SELECTMStart(
        midw_ext_fi_tcl_e8_DAB_ChnSelectMode SelectMode,
        tU32 u32Value,
        tBool bNegative)
{
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart  oMStart;
        
        //the data content
        oMStart.SelectMode = SelectMode;
        oMStart.u32Value = u32Value;
        oMStart.bNegative = bNegative;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerDABClientHandler::"
                        "sendFID_DAB_S_SRV_SELECTMStart():enPostMessage failed"
                        "for FuncId -"),
                    DLT_UINT(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_DAB_S_TEST_OPERATIONMStart
 * Description:  send CCA method call
                 MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION
 * Parameters:   midw_ext_fi_tcl_e8_DAB_TestOperation, frequency
 * Return:       tBool
 *****************************************************************************/

tBool FC_Gateway_TunerDABClientHandler::sendFID_DAB_S_TEST_OPERATIONMStart(
        midw_ext_fi_tcl_e8_DAB_TestOperation oTestOperation,
        tU32 u32Param1, tU32 u32Param2, tU32 u32Param3, tU16 u16CmdCntr)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerDABClientHandler::"
                "sendFID_DAB_S_TEST_OPERATIONMStart"));

    tBool bRetVal = FALSE;

    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart oMStart;
        oMStart.enOperation = oTestOperation;
        oMStart.u32Value1 = u32Param1;
        oMStart.u32Value2 = u32Param2;
		oMStart.u32Value3 = u32Param3;
		
        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) u16CmdCntr,
                    (tU16) MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        // Post message - since the second parameter is true we need not explicitly delete the message
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerDABClientHandler::"
                        "sendFID_DAB_S_TEST_OPERATIONMStart(): enPostMessage"
                        "failed for FuncId -"),
                    DLT_UINT(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION)
                    ,DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
            bRetVal = TRUE;
        }
        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     bGetServiceList
 * Description:  gets the updated station list
 * Parameters:   void
 * Return:       tBool
 *****************************************************************************/
bool FC_Gateway_TunerDABClientHandler::bGetServiceList()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bGetServiceList"));
    std::vector<unsigned int> stationList;
    if(_ChangedChnList_FID_DAB_G_LIST_UPDATEStatus.empty())
    {
        char sErrMsg[] = "No Stations Available.List empty";
        vSendGetStationListError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,
                                 sErrMsg);
        return FALSE;
    }
    for( std::vector<midw_ext_fi_tcl_DAB_ChnListElement,
         std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> >::iterator
         iIterator =  _ChangedChnList_FID_DAB_G_LIST_UPDATEStatus.begin();
         iIterator !=  _ChangedChnList_FID_DAB_G_LIST_UPDATEStatus.end();
         ++iIterator)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("DAB ID ="),
                DLT_INT( iIterator->u32DABId));

        stationList.push_back(iIterator->u32DABId);

    }
    vHandleGetStationListDataHandler(stationList);
    return true;
}


tU32 FC_Gateway_TunerDABClientHandler::u32GetCurrentFrequency()
{
	DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+u32GetCurrentFrequency"));
	return m_rStationInfo.u32Frequency/1000;
}

#ifdef __cplusplus
extern "C"
{
#endif

/******************************************************************************
 * Function:     bGetDABStationList
 * Description:  Wrapper function for station list
 * Parameters:   void
 * Return:       tBool
 *****************************************************************************/
bool bGetDABStationList()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bGetDABStationList"));
    FC_Gateway_TunerDABClientHandler *poTunerDABClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerDABClientHandler();
    poTunerDABClientHandlerObj->bGetServiceList();
    return TRUE;
}

/******************************************************************************
 * Function:     bSetFrequencyDAB
 * Description:  Wrapper function for set frequency in DAB
 * Parameters:   int frequency
 * Return:       tBool
 *****************************************************************************/
bool bSetFrequencyDAB(unsigned int frequency)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSetFrequencyDAB freq "),
            DLT_INT(frequency));

    FC_Gateway_TunerDABClientHandler *poTunerDABClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerDABClientHandler();

    midw_ext_fi_tcl_e8_DAB_TestOperation e8Operation;
    e8Operation.enType =
            midw_ext_fi_tcl_e8_DAB_TestOperation::FI_EN_TUNE_FREQUENCY;
    frequency = frequency/1000;  //convert to kHz


    return poTunerDABClientHandlerObj->sendFID_DAB_S_TEST_OPERATIONMStart(
                e8Operation,
                frequency,
				0,0,CMD_CNTR_SETFREQ_OPRN);
}

/******************************************************************************
 * Function:     bTuneToPI
 * Description:  Wrapper function for tune to a programID
 * Parameters:   int program_id
 * Return:       tBool
 *****************************************************************************/
bool bTuneToPI(unsigned int program_id)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bTuneToPI PI "),
            DLT_INT(program_id));

    FC_Gateway_TunerDABClientHandler *poTunerDABClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerDABClientHandler();

    midw_ext_fi_tcl_e8_DAB_ChnSelectMode oSelectMode;
    oSelectMode.enType =
            midw_ext_fi_tcl_e8_DAB_ChnSelectMode::FI_EN_DAB_CHNSELECTMODE_PSDI;

    poTunerDABClientHandlerObj->sendFID_DAB_S_SRV_SELECTMStart(oSelectMode,
                                                               program_id,
                                                               FALSE);
    return TRUE;
}

#ifdef __cplusplus
}
#endif //__cplusplus

// FC_Gateway_TunerDABClientHandlergateway_ClientTuner_dab: user specific code start
/******************************************************************************
* Function:    poGetTunerDABInstance
* Description: function to get Tuner DAB client handler instance
* Parameters:  procgenericgateway_tclMainApp pointer
* Return:      cea_FC_Gateway_TunerClientHandler pointer
******************************************************************************/

FC_Gateway_TunerDABClientHandler*
poGetTunerDABInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    FC_Gateway_TunerDABClientHandler* oTunerDABObj  =
            FC_Gateway_TunerDABClientHandler::getInstance(poMainAppl);

    return oTunerDABObj;
}
// FC_Gateway_TunerDABClientHandlergateway_ClientTuner_dab: user specific code end

//EOF
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
