/*******************************************************************************
*
* FILE:          fc_gateway_tcl_clienthandler.cpp
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for Tuner
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "FC_Gateway_TunerClientHandler.h"
#include "procgenericgateway_tclMainApp.h"

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define DP_S_IMPORT_INTERFACE_FI 
#include "dp_generic_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_DECLARE_CONTEXT(AGW_Tuner);

#include "Tuner_GenericClientInterface.h"


/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(FC_Gateway_TunerClientHandler, ahl_tclBaseWork)

//StationListChange + get station list
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus)

//StationInfo - Radio Text
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_RADIO_TEXTOpStatus)

//StationInfo
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_ATSTATIONINFOOpStatus)

//ConfigurationSettings - HDRadio : property update
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_DEMODULATION_SWITCH_STATUSOpStatus)

//ConfigurationSettings - Region : property update
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_SET_RDSREGOpStatus)

//stationListChanged - Yes or No
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus)

//TUNE
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_ATFREQUENCYOpMResult)

ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleFID_TUN_S_ATFREQUENCYOpMResult)

//SEEK ; CANCELSEEK ; SearchAvailableStations(SCAN) ; CANCELSEARCHSTATION
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult)

ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleFID_TUN_S_SET_FEATUREOpMResult)

//SETFREQUENCY
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult)


//Gets station list
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult)

ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult)

//Close station list
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_STATIONLIST_EXITOpMResult)

////ConfigurationSettings - TA: set
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult)

//ConfigurationSettings - HDRadio: set
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH ,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_SET_DEMODULATION_SWITCHOpMResult)

//ConfigurationSettings - Region : set
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleFID_TUN_S_SET_FEATUREOpMResult)

//Seek Status
ON_MESSAGE_SVCDATA(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleFID_TUN_G_ATSEEKOpStatus)

END_MSG_MAP()


FC_Gateway_TunerClientHandler*
FC_Gateway_TunerClientHandler::m_poFC_Gateway_TunerClientHandler = NULL;

/******************************************************************************
 * Function:     getInstance
 * Description:  Gets the instance of TunerDABClientHandler
 * Parameters:   procgenericgateway_tclMainApp*
 * Return:       FC_Gateway_TunerDABClientHandler*
 *****************************************************************************/
FC_Gateway_TunerClientHandler*
FC_Gateway_TunerClientHandler::getInstance(procgenericgateway_tclMainApp*
                                           poMainAppl)
{

    if(m_poFC_Gateway_TunerClientHandler == NULL)
    {
        m_poFC_Gateway_TunerClientHandler =
                new FC_Gateway_TunerClientHandler(poMainAppl);
        DLT_REGISTER_CONTEXT(AGW_Tuner,"GWTN","Tuner"
                             "context for DLT Logging");
    }

    return m_poFC_Gateway_TunerClientHandler;
}

/*******************************************************************************
*
* FUNCTION: FC_Gateway_TunerClientHandler::
*             FC_Gateway_TunerClientHandler(gateway_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/

FC_Gateway_TunerClientHandler::FC_Gateway_TunerClientHandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler(
          (ahl_tclBaseOneThreadApp*)poMainAppl,
          MIDW_TUNERFI_C_U16_SERVICE_ID,
          MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION,
          MIDW_TUNERFI_C_U16_SERVICE_MINORVERSION )
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));

    vRegisterPropertyOnStartup();
    m_poMainApp = poMainAppl;
    m_bIsGetStationList = false;
    m_bIsStationListUpdate = false;
    _rStationInfo.u32Frequency = 0;
    _rStationInfo.programID = 0;
    _rStationInfo.fieldStrength = 0;
    _rStationInfo.stationName.assign("");
    _rStationInfo.stationText.assign("");
    _rStationInfo.presetListID = 0;
    _rStationInfo.programType = AP_TUNER_PT_UNDEFINED;
    m_bIsScan = false;
    m_bIsSeek = false;
    m_bIsCancel = false;
}

/*******************************************************************************
*
* FUNCTION: FC_Gateway_TunerClientHandler::
*             ~FC_Gateway_TunerClientHandler(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

FC_Gateway_TunerClientHandler::~FC_Gateway_TunerClientHandler()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerClientHandler Destructor :"),
            DLT_STRING(__FUNCTION__));

    vDeRegisterAllProperty();
    DLT_UNREGISTER_CONTEXT(AGW_Tuner);
    if(m_poFC_Gateway_TunerClientHandler!= NULL)
    {
        delete m_poFC_Gateway_TunerClientHandler;
        m_poFC_Gateway_TunerClientHandler = NULL;
    }
}


/*******************************************************************************
*
* FUNCTION: tVoid FC_Gateway_TunerClientHandler::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));
}

/*******************************************************************************
*
* FUNCTION: tVoid FC_Gateway_TunerClientHandler::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));

}

/******************************************************************************
 * Function:     vRegisterProperty
 * Description:  Register for a property
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vRegisterProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));
}

/******************************************************************************
 * Function:     vDeRegisterProperty
 * Description:  Derigester a property
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vDeRegisterProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));
}

/******************************************************************************
 * Function:     vRegisterPropertyOnStartup
 * Description:  Registers property on process startup
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vRegisterPropertyOnStartup()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));

    vAddAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST);

    vAddAutoRegisterForProperty(
                MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS);

    vAddAutoRegisterForProperty(
                MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION);
    vAddAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG);

    vAddAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO);
    vAddAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT);
    vAddAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK);

}

/******************************************************************************
 * Function:     vDeRegisterAllProperty
 * Description:  Deregisters all properties
 * Parameters:   void
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vDeRegisterAllProperty()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));
    vDeRegisterProperty();

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST);

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS);

    vRemoveAutoRegisterForProperty(
                MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION);

    vRemoveAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO);
    vRemoveAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT);
    vRemoveAutoRegisterForProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK);

}

/******************************************************************************
 * Function:     bGetHDRadioStatus
 * Description:  Read HD radio status from KDS
 * Parameters:   tU8& u8HDRadioStatus
 * Return:       bool
 *****************************************************************************/
bool FC_Gateway_TunerClientHandler::bGetHDRadioStatus(tU8& u8HDRadioStatus)
{
	DLT_LOG(AGW_Tuner,DLT_LOG_DEBUG,DLT_STRING("FC_Gateway_TunerClientHandler :")
            ,DLT_STRING( __FUNCTION__));
	tU8 u8Ret = 0;
    dp_tclKdsCMVariantCoding l_dp_tclKdsCMVariantCoding;
    l_dp_tclKdsCMVariantCoding.u8GetHDRadio(u8HDRadioStatus);
	if(u8Ret == DP_U8_ELEM_STATUS_VALID)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("bGetTunerConfig: u8GetHDRadio "),
            DLT_INT(u8HDRadioStatus));
		return true;
	}
	
	return false;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_ATFREQUENCYMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY
 * Parameters:   tuner header, steps to be tuned, midw_fi_tcl_e8_Tun_AcceptAF
 * Return:       bool
 *****************************************************************************/

tBool FC_Gateway_TunerClientHandler::
sendFID_TUN_S_ATFREQUENCYMStart(midw_fi_tcl_e8_Tun_TunerHeader TunerHeader,
                                midw_fi_tcl_TunerManualSingleStep
                                TunerManualSingleStep,
                                midw_fi_tcl_e8_Tun_AcceptAF u8AcceptAF)
{
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart oMStart;
        //the data content
        oMStart.TunerHeader = TunerHeader;
        oMStart.TunerManualSingleStep = TunerManualSingleStep;
        oMStart.u8AcceptAF = u8AcceptAF;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_ATFREQUENCYMStart():enPostMessage"
                               "failed for FuncId -"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY),
                    DLT_STRING(" 'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER
 * Parameters:   seek type, tuner header, frequency
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::
sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart(midw_fi_tcl_e8_Tun_TunerSeek
                                            u8TunerSeek,
                                            midw_fi_tcl_e8_Tun_TunerHeader
                                            u8TunerHeader,
                                            tU32 u32Frequency)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerClientHandler::"
                       "sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart()"));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart oMStart;
        //the data content
        oMStart.u8TunerSeek = u8TunerSeek;
        oMStart.u8TunerHeader = u8TunerHeader;
        oMStart.u32Frequency = u32Frequency;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(
                    oOutMessage, (tU16) 0,
                    (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER,
                    (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_ATSEEK_WITH_TUNERHEADERMStart():"
                               "enPostMessage failed for FuncId"),
                    DLT_UINT(
                        MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_SET_FEATUREMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE
 * Parameters:   midw_fi_tcl_TunerFeature
 * Return:       bool
 *****************************************************************************/
tBool
FC_Gateway_TunerClientHandler::sendFID_TUN_S_SET_FEATUREMStart(
        midw_fi_tcl_TunerFeature TunerFeature)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("RDS mode = "),
            DLT_UINT( TunerFeature.b32Features.bTUN_FEATURE_RDS_AUTO_MODE()));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart  oMStart;
        //the data content
        oMStart.TunerFeature = TunerFeature;
        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_SET_FEATUREMStart():enPostMessage"
                               "failed for FuncId"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE),
                    DLT_STRING("'ail_tenCommunicationError':"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_DIRECT_FREQUENCYMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY
 * Parameters:   frequency , band
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::sendFID_TUN_S_DIRECT_FREQUENCYMStart(
        tU32 u32Frequency,
        midw_fi_tcl_e8_Tun_TunerBand u8Band)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(""),DLT_STRING(__FUNCTION__));
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart  oMStart;
        //the data content
        oMStart.u32Frequency = u32Frequency;
        oMStart.u8Band = u8Band;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_DIRECT_FREQUENCYMStart():"
                               "enPostMessage failed for FuncId-"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_GET_CONFIG_LISTMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST
 * Parameters:   midw_fi_tcl_Tun_MakeConfigList
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::sendFID_TUN_S_GET_CONFIG_LISTMStart(
        midw_fi_tcl_Tun_MakeConfigList TunMakeConfigList)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("FC_Gateway_TunerClientHandler::"
                       "sendFID_TUN_S_GET_CONFIG_LISTMStart()"));
#endif
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart  oMStart;
        //the data content
        oMStart.TunMakeConfigList = TunMakeConfigList;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR
                    ,DLT_STRING("FC_Gateway_TunerClientHandler::"
                                "sendFID_TUN_S_GET_CONFIG_LISTMStart():"
                                "enPostMessage failed for FuncId-"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        }
        else
        {
#if 0
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_GET_CONFIG_LISTMStart():"
                               "enPostMessage successful"));
#endif
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH
 * Parameters:   midw_fi_tcl_b8_AnnoTypes
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart(
        midw_fi_tcl_b8_AnnoTypes b8AnnoType)
{
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart  oMStart;
        //the data content
        oMStart.b8AnnoType = b8AnnoType;


        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR) {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart():"
                               "enPostMessage failed for FuncId-"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));

        } else {
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH
 * Parameters:   demodulation switch, mask and value
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart
(
        midw_fi_tcl_b8_Tun_DemodSwitch DemodulationSwitch,
        midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchMask,
        midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchValue)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart"
                "b8DemodulationSwitchMask"),
            DLT_INT(b8DemodulationSwitchMask.u8Value),
            DLT_STRING("b8DemodulationSwitchValue"),
            DLT_INT(b8DemodulationSwitchValue.u8Value));

    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
        midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart
                oMStart;
        //the data content
        oMStart.DemodulationSwitch = DemodulationSwitch;
        oMStart.b8DemodulationSwitchMask = b8DemodulationSwitchMask;
        oMStart.b8DemodulationSwitchValue = b8DemodulationSwitchValue;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16)
                         MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerClientHandler::"
                        "sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart():"
                        "enPostMessage failed for FuncId"),
                    DLT_UINT(
                        MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
            bRetVal = TRUE;
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                    DLT_STRING("FC_Gateway_TunerClientHandler::"
                               "sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart"
                               "post successful"));
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;

}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus(
        amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus"));

#endif

    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus():"
                            "Status update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST'"));
#endif
                onFID_TUN_G_GET_CONFIG_LISTStatus(
                            oStatus.e8ConfigListID,
                            oStatus.Tun_ConfigListElements);

            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_GET_CONFIG_LISTOpStatus:"
                            "Received message is invalid!"));

                if(m_bIsGetStationList == true)
                {
                    char sErrMsg[] =  "Internal Error.";
                    vSendGetStationListError(
                                AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,
                                sErrMsg);

                    m_bIsGetStationList = false;
                }
                else if(m_bIsStationListUpdate == true)
                {
                    m_bIsStationListUpdate = false;
                }
            }
            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_GET_CONFIG_LISTStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST
 * Parameters:   midw_fi_tcl_e8_Tun_ConfigListID,
                 midw_fi_tcl_TunerConfigListElementList
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_G_GET_CONFIG_LISTStatus(
        midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID,
        midw_fi_tcl_TunerConfigListElementList
        Tun_ConfigListElements)
{
    // onFID_TUN_G_GET_CONFIG_LISTStatus: user specific code start
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "onFID_TUN_G_GET_CONFIG_LISTStatus()"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("List ID = "),
            DLT_INT(e8ConfigListID.enType));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("List size = "),
            DLT_INT(Tun_ConfigListElements.TunerConfigListElement.size()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("m_bIsGetStationList"),
            DLT_INT(m_bIsGetStationList),
            DLT_STRING("m_bIsStationListUpdate %d"),
            DLT_INT(m_bIsStationListUpdate));
#endif
    std::vector<unsigned int> stationList;

    for( std::vector<midw_fi_tcl_TunerConfigListElement,
         std::allocator<midw_fi_tcl_TunerConfigListElement> >
         ::iterator iIterator =
         Tun_ConfigListElements.TunerConfigListElement.begin();
         iIterator !=  Tun_ConfigListElements.TunerConfigListElement.end();
         ++iIterator)
    {
#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Config List id:"),
                DLT_INT(iIterator->e8ConfigListID.enType));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Element selected:"),
                DLT_INT(iIterator->u8ElementSelected));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Element id:"),
                DLT_INT(iIterator->u8ElementID));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Frequency:"),
                DLT_UINT(iIterator->u32Frequency));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PS name:"),
                DLT_STRING(iIterator->sPSName.szValue));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(" PI:"),
                DLT_UINT(iIterator->u32PI));
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PTY:"),
                DLT_INT(iIterator->u8PTY));
#endif
        stationList.push_back(iIterator->u32Frequency*1000);
    }


    if(m_bIsGetStationList == true)
    {
#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("m_bIsGetStationList is TRUE"));
#endif
        sendFID_TUN_S_STATIONLIST_EXITMStart (e8ConfigListID);
        m_bIsGetStationList = false;
        vHandleGetStationListDataHandler(stationList);
    }
    else if(m_bIsStationListUpdate == true)
    {
#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("m_bIsStationListUpdate is TRUE"));
#endif
        sendFID_TUN_S_STATIONLIST_EXITMStart (e8ConfigListID);
        m_bIsStationListUpdate = false;
        ApTunerBand e8Band;
        switch(e8ConfigListID.enType)
        {
        case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM:
            e8Band = AP_TUNER_BAND_FM;
            break;

        case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM:
            e8Band = AP_TUNER_BAND_AM;
            break;

        case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_DRM:
            e8Band = AP_TUNER_BAND_DRM;
            break;

        case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_LW:
            e8Band = AP_TUNER_BAND_LW;
            break;

        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Invalid band"));
            return;

        }
        vHandleUpdateStationListDataHandler(e8Band,stationList);
    }
    // onFID_TUN_G_GET_CONFIG_LISTStatus: user specific code end

}

/******************************************************************************
 * Function:     sendFID_TUN_S_STATIONLIST_EXITMStart
 * Description:  CCA opcode method start for
                 MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT
 * Parameters:   midw_fi_tcl_e8_Tun_ConfigListID
 * Return:       bool
 *****************************************************************************/
tBool FC_Gateway_TunerClientHandler::sendFID_TUN_S_STATIONLIST_EXITMStart(
        midw_fi_tcl_e8_Tun_ConfigListID oConfigList)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "sendFID_TUN_S_STATIONLIST_EXITMStart()"));
#endif
    tBool bRetVal = FALSE;
    if (u16GetRegID() != AMT_C_U16_REGID_INVALID)
    {
        midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart  oMStart;
        //the data content
        oMStart.e8ConfigListID = oConfigList;

        fi_tclVisitorMessage oOutMessage(oMStart);
        //Initialize the message with register id and so on
        vInitServiceData(oOutMessage, (tU16) 0,
                         (tU16) MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT,
                         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = m_poMainApp->enPostMessage(&oOutMessage, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerClientHandler::"
                        "sendFID_TUN_S_STATIONLIST_EXITMStart():"
                        "enPostMessage failed for FuncId"),
                    DLT_UINT(MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT),
                    DLT_STRING("'ail_tenCommunicationError'"),
                    DLT_UINT((tU32)enResult));
        }
        else
        {
#if 0
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                        "sendFID_TUN_S_STATIONLIST_EXITMStart():"
                        "enPostMessage successful"));
#endif
            bRetVal = TRUE;
        }

        // Always destroy the FI data object before leaving its creation scope
        oMStart.vDestroy();
    }
    return bRetVal;
}

/******************************************************************************
 * Function:     vHandleFID_TUN_S_STATIONLIST_EXITOpMResult
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_STATIONLIST_EXITOpMResult(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult  oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "vHandleFID_TUN_S_STATIONLIST_EXITOpMResult():"
                            "Method result update message received for "
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT'"
                            "(FID: 0x8C)!"));
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_STATIONLIST_EXITOpMResult:"
                            "Received message is invalid!"));
            }
            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_RADIO_TEXTOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_RADIO_TEXTOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_RADIO_TEXTOpStatus():"
                            "Status update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT'"));
#endif
                onFID_TUN_G_RADIO_TEXTStatus(oStatus.TunerRadioText);

                // vHandleFID_TUN_G_RADIO_TEXTOpStatus: user specific code start
                // vHandleFID_TUN_G_RADIO_TEXTOpStatus: user specific code end
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_RADIO_TEXTOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_RADIO_TEXTStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT
 * Parameters:   midw_fi_tcl_TunerRadioText
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_G_RADIO_TEXTStatus(
        midw_fi_tcl_TunerRadioText TunerRadioText)
{

    // onFID_TUN_G_RADIO_TEXTStatus: user specific code start
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(" Radio Text: "),
            DLT_STRING(TunerRadioText.sRadioTextData.szValue));
#endif
    _rStationInfo.stationText = TunerRadioText.sRadioTextData.szValue;
    vUpdateStationInfo(_rStationInfo);
    // onFID_TUN_G_RADIO_TEXTStatus: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_ATSTATIONINFOOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_ATSTATIONINFOOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                midw_fi_tcl_Atstationinfo
                        _Atstationinfo_FID_TUN_G_ATSTATIONINFOStatus =
                        oStatus.Atstationinfo;

#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                        DLT_STRING("FC_Gateway_TunerClientHandler::"
                                   "vHandleFID_TUN_G_ATSTATIONINFOOpStatus():"
                                   "Status update message received for"
                                   "'MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO'"
                                   "(FID: 0x93)!"));
#endif
                onFID_TUN_G_ATSTATIONINFOStatus(
                            _Atstationinfo_FID_TUN_G_ATSTATIONINFOStatus);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_ATSTATIONINFOOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_ATSTATIONINFOStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO
 * Parameters:   midw_fi_tcl_Atstationinfo
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_G_ATSTATIONINFOStatus(
        midw_fi_tcl_Atstationinfo& Atstationinfo)
{
    // onFID_TUN_G_ATSTATIONINFOStatus: user specific code start
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("TunerHeader = "),
            DLT_INT( Atstationinfo.u8TunerHeader.enType));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Frequency = "),
            DLT_INT( Atstationinfo.u32Frequency));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PI = "),
            DLT_INT( Atstationinfo.u16PI));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PS name = "),
            DLT_STRING( Atstationinfo.sPSName.szValue));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Band = "),
            DLT_INT( Atstationinfo.e8Band.enType));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("PresetListId = "),
            DLT_INT( Atstationinfo.u16PresetListID));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Active station list = "),
            DLT_UINT(Atstationinfo.u8ActiveStationList));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Current PTY = "),
            DLT_UINT( Atstationinfo.u8PTY));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Field Strength = "),
            DLT_UINT( Atstationinfo.u8FieldStrngth));
#endif

    if(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM ==
            Atstationinfo.e8Band.enType)
    {
        _rStationInfo.band = AP_TUNER_BAND_FM;
    }
    else if(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW ==
            Atstationinfo.e8Band.enType
            || midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW ==
            Atstationinfo.e8Band.enType)
    {
        _rStationInfo.band = AP_TUNER_BAND_AM;
    }
    else
    {
        return;
    }

    _rStationInfo.u32Frequency = Atstationinfo.u32Frequency*1000;
    _rStationInfo.programID = Atstationinfo.u16PI;
    _rStationInfo.fieldStrength = Atstationinfo.u8FieldStrngth;
    _rStationInfo.presetListID = Atstationinfo.u16PresetListID;
    _rStationInfo.programType = (ApTunerProgramType) Atstationinfo.u8PTY;
    _rStationInfo.stationName = Atstationinfo.sPSName.szValue;
    vUpdateStationInfo(_rStationInfo);
}

/******************************************************************************
 * Function:     vHandleFID_TUN_S_ATFREQUENCYOpMResult
 * Description:  Handling of method result
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_ATFREQUENCYOpMResult(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult  oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ATFREQUENCYOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY'"));

                onFID_TUN_S_ATFREQUENCYMResult(
                            oMResult.TunerServer_StatusResponse);

                // vHandleFID_TUN_S_ATFREQUENCYOpMResult: user specific code start
                // vHandleFID_TUN_S_ATFREQUENCYOpMResult: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ATFREQUENCYOpMResult:"
                            "Received message is invalid!"));

                vSendTuneError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            }

            oMResult.vDestroy();
        }

    }
}


/******************************************************************************
 * Function:     vHandleFID_TUN_G_ATSEEKOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_ATSEEKOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus  oStatus;

            if (oInMsg.s32GetData(oStatus, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                midw_fi_tcl_e8_Tun_TunerSeek
                        _TunerSeek_FID_TUN_G_ATSEEKStatus =
                        oStatus.e8SeekState;

                onFID_TUN_G_ATSEEKStatus(
                            _TunerSeek_FID_TUN_G_ATSEEKStatus);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_ATSEEKOpStatus:"
                            "Received message is invalid!"));
            }

            oStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_ATSEEKStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEKStatus
 * Parameters:   midw_fi_tcl_e8_Tun_TunerSeek
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_G_ATSEEKStatus(
        midw_fi_tcl_e8_Tun_TunerSeek AtTunerSeek)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "onFID_TUN_G_ATSEEKStatus - Seek State"),
            DLT_INT(AtTunerSeek.enType));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "m_bIsCancel m_bIsScan and m_bIsSeek"), DLT_INT(m_bIsCancel),
            DLT_INT(m_bIsScan),DLT_INT(m_bIsSeek));
    switch(AtTunerSeek.enType)
    {
    case midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF:
        if(!m_bIsCancel)
        {
            if(m_bIsScan)
            {
                m_bIsScan = FALSE;
                vSendSearchStatus(AP_TUNER_SEARCH_REQ_COMPLETED);
            }
            else if(m_bIsSeek)
            {
                m_bIsSeek = FALSE;
                vSendSeekStatus(AP_TUNER_SEEK_REQ_COMPLETED);
            }
            else
            {
                //do nothing
            }
        }
        else
        {
            m_bIsCancel = FALSE;

            if(m_bIsScan)
            {
                vSendSearchStatus(AP_TUNER_SEARCH_REQ_CANCELLED);
                vSendCancelSearchStnResult();
                m_bIsScan = FALSE;
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "+onFID_TUN_G_ATSEEKStatus"
                            "scan cancelled"));
            }

            else if(m_bIsSeek)
            {
                vSendSeekStatus(AP_TUNER_SEEK_REQ_CANCELLED);
                vSendCancelSeekResult();
                m_bIsSeek = FALSE;
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                        DLT_STRING("+onFID_TUN_G_ATSEEKStatus seek cancelled"));
            }
            else
            {
                //do nothing
            }

        }
        break;
    case midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_AUTO:
    case midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_AUTO:
	    m_bIsSeek = TRUE;
        vSendSeekStatus(AP_TUNER_SEEK_REQ_INPROGRESS);
        break;
    case  midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY:
	    m_bIsScan = TRUE;
        vSendSearchStatus(AP_TUNER_SEARCH_REQ_INPROGRESS);
        break;
    default:
        break;
    }

}

/******************************************************************************
 * Function:     onFID_TUN_S_ATFREQUENCYMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY
 * Parameters:   midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::onFID_TUN_S_ATFREQUENCYMResult(
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    // onFID_TUN_S_ATFREQUENCYMResult: user specific code start
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("onFID_TUN_S_ATFREQUENCYMResult Status"),
            DLT_INT(TunerServer_StatusResponse.u8TunerStatus.enType));
    APTunerError eTunerError;
    switch(TunerServer_StatusResponse.u8TunerStatus.enType)
    {
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL:
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_INVALID_TYPE:
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_PREV_REQ_INPROCESS:
        eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
        break;
    case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED:
        eTunerError = AP_TUNER_ERROR_FUNC_NOT_SUPPORTED;
        break;
    case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED:
        vSendTuneResult();
        return;
    default:
        eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
        return;
    }
    vSendTuneError(eTunerError);
    // onFID_TUN_S_ATFREQUENCYMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult
 * Description:  Handling of method result
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid
FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult
(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR) {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler:: "
                            "vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER'"));

                onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult(
                            oMResult.TunerServer_StatusResponse);

                // vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult: user specific code start
                // vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult: user specific code end
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ATSEEK_WITH_TUNERHEADEROpMResult:"
                            "Received message is invalid!"));

                if(m_bIsCancel)
                {
                    m_bIsCancel = FALSE;
                    if(m_bIsScan)
                    {
                        m_bIsScan = FALSE;
                        vSendCancelSearchStnError(
                                    AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                    }
                    else if(m_bIsSeek)
                    {
                        m_bIsSeek = FALSE;
                        vSendCancelSeekError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
                    }
                }
                else
                {
                    if(m_bIsScan)
                    {
                        m_bIsScan = false;
                        vSendSearchStatus(AP_TUNER_SEARCH_REQ_FAIL);
                    }
                    else if(m_bIsSeek)
                    {
                        m_bIsSeek = false;
                        vSendSeekStatus(AP_TUNER_SEEK_REQ_FAIL);
                    }
                }
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER
 * Parameters:   midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult(
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    // onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult: user specific code start
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "+onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult m_bIsScan: m_bIsSeek:"),
            DLT_INT(m_bIsScan), DLT_INT(m_bIsSeek));

    if(m_bIsScan)
    {
        switch(TunerServer_StatusResponse.u8TunerStatus.enType)
        {
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Scan request Success"));
            break;

        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Scan Failed"));
            vSendSearchStatus(AP_TUNER_SEARCH_REQ_FAIL);
            m_bIsScan = false;
            break;

        case midw_fi_tcl_e8_Tun_ResponseStatus::
        FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Scan request inprogress"));
            break;

        case midw_fi_tcl_e8_Tun_ResponseStatus::
        FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Scan not supported"));
            vSendSearchStatus(AP_TUNER_SEARCH_REQ_NOT_AVAILABLE);
            m_bIsScan = false;
            break;

        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                    DLT_STRING("Scan:Invalid response received"));
            vSendSearchStatus(AP_TUNER_SEARCH_REQ_FAIL);
            m_bIsScan = false;
            break;
        }
    }
    else if (m_bIsSeek)
    {
        switch(TunerServer_StatusResponse.u8TunerStatus.enType)
        {
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek request Success"));
            break;
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek Failed"));
            vSendSeekStatus(AP_TUNER_SEEK_REQ_FAIL);
            m_bIsSeek = false;
            break;
        case midw_fi_tcl_e8_Tun_ResponseStatus::
        FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek request inprogress"));
            break;
        case midw_fi_tcl_e8_Tun_ResponseStatus::
        FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek not supported"));
            vSendSeekStatus(AP_TUNER_SEEK_REQ_NOT_AVAILABLE);
            m_bIsSeek = false;
            break;
        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Seek:Invalid response received"));
            vSendSeekStatus(AP_TUNER_SEEK_REQ_FAIL);
            m_bIsSeek = false;
            break;
        }
    }
    // onFID_TUN_S_ATSEEK_WITH_TUNERHEADERMResult: user specific code end

}

/******************************************************************************
 * Function:     vHandleFID_TUN_S_SET_FEATUREOpMResult
 * Description:  Handling of method result
                 MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_SET_FEATUREOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "vHandleFID_TUN_S_SET_FEATUREOpMResult"));

    if (poMessage != NULL) {
        if(poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                        "FC_Gateway_TunerClientHandler::"
                        "vHandleFID_TUN_S_SET_FEATUREOpMResult:"
                        "received error opcode"));

            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("Error code ::"),
                    DLT_INT( u16ErrorCode));
        }
        else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ||
                  poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult  oMResult;

            if (oInMsg.s32GetData(oMResult,
                                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_SET_FEATUREOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE'"));

                onFID_TUN_S_SET_FEATUREMResult(oMResult.TunerServer_StatusResponse);
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_SET_FEATUREOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
        else
        {
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                    DLT_STRING("invalid opcode received "),
                    DLT_UINT(poMessage->u8GetOpCode()));
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_S_SET_FEATUREMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE
 * Parameters:   midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_S_SET_FEATUREMResult(
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::onFID_TUN_S_SET_FEATUREMResult"));
}


/******************************************************************************
 * Function:     vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult
 * Description:  Handling of method result
                 MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/

tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL) {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult  oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY'"
                            "(FID: 0x32)!"));

                onFID_TUN_S_DIRECT_FREQUENCYMResult(
                            oMResult.TunerServer_StatusResponse);

                // vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult: user specific code start
                // vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult: user specific code end
            } else {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_DIRECT_FREQUENCYOpMResult:"
                            "Received message is invalid!"));
                vSendSetFreqError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR);
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_S_DIRECT_FREQUENCYMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY
 * Parameters:   midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_S_DIRECT_FREQUENCYMResult(
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    // onFID_TUN_S_DIRECT_FREQUENCYMResult: user specific code start
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("onFID_TUN_S_ATFREQUENCYMResult Status"),
            DLT_INT(TunerServer_StatusResponse.u8TunerStatus.enType));
    APTunerError eTunerError;
    switch(TunerServer_StatusResponse.u8TunerStatus.enType)
    {
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL:
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_INVALID_TYPE:
    case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_PREV_REQ_INPROCESS:
        eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
        break;
    case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED:
        eTunerError = AP_TUNER_ERROR_FUNC_NOT_SUPPORTED;
        break;
    case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED:
        vSendSetFreqResult();
        return;
    default:
        eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
        return;
    }
    vSendSetFreqError(eTunerError);
    // onFID_TUN_S_DIRECT_FREQUENCYMResult: user specific code end

}


/******************************************************************************
 * Function:     vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult
 * Description:  Handling method result of
                 MIDW_TUNERMASTERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult  oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST'"
                            "(FID: 0x8C)!"));

                onFID_TUN_S_GET_CONFIG_LISTMResult(
                            oMResult.TunMakeConfigListElem,
                            oMResult.TunerServer_StatusResponse);

                // vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult: user specific code start
                // vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult: user specific code end
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler:: "
                            "vHandleFID_TUN_S_GET_CONFIG_LISTOpMResult:"
                            "Received message is invalid!"));

                if(m_bIsGetStationList)
                {
                    char sErrMsg[] = "Internal Error.";
                    vSendGetStationListError(
                                AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,
                                sErrMsg);
                    m_bIsGetStationList = false;
                }

                if(m_bIsStationListUpdate)
                {
                    m_bIsStationListUpdate = false;
                }

            }
            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_S_GET_CONFIG_LISTMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST
 * Parameters:   midw_fi_tcl_MakeConfigListElem ,
                 midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_S_GET_CONFIG_LISTMResult(
        midw_fi_tcl_MakeConfigListElem TunMakeConfigListElem,
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                "FC_Gateway_TunerClientHandler::"
                "onFID_TUN_S_GET_CONFIG_LISTMResult"));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("ConfigListID :"),
            DLT_INT(TunMakeConfigListElem.e8ListID.enType),
            DLT_STRING("NumberOfElements in List :"),
            DLT_INT(TunMakeConfigListElem.u8NumOfElementsInList));

    APTunerError eTunerError;
    char sErrMsg[200];

    if(TunMakeConfigListElem.u8NumOfElementsInList == 0)
    {
        sendFID_TUN_S_STATIONLIST_EXITMStart (TunMakeConfigListElem.e8ListID);
        eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
        strncpy(sErrMsg,"No Stations Available.List empty",sizeof(sErrMsg));
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Tuner status :"),
                DLT_INT(TunerServer_StatusResponse.u8TunerStatus.enType),
                DLT_STRING("TunerState:"),
                DLT_INT(TunerServer_StatusResponse.u8TunerState.enType));

        switch(TunerServer_StatusResponse.u8TunerStatus.enType)
        {
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL:
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_INVALID_TYPE:
        case midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_PREV_REQ_INPROCESS:
            eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
            strncpy(sErrMsg,"Internal Error.",sizeof(sErrMsg));
            break;
        case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED:
            eTunerError = AP_TUNER_ERROR_FUNC_NOT_SUPPORTED;
            strncpy(sErrMsg,"Functionality currently not supported.",sizeof(sErrMsg));
            break;
        case  midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED:
            // here do nothing
            return;
        default:
            eTunerError = AP_TUNER_ERROR_INTERNAL_ENGINE_ERR;
            strncpy(sErrMsg,"Error in getting station list.",sizeof(sErrMsg));
            return;
        }
    }

    if(m_bIsGetStationList)
    {
        vSendGetStationListError(eTunerError,sErrMsg);
        m_bIsGetStationList = false;
    }
    if(m_bIsStationListUpdate)
    {
        m_bIsStationListUpdate = false;
    }
}



/******************************************************************************
 * Function:     vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult
 * Description:  Handling of method result
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS
             || poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage            oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION)
                    != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH'"
                            "(FID: 0x176)!"));

                onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult(
                            oMResult.TunerServer_StatusResponse);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     vHandleFID_TUN_S_SET_DEMODULATION_SWITCHOpMResult
 * Description:  Handling of property
                 MIDW_TUNERMASTERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::vHandleFID_TUN_S_SET_DEMODULATION_SWITCHOpMResult
(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ||
             poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult
                    oMResult;

            if (oInMsg.s32GetData(oMResult, MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler:: "
                            "vHandleFID_TUN_S_SET_DEMODULATION_SWITCHOpMResult():"
                            "Method result update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH'"
                            "(FID: 0x176)!"));

                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("HDRadio Status :"),
                        DLT_INT(
                            oMResult.TunerServer_StatusResponse.u8TunerStatus.enType),
                        DLT_STRING("HDRadioState : %d"),
                        DLT_INT(
                            oMResult.TunerServer_StatusResponse.u8TunerState.enType));
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_S_ANNOUNCEMENT_SWITCHOpMResult:"
                            "Received message is invalid!"));
            }

            oMResult.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_DEMODULATION_SWITCH_STATUSOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_DEMODULATION_SWITCH_STATUSOpStatus(
        amt_tclServiceData* poMessage)
{
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus oDemodStatus;

            if (oInMsg.s32GetData(oDemodStatus,
                                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_DEMODULATION_SWITCH_STATUSOpStatus():"
                            "Status update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS'"
                            "(FID: 0x95)!"));

#endif
                onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(
                            oDemodStatus.DemodulationSwitch);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS:"
                            "Received message is invalid!"));
            }
            oDemodStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS
 * Parameters:   midw_fi_tcl_b8_Tun_DemodSwitch
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(
        midw_fi_tcl_b8_Tun_DemodSwitch oDemodSwitch)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus "),
            DLT_INT( oDemodSwitch.u8Value));

    tclConfigSettings *poConfigSettings = tclConfigSettings::getInstance();

    if(oDemodSwitch.bFM_HD() || oDemodSwitch.bAM_HD())
    {
        poConfigSettings->vSetHDRadio(true);
    }
    else
    {
        poConfigSettings->vSetHDRadio(false);
    }

    vUpdateConfigSettings(poConfigSettings);
}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_SET_RDSREGOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler ::vHandleFID_TUN_G_SET_RDSREGOpStatus(
        amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleFID_TUN_G_SET_RDSREGOpStatus"));
#endif
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus  oRegStatus;

            if (oInMsg.s32GetData(oRegStatus,
                                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_SET_RDSREGOpStatus(): Status"
                            "update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG'"
                            "(FID: 0x95)!"));

#endif

                onFID_TUN_G_SET_RDSREGStatus(oRegStatus);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG:Received"
                            "message is invalid!"));
            }
            oRegStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_SET_RDSREGStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG
 * Parameters:   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus
 * Return:       void
 *****************************************************************************/
tVoid FC_Gateway_TunerClientHandler::onFID_TUN_G_SET_RDSREGStatus(
        midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus oRegStatus)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("RDSREGStatus :"),DLT_INT( oRegStatus.u8RDSreg));

    tclConfigSettings *poConfigSettings = tclConfigSettings::getInstance();

    if(oRegStatus.u8RDSreg == 0x01)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("onFID_TUN_G_SET_RDSREGStatus:Region Auto"));
        poConfigSettings->vSetRegion(false);
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("onFID_TUN_G_SET_RDSREGStatus:Region On"));
        poConfigSettings->vSetRegion(true);
    }

    vUpdateConfigSettings(poConfigSettings);
}

/******************************************************************************
 * Function:     vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus
 * Description:  Handling of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION
 * Parameters:   amt_tclServiceData
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus(
        amt_tclServiceData* poMessage)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus"));
#endif
    if (poMessage != NULL)
    {
        if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
        {
            fi_tclVisitorMessage oInMsg( poMessage );
            midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus
                    oStationListStatus;

            if (oInMsg.s32GetData(oStationListStatus,
                                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
            {
#if 0
                DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "vHandleFID_TUN_G_LISTUPDATE_NOTIFICATIONOpStatus():"
                            "Status update message received for"
                            "'MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION'"
                            "(FID: 0x95)!"));
#endif

                onFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus(
                            oStationListStatus.bListUpdate);
            }
            else
            {
                DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                            "FC_Gateway_TunerClientHandler::"
                            "MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION:"
                            "Received message is invalid!"));
            }
            oStationListStatus.vDestroy();
        }
    }
}

/******************************************************************************
 * Function:     onFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus
 * Description:  On update of property
                 MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION
 * Parameters:   midw_fi_tcl_e8_List, vector<midw_fi_tcl_PresetList>
 * Return:       void
 *****************************************************************************/
tVoid
FC_Gateway_TunerClientHandler::onFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus(
        bool bListUpdate)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("Listupdate status : "),
            DLT_INT( bListUpdate));

    if(bListUpdate)
    {
        midw_fi_tcl_Tun_MakeConfigList oConfigList;

        FC_Gateway_TunerMasterClientHandler
                *poTunerMasterClientHandlerObj =
                procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

        midw_fi_tcl_e8_Band
                current_band =
                poTunerMasterClientHandlerObj->getCurrentStateBand();

        switch(current_band.enType)
        {
        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
            oConfigList.eConfigListID.enType =
                    midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM;
            break;

        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
        case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
            oConfigList.eConfigListID.enType =
                    midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW;
            break;

        default:
            DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("Invalid band"));
            return;
        }
        //oConfigList.u32PTY
        oConfigList.eSortingCriteria.enType =
                midw_fi_tcl_e8_Tun_SortingCriteria::FI_EN_TUN_TUN_SORT_FREQUENCY_ASCENDING;
        
		tU8 u8HDRadioStatus = 0; 
		bool bRet = bGetHDRadioStatus(u8HDRadioStatus);
		
		if(bRet)
		{
            if (u8HDRadioStatus == 0x01)
            {
			    DLT_LOG(AGW_Tuner,DLT_LOG_DEBUG,DLT_STRING("HD Supported"));
                oConfigList.u8DigitalFilters.vSetSTATIONLIST_WITHONLY_HDMPS(TRUE);
				oConfigList.u8DigitalFilters.vSetSTATIONLIST_WITH_HDMPS_SPS(TRUE);
            }
			else
			{
				//do nothing
				DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("HD Not Supported"));
			}
		}

        //oConfigList.bFrozenList
#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("List is updated"));
#endif

        m_bIsStationListUpdate = true;
        sendFID_TUN_S_GET_CONFIG_LISTMStart(oConfigList);
    }
}

/******************************************************************************
 * Function:     onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult
 * Description:  On method result of
                 MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH
 * Parameters:   midw_fi_tcl_TunerServer_StatusResponse
 * Return:       void
 *****************************************************************************/

tVoid
FC_Gateway_TunerClientHandler::onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult(
        midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse)
{
    // onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult: user specific code start
    // onFID_TUN_S_ANNOUNCEMENT_SWITCHMResult: user specific code end

}

/******************************************************************************
 * Function:     vSetGetStationListFlag
 * Description:  To set station list getter flag
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/
void FC_Gateway_TunerClientHandler::vSetGetStationListFlag(bool bStatus)
{
    m_bIsGetStationList = bStatus;
}

#ifdef __cplusplus
extern "C"
{
#endif

/******************************************************************************
 * Function:     bTuneWithFreqStep
 * Description:  Wrapper function to tune with frequency step
 * Parameters:   direction, step size
 * Return:       bool
 *****************************************************************************/
bool bTuneWithFreqStep(guchar arg_direction, guint arg_step_size)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING("+vTuneWithFreqStep"));
    FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();

    midw_fi_tcl_e8_Tun_TunerHeader tunerHeader;
    tunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;

    midw_fi_tcl_e8_Tun_AcceptAF acceptAF;
    acceptAF.enType = midw_fi_tcl_e8_Tun_AcceptAF::FI_EN_TUN_NOT_ACCEPT_AF;
    midw_fi_tcl_TunerManualSingleStep manualStep;

    if (arg_direction == AP_TUNER_DIRECTION_UP)
    {
        manualStep.ManualFreqAdjustment.enType =
                midw_fi_tcl_e8_Tun_ManualFreqAdjustment::FI_EN_TUN_SEEK_DIRECTION_UP;
    }

    else if (arg_direction == AP_TUNER_DIRECTION_DOWN)
    {
        manualStep.ManualFreqAdjustment.enType =
                midw_fi_tcl_e8_Tun_ManualFreqAdjustment::FI_EN_TUN_SEEK_DIRECTION_DOWN;
    }
    else
    {
        return FALSE;
    }


    manualStep.u8NumberOfTicks = arg_step_size;
    return poTunerClientHandlerObj->sendFID_TUN_S_ATFREQUENCYMStart(tunerHeader,
                                                                    manualStep,
                                                                    acceptAF);

}

/******************************************************************************
 * Function:     bSetFrequency
 * Description:  Wrapper function to set frequency
 * Parameters:   frequency, band
 * Return:       bool
 *****************************************************************************/
bool bSetFrequencyAMFM(unsigned int frequency,ApTunerBand eband)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSetFrequency"));

    FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();
    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Tun_TunerBand oBand;
    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    frequency = frequency/1000;  //converting into kHz


    return poTunerClientHandlerObj->sendFID_TUN_S_DIRECT_FREQUENCYMStart(
                frequency,
                oBand);

}

/******************************************************************************
 * Function:     vSetTA
 * Description:  Wrapper function to set traffic announcement
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/
void vSetTA(bool bTPState)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vSetTA"));
    FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();

    midw_fi_tcl_b8_AnnoTypes b8AnnoType;

    if(bTPState == TRUE)
    {
        b8AnnoType.vSetTP(true);
    }
    else
    {
        b8AnnoType.vSetTP(false);
    }

    poTunerClientHandlerObj->sendFID_TUN_S_ANNOUNCEMENT_SWITCHMStart(
                b8AnnoType);
}

/******************************************************************************
 * Function:     vRequestAvblStn
 * Description:  Wrapper function to get the available station list
 * Parameters:   band
 * Return:       void
 *****************************************************************************/
void vRequestAvblStn(ApTunerBand eBand)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vRequestAvblStn Band "),
            DLT_INT(eBand));

    FC_Gateway_TunerClientHandler *poTunerClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerClientHandler();
    midw_fi_tcl_Tun_MakeConfigList oTunMakeConfigList;
    poTunerClientHandlerObj->vSetGetStationListFlag(true);

    switch(eBand)
    {
    case AP_TUNER_BAND_AM:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("vRequestAvblStn:AP_TUNER_BAND_AM"));
        oTunMakeConfigList.eConfigListID.enType =
                midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW;
        break;

    case AP_TUNER_BAND_FM:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("vRequestAvblStn:AP_TUNER_BAND_FM"));
        oTunMakeConfigList.eConfigListID.enType =
                midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM;
        break;

    case AP_TUNER_BAND_LW:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("vRequestAvblStn:AP_TUNER_BAND_LW"));
        oTunMakeConfigList.eConfigListID.enType =
                midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_LW;
        break;

    case AP_TUNER_BAND_DRM:
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("vRequestAvblStn:AP_TUNER_BAND_DRM"));
        oTunMakeConfigList.eConfigListID.enType =
                midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_DRM;
        break;

    default:
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("vRequestAvblStn: Received message is invalid!"));
        char sErrMsg[] = "Band specified is not supported or invalid.";
        vSendGetStationListError(AP_TUNER_ERROR_BAD_PARAMS,sErrMsg);
        return;
    }

    oTunMakeConfigList.u32PTY = 0;
    oTunMakeConfigList.eSortingCriteria.enType =
            midw_fi_tcl_e8_Tun_SortingCriteria::FI_EN_TUN_TUN_SORT_PS_ASCENDING;
    oTunMakeConfigList.bFrozenList = FALSE;

    bool bRet = poTunerClientHandlerObj->sendFID_TUN_S_GET_CONFIG_LISTMStart(
                oTunMakeConfigList);
    if(!bRet)
    {
        char sErrMsg[] = "Internal Error.";
        vSendGetStationListError(AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,sErrMsg);
    }
}

#ifdef __cplusplus
}
#endif //__cplusplus

/******************************************************************************
 * Function:     vSetRegion
 * Description:  Wrapper function to toggle region
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/
void FC_Gateway_TunerClientHandler::vSetRegion(bool bRegVal)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetRegion "),DLT_INT(bRegVal));


    midw_fi_tcl_TunerFeature oTunerFeature;
    if(bRegVal)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetRegion Region ON"));
        oTunerFeature.b32Features.vSetTUN_FEATURE_REG_AUTO_MODE(false);
        oTunerFeature.b32MaskFeatures.u32Value =
                midw_fi_tcl_b32_Tun_Features::FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE;
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetRegion Region OFF"));
        oTunerFeature.b32Features.vSetTUN_FEATURE_REG_AUTO_MODE(true);
        oTunerFeature.b32MaskFeatures.u32Value =
                midw_fi_tcl_b32_Tun_Features::FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE;
    }

    sendFID_TUN_S_SET_FEATUREMStart(oTunerFeature);
}

/******************************************************************************
 * Function:     vSetHDRadio
 * Description:  Wrapper function to toggle HD radio
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/
void FC_Gateway_TunerClientHandler::vSetHDRadio(bool bStatus)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("vSetHDRadio"));

    midw_fi_tcl_b8_Tun_DemodSwitch oDemodSwitchMask;
    midw_fi_tcl_b8_Tun_DemodSwitch oDemodSwitchValue;
    midw_fi_tcl_b8_Tun_DemodSwitch oDemodulationSwitch;

    FC_Gateway_TunerMasterClientHandler *poTunerMasterClientHandlerObj =
            procgenericgateway_tclMainApp::poGetInstance()->poGetTunerMasterClientHandler();

    midw_fi_tcl_e8_Band
            current_band = poTunerMasterClientHandlerObj->getCurrentStateBand();

    switch(current_band.enType)
    {
    case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
    {
        oDemodSwitchValue.vSetFM_HD(bStatus);
        oDemodSwitchMask.u8Value =
                midw_fi_tcl_b8_Tun_DemodSwitch::FI_C_U8_BIT_FM_HD;
    }
        break;
    case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
    case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
    {
        oDemodSwitchValue.vSetAM_HD(bStatus);
        oDemodSwitchMask.u8Value =
                midw_fi_tcl_b8_Tun_DemodSwitch::FI_C_U8_BIT_AM_HD;
    }
        break;
    default:
        return;
    }

    sendFID_TUN_S_SET_DEMODULATION_SWITCHMStart(
                oDemodulationSwitch,
                oDemodSwitchMask,
                oDemodSwitchValue);
}

/******************************************************************************
* Function:    poGetTunerInstance
* Description: function to get Tuner Client handler  instance
* Parameters:  void
* Return:      void
******************************************************************************/
FC_Gateway_TunerClientHandler*
poGetTunerInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    FC_Gateway_TunerClientHandler* oTunerObj  =
            FC_Gateway_TunerClientHandler::getInstance(poMainAppl);

    return oTunerObj;
}
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
