/*******************************************************************************
*
* FILE:          FC_Gateway_TunerMasterClientHandler.h
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for phone
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_Gateway_TunerMasterClientHandler_H_
#define _FC_Gateway_TunerMasterClientHandler_H_


#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#include <gio/gio.h>

#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "ap-tuner-enums.h"


class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;

#define AUDIOCOMMANDPLUGIN_DEFAULT_DBUS_TIMEOUT 60


class TunerBandToSourceIDMap
{
public:

    TunerBandToSourceIDMap():m_strBandName(""),m_iBandSourceID(0){}
    ~TunerBandToSourceIDMap(){}

    std::string m_strBandName;
    unsigned short m_iBandSourceID;
};


class FC_Gateway_TunerMasterClientHandler     : public
        ahl_tclBaseOneThreadClientHandler
{
public:

    FC_Gateway_TunerMasterClientHandler   (tVoid);
    FC_Gateway_TunerMasterClientHandler   (procgenericgateway_tclMainApp*
                                           poMainAppl);

    virtual ~FC_Gateway_TunerMasterClientHandler   ();

    // Overriding ahl_tclBaseOneThreadClientHandler methods.
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    static FC_Gateway_TunerMasterClientHandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);


    /* Registers with Phone Service for properties status updates */
    tVoid vRegisterProperty();

    /* De-registers the Phone properties to stop receiving the status updates */
    tVoid vDeRegisterProperty();

    /* Registers with Phone Service for
       properties status updates on HMI startup */

    tVoid vRegisterPropertyOnStartup();

    /* De-registers all the Phone properties on termination */
    tVoid vDeRegisterAllProperty();

    void vActivateAnnouncementStart(midw_fi_tcl_b32_AnnoType b32AnnoType);

    bool bSourceMapping();
    bool bSubscribeForSourceChange();
    void vUnsubscribeForSourceChangeSignal();
    static void onSrcChange(GDBusConnection *connection,
                            const gchar *sender_name,
                            const gchar *object_path,
                            const gchar *interface_name,
                            const gchar *signal_name,
                            GVariant *parameters,
                            gpointer user_data);

    /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

    virtual tBool sendFID_TUNMSTR_S_PRESET_HANDLINGMStart(
            midw_fi_tcl_e8_Preset_Action Preset_Action,
            tU8 u8Element_ID,
            midw_fi_tcl_e8_List List,
            midw_fi_tcl_e8_Band Band,
            tU32 Frequency = 0,
            tU32 PI = 0,
            tU16 SecondaryPI = 0);

    virtual tBool sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart(
            midw_fi_tcl_b32_AnnoType enAnnoType,
            midw_fi_tcl_b8_SourceAnno enAnnoSource);

    virtual tBool sendFID_TUNMSTR_S_MTC_SETMODEStart(
            midw_fi_tcl_b8_ModeType oMode);

    virtual tBool sendFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMStart(
            tBool Enable,
            midw_fi_tcl_e8_Source Source);

    virtual tBool sendFID_TUNMSTR_S_STATION_SELECTIONStart(
            midw_fi_tcl_e8_Band enBand,
            tU32 uFrequency);

    midw_fi_tcl_e8_Band getCurrentStateBand()
    {
        return _Band_FID_TUNMSTR_G_BAND_INFOStatus;
    }

    midw_fi_tcl_b32_AnnoType GetAnnoStatus()
    {
        midw_fi_tcl_b32_AnnoType oCurrentAnnoType;
        oCurrentAnnoType =
                _b32AnnouncementType_FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus;
        return oCurrentAnnoType;
    }

    unsigned int iGetSourceIdFM()
    {
        return m_sourceMapFM.m_iBandSourceID;
    }

    unsigned int iGetSourceIdAM()
    {
        return m_sourceMapAM.m_iBandSourceID;
    }

    unsigned int iGetSourceIdDAB()
    {
        return m_sourceMapDAB.m_iBandSourceID;
    }

    unsigned int iGetSourceIdDRM()
    {
        return m_sourceMapDRM.m_iBandSourceID;
    }

    GDBusProxy* poGetAudioGeniviProxy()
    {
        return m_poAudioGeniviProxy;
    }

    GDBusConnection* poGetAudioGeniviConnection()
    {
        return m_poAudioGeniviConnection;
    }

    void vSetSavePresetState(bool arg_bIsSavePreset)
    {
        m_bIsPresetSave = arg_bIsSavePreset;
    }

    void vSetAudioConnectedState(bool arg_bIsAudioConnected)
    {
        m_bIsAudioConnected = arg_bIsAudioConnected;
    }

    bool bGetAudioDBusConnectionState()
    {
        return m_bIsAudioConnected;
    }

private:
    /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

    /*------------------------Status Updates---------------------------------*/
    virtual tVoid vHandleFID_TUNMSTR_G_BAND_INFOOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_G_PRESET_LISTOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_G_ANNO_BUTTON_STATUSOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_G_MTC_SETMODE_STATUSOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_S_STATION_SELECTIONOpMResult(
            amt_tclServiceData* poMessage);

    /*------------------------Method Result---------------------------------*/
    virtual tVoid vHandleFID_TUNMSTR_S_PRESET_HANDLINGOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTOpResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_S_MTC_SETMODEOpResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleFID_TUNMSTR_S_SOURCE_SETUP_OPTIONOpMResult(
            amt_tclServiceData* poMessage);


    /*--------------------Status Updates Handlers---------------------------*/
    virtual tVoid onFID_TUNMSTR_G_BAND_INFOStatus(midw_fi_tcl_e8_Band Band);

    virtual tVoid onFID_TUNMSTR_G_PRESET_LISTStatus(
            midw_fi_tcl_e8_List List,
            std::vector<midw_fi_tcl_PresetList,
            std::allocator<midw_fi_tcl_PresetList> > ListOfStations);

    virtual tVoid onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(
            midw_fi_tcl_b32_AnnoType oAnnoType,
            midw_fi_tcl_e8_Source oSource);

    virtual tVoid onFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(
            midw_fi_tcl_b8_ModeType oMode);

    /*--------------------Method Result Handlers---------------------------*/
    virtual tVoid onFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMResult(
            midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse);

    virtual tVoid onFID_TUNMSTR_S_STATION_SELECTIONMResult(
            midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse);

    virtual tVoid onFID_TUNMSTR_S_PRESET_HANDLINGMResult(
            midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse,
            midw_fi_tcl_e8_Source Source,
            midw_fi_tcl_e8_Action Action);

private:
    /***************************************************************************
   * value of each received status
   ***************************************************************************/


    midw_fi_tcl_e8_Band
    _Band_FID_TUNMSTR_G_BAND_INFOStatus;

    midw_fi_tcl_e8_List
    _List_FID_TUNMSTR_G_PRESET_LISTStatus;

    std::vector<midw_fi_tcl_PresetList,
    std::allocator<midw_fi_tcl_PresetList> >
    _ListOfStations_FID_TUNMSTR_G_PRESET_LISTStatus;

    midw_fi_tcl_b32_AnnoType
    _b32AnnouncementType_FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus;

    midw_fi_tcl_e8_Source
    _Source_FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus;

    bool    _bIsAMActive;
    bool    m_bIsPresetSave;
    bool    m_bIsAudioConnected;

private:
    
    /* Message map definition macro */
    DECLARE_MSG_MAP(FC_Gateway_TunerMasterClientHandler);
    procgenericgateway_tclMainApp *m_poMainApp;
    GDBusProxy      *m_poAudioGeniviProxy;
    GDBusConnection *m_poAudioGeniviConnection;
    
    TunerBandToSourceIDMap m_sourceMapAM;
    TunerBandToSourceIDMap m_sourceMapFM;
    TunerBandToSourceIDMap m_sourceMapDAB;
    TunerBandToSourceIDMap m_sourceMapDRM;

    guint m_iSrcAddedSubscriptionID;
    guint m_iSrcRemovedSubscriptionID;

public:
    static FC_Gateway_TunerMasterClientHandler*
    m_poFC_Gateway_TunerMasterClientHandler;

};

#endif

#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
