/******************************************************************************
*
* FILE:          DBusToTunerProxyWrapper.h
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   Wrapper to DBus
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _TUNER_GENERIC_CLIENT_INTERFACE_H_
#define _TUNER_GENERIC_CLIENT_INTERFACE_H_


#include "ap-tuner-enums.h"
#include "ap-tuner-error-enums.h"

#include <stdlib.h>
#include <stdbool.h>
#include <glib.h>

#ifdef __cplusplus
#include "FC_Gateway_TunerClientHandler.h"
#include "FC_Gateway_TunerMasterClientHandler.h"
#include "FC_Gateway_TunerDABClientHandler.h"
#endif //__cplusplus

#ifdef __cplusplus
extern "C"
{
#endif

gboolean bSendGetStationListResult(GVariant* arg_stataionList);
gboolean bSendStationListUpdate(ApTunerBand arg_band,GVariant* arg_stataionList);
bool bGetDABStationList();
bool bTuneWithFreqStep(unsigned char arg_direction, unsigned int arg_step_size);
bool bSeekToNextStation(guchar arg_direction);
void vScan();
bool bCancelSeek();
bool bCancelSearch();
bool bSavePreset(unsigned char cElementID,
                 ApTunerBand eBand,
                 unsigned long int uFrequency,
                 unsigned long int uPI,
                 unsigned long int uSecondaryPI);
                 
bool bTuneToPreset(unsigned char cElementID,
                   ApTunerBand eBand);                 

bool bSetBand(ApTunerBand eband);

bool bSetFrequency(unsigned int frequency, ApTunerBand eband);

bool bSetFrequencyDAB(unsigned int frequency);

bool bSetFrequencyAMFM(unsigned int frequency,ApTunerBand eband);

bool bTuneToPI(unsigned int program_id);

bool bSetConfigurationSettings(GVariant *configurations);

void vSetTA(bool bTPState);

void vSetStationInfo(GVariant *stationInfo);

void vSetConfigSettingsProp(GVariant* arg_ConfigSettings);

void vSetPresetListProp(GVariant* arg_PresetList);

void vRequestAvblStn(ApTunerBand eBand);

void vActivateSeamlessSwitch(bool bActivate);

void vSendSearchStatus(ApTunerSearchStationStatus eSearchStatus);

void vSendSeekStatus(ApTunerSeekStatus eSeekStatus);

//
void vSendSavePresetResult();

void vSendSavePresetError(APTunerError eError,char* sErrMsg);

void vSendTuneResult();

void vSendTuneError(APTunerError eError);

void vSendCancelSearchStnResult();

void vSendCancelSearchStnError(APTunerError eError);

void vSendCancelSeekResult();

void vSendCancelSeekError(APTunerError eError);

void vSendSetBandResult();

void vSendSetBandError(APTunerError eError);

void vSendSetConfigResult();

void vSendSetConfigError(APTunerError eError);

void vSendSetFreqResult();

void vSendSetFreqError(APTunerError eError);

void vSendTuneToPresetResult();

void vSendTuneToPresetError(APTunerError eError);

void vSendTuneToPIResult();

void vSendTuneToPIError(APTunerError eError);

void vSendGetStationListError(APTunerError eError, char* sErrMsg);
															  
#ifdef __cplusplus
}
#endif //__cplusplus

#ifdef __cplusplus
/******************************************************************************
* Function:    poGetTunerInstance
* Description: function to get Tuner client handler instance
* Parameters:  procgenericgateway_tclMainApp pointer
* Return:      FC_Gateway_TunerClientHandler pointer
******************************************************************************/

FC_Gateway_TunerClientHandler*  poGetTunerInstance(procgenericgateway_tclMainApp* 
                                               poMainAppl);		

/******************************************************************************
* Function:    poGetTunerMasterInstance
* Description: function to get Tuner master client handler instance
* Parameters:  procgenericgateway_tclMainApp pointer
* Return:      FC_Gateway_TunerMasterClientHandler pointer
******************************************************************************/

FC_Gateway_TunerMasterClientHandler*  poGetTunerMasterInstance(procgenericgateway_tclMainApp* 
                                               poMainAppl);		

/******************************************************************************
* Function:    poGetTunerDABInstance
* Description: function to get Tuner DAB client handler instance
* Parameters:  procgenericgateway_tclMainApp pointer
* Return:      cea_FC_Gateway_TunerClientHandler pointer
******************************************************************************/

FC_Gateway_TunerDABClientHandler*  poGetTunerDABInstance(procgenericgateway_tclMainApp* 
                                               poMainAppl);		
#endif //__cplusplus

#endif //_TUNER_GENERIC_CLIENT_INTERFACE_H_

#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC