/*!
*******************************************************************************
* @file             : TextToSpeech_ClientInterface.h
*******************************************************************************
*  - PROJECT:       : fc_genericgateway
*  - SW-COMPONENT   : Gateway - TTS
*  - DESCRIPTION    : C Wrapper for DBus and CCA TTS Client Handler.
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|----------------------
* 14.7.2016 | BCP9KOR (RBEI/EC02) | 1.0.0 | C Wrapper for DBus and TTS Client Handler
* 14.7.2016 | BCP9KOR (RBEI/EC02) | 1.0.0 | C Wrapper for DBus and TTS Client Handler
*
******************************************************************************/

#ifndef _TTS_CLIENT_INTERFACE_H_
#define _TTS_CLIENT_INTERFACE_H_

#include <stdbool.h>
#include "ap-tts-enums.h"
#include "ap-tts-error-enums.h"

#ifdef __cplusplus
#include "FC_Gateway_TTSClientHandler.h"
#endif

//TTS D-Bus WRAPPERS
#ifdef __cplusplus
extern "C"
{
#endif
//Wrapper functions.

 /******************************************************************************
* Function:    bStartTextToSpeech
* Description: Wrapper function for bStartTextToSpeech
* Parameters:  const char *arg_text_to_speak, unsigned char arg_priority,
               const char *arg_language, int arg_voice_rate,
               int arg_volume, int arg_voice_pitch,
					unsigned char arg_voice_category 
* Return:      bool
******************************************************************************/
bool bStartTextToSpeech(const char *arg_text_to_speak,
                        unsigned char arg_priority,
                        const char *arg_language,
                        int arg_voice_rate,
                        int arg_volume,
                        int arg_voice_pitch,
                        unsigned char arg_voice_category);

/******************************************************************************
* Function:    bCancel
* Description: Wrapper function for bCancel
* Parameters:  void
* Return:      bool
******************************************************************************/
bool bCancel();

/******************************************************************************
* Function:    bGetTextToSpeechStateMethodStart
* Description: Wrapper function for GetTextToSpeechMethodStart 
* Parameters:  void
* Return:      bool
******************************************************************************/
bool bGetTextToSpeechStateMethodStart();

/******************************************************************************
* Function:    vGetTextToSpeechStateMethodResult
* Description: Wrapper function for GetTextToSpeechMethodResult
* Parameters:  enum ApTtsState
* Return:      void
******************************************************************************/
void vGetTextToSpeechStateMethodResult(ApTtsState eState);

/******************************************************************************
* Function:    vRequestTextToSpeechStateMethodResult
* Description: Wrapper function for request text to speech method result 
* Parameters:  void
* Return:      void
******************************************************************************/
void vRequestTextToSpeechStateMethodResult();

/******************************************************************************
* Function:    vRequestTextToSpeechStateMethodError
* Description: Wrapper function for request text to speech method result 
* Parameters:  enum ApTtsError 
* Return:      void
******************************************************************************/
void vRequestTextToSpeechStateMethodError(ApTtsError eState);

/******************************************************************************
* Function:    vPauseMethodResult
* Description: Wrapper function for vPauseMethodResult 
* Parameters:  void 
* Return:      void
******************************************************************************/
void vPauseMethodResult();

/******************************************************************************
* Function:    vPauseMethodError
* Description: Wrapper function for vPauseMethodError 
* Parameters:  enum ApTtsError 
* Return:      void
******************************************************************************/
void vPauseMethodError(ApTtsError eState);

/******************************************************************************
* Function:    vResumeMethodResult
* Description: Wrapper function for vResumeMethodResult 
* Parameters:  void 
* Return:      void
******************************************************************************/
void vResumeMethodResult();

/******************************************************************************
* Function:    vResumeMethodError
* Description: Wrapper function for vResumeMethodError 
* Parameters:  enum ApTtsError 
* Return:      void
******************************************************************************/
void vResumeMethodError(ApTtsError eState);

/******************************************************************************
* Function:    vCancelMethodResult
* Description: Wrapper function for vCancelMethodResult 
* Parameters:  void 
* Return:      void
******************************************************************************/
void vCancelMethodResult();

/******************************************************************************
* Function:    vCancelMethodError
* Description: Wrapper function for vCancelMethodError 
* Parameters:  enum ApTtsError 
* Return:      void
******************************************************************************/
void vCancelMethodError(ApTtsError eState);

/******************************************************************************
* Function:    bNotifyTextToSpeechState
* Description: Wrapper function for send_notify_textto_speech 
* Parameters:  enum ApTtsState 
* Return:      bool
******************************************************************************/
bool
bNotifyTextToSpeechState (ApTtsState eState);

/******************************************************************************
* Function:    vExportAGWTTSInterface
* Description: function to expose TTS interface
* Parameters:  void
* Return:      void
******************************************************************************/
void vExportAGWTTSInterface();

/******************************************************************************
* Function:    vUnexportAGWTTSInterface
* Description: function to unexport TTS interface
* Parameters:  void
* Return:      void
******************************************************************************/
void vUnexportAGWTTSInterface();
/******************************************************************************
* Function:    vPreferences
* Description: Wrapper function for handle_set_preferences
* Parameters:  int,int
* Return:      void
******************************************************************************/
void vPreferences(int voice_rate_p,int volume_p);


#ifdef __cplusplus
}
#endif //__cplusplus

#ifdef __cplusplus

/******************************************************************************
* Function:    poGetTTSInstance
* Description: function to get TTS instance
* Parameters:  void
* Return:      void
******************************************************************************/

FC_Gateway_TTSClientHandler*  poGetTTSInstance(procgenericgateway_tclMainApp* 
                                               poMainAppl);
															  
/******************************************************************************
* Function:    vOnTTSServiceAvailable
* Description: function to invoke TTS service available.
* Parameters:  void
* Return:      void
******************************************************************************/

void  vOnTTSServiceAvailable();
															  
/******************************************************************************
* Function:    vOnTTSServiceAvailable
* Description: function to invoke TTS service unavailable.
* Parameters:  void
* Return:      void
******************************************************************************/

void  vOnTTSServiceUnAvailable();

#endif //__cpluspls

#endif //_TTS_CLIENT_INTERFACE_H_
