/*!
********************************************************************************
* @file             : SPClientHandler.h
********************************************************************************
*  - PROJECT:       : SP Client Handler Header
*  - SW-COMPONENT   : IPCM
*  - DESCRIPTION    : Dbus client to connect to SP Middleware
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : -
*  - HISTORY
*
*  Date     | Name               |Version| Modification
* ----------|--------------------|--------------------------|-----------------------
*02.01.2018 | RVH5KOR(RBEI/ECO2) | 1.0.0 | Dbus client impl. to connect to SP
*******************************************************************************/

#ifndef SP_CLIENTHANDLER_H
#define SP_CLIENTHANDLER_H
#include <glib.h>
#include <gio/gio.h>

/******************************************************************
 * Function:     vSPClientProxyCallBack
 * Description:  This is call back function for SP proxy
                 object creation
 * Parameters:   source_object, res, user_data
 * Return:       void
 ******************************************************************/
void vSPClientProxyCallBack( GObject *source_object,
                                  GAsyncResult *res,
                                gpointer user_data);

/******************************************************************
 * Function:     bProcessAppMessage
 * Description:  This is call back function for processing of the
 *               app message
 * Parameters:   key, value, user_data
 * Return:       gboolean
 ******************************************************************/
gboolean
bProcessAppMessage (const gchar *key,
                     GVariant *value,
                 gpointer user_data);

/******************************************************************
 * Function:     bHandleClientDisconnected
 * Description:  This is call back function for handling the
 *               disconnection
 * Parameters:   errorCode, user_data
 * Return:       gboolean
 ******************************************************************/
gboolean
bHandleClientDisconnected (guint16 errorCode,
                         gpointer user_data);

/******************************************************************************
 * Function:      vProcessAppMsgResult
 * Description:   This function handles the result of ProcessAppMsg
                  non-blocking DBus call
 * Parameters:    resObject, result sync pointer, user_data
 * Return:        void
 ******************************************************************************/
void vProcessAppMsgResult( GObject* pObj,
                      GAsyncResult *res,
                      gpointer user_data );

/****************************************************************************
 * Function:    sp_service_appeared
 * Description: Name appeared call back for SP
 * Parameters:  connection , service_name , owner_name, userdata
 * Return:      void
 *****************************************************************************/
void
sp_service_appeared (GDBusConnection *connection, const gchar *name,
               const gchar *name_owner, gpointer user_data);

/******************************************************************
 * Function:     vSPClientProxyCallBack
 * Description:  This is call back function for SP proxy
                 object creation
 * Parameters:   source_object, res, user_data
 * Return:       void
 ******************************************************************/
void vSPClientProxyCallBack( GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data );

/****************************************************************************
 * Function:    sp_service_vanished
 * Description: Name disappeared call back for ECM service
 * Parameters:  connection, service_name, user_data
 * Return:      void
 *****************************************************************************/
void
sp_service_vanished (GDBusConnection *connection,
                      const gchar *service_name,
                      gpointer user_data);

/******************************************************************************
 * Function:      clearGatewaySPClientProxy
 * Description:   This function clears the AGW SP Proxy
 * Parameters:    void
 * Return:        void
 ******************************************************************************/
void clearGatewaySPClientProxy();

#endif //SP_CLIENTHANDLER_H
