/*!
********************************************************************************
* @file             : SP_ClientInterface.h
********************************************************************************
*  - PROJECT:       : Header exposed to the SP Client Handler Plugin
*  - SW-COMPONENT   : IPCM
*  - DESCRIPTION    : Declares interfaces between Gateway and SP Client plugin
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : -
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|------------------------
*03.01.2017 | RVH5KOR(RBEI/ECO2) | 1.0.0 | Dbus client impl. to connect to SP
*******************************************************************************/
#include <glib.h>

#ifndef SP_CLIENTINTERFACE_H
#define SP_CLIENTINTERFACE_H

#define SP_CONNECTED_SERVICE_BUS_NAME             "com.bosch.SeamlessMiddleware"
#define SP_CONNECTED_SERVICE_OBJ_PATH             "/com/bosch/SeamlessMiddleware/SeamlessPairingServer"
#define SP_CONNECTED_SERVICE_INTERFACE_NAME       "com.bosch.SeamlessMiddleware.SeamlessPairingServer"

/*******************************************************************************
 * Function:    sp_service_watch
 * Description: This methods intiates the watch for SP service
 * Parameters:  void
 * Return:      gboolean
 ******************************************************************************/
gboolean sp_service_watch();

/*******************************************************************************
 * Function:    sp_service_unwatch
 * Description: This methods uninitializes the SP service
 * Parameters:  void
 * Return:      void
 ******************************************************************************/
void sp_service_unwatch();

/*******************************************************************************
 * Function:     vExportAGWSPInterface
 * Description:  This method exposes the gateway SP methods
 * Parameters:   void
 * Return:       void
 ******************************************************************************/
void vExportAGWSPInterface();

/*******************************************************************************
 * Function:     vUnexportAGWSPInterface
 * Description:  This method unexposes the gateway SP methods
 * Parameters:   void
 * Return:       void
 ******************************************************************************/
void vUnexportAGWSPInterface();

/******************************************************************************
* Function:    bProcessAppMsg
* Description: This method is to forward the app msg to SPMW
* Parameters:  Key, Value, User_data
* Return:      gboolean
*******************************************************************************/
gboolean bProcessAppMsg(const gchar *key,
                         GVariant *value,
                     gpointer user_data);

/******************************************************************************
* Function:    bHandleSPSConnectionState
* Description: This method is to forward SPS Connection state 
* Parameters:  ErrorCode, User_data
* Return:      gboolean
*******************************************************************************/
gboolean bHandleSPSConnectionState(guint16 connState,
                     gpointer user_data);

#endif //SP_CLIENTINTERFACE_H
