/******************************************************************
*FILE: ap-sp-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the error enums related to
*             com.bosch.AutomotiveProxy.SeamlessPairingServer
              interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_SP_ERROR_H
#define AP_SP_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_SP_ERROR:
 *
 * Error domain for #APSpError
 *
 * Since: 0.1.0
 */
#define AP_SP_ERROR ap_sp_error_quark ()
GQuark ap_sp_error_quark (void);

/**
 * APSpError:
 * @AP_SP_ERROR_INTERNAL :   Internal / unknown error
 * @AP_SP_ERROR_SPMW_UNAVAILABLE: Client not reachable.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_SP_ERROR_INTERNAL = 0,
  AP_SP_ERROR_SPMW_UNAVAILABLE
} APSpError;

G_END_DECLS

#endif /* !AP_SP_ERROR_H */
