/******************************************************************************
*
* FILE:          SPDbusHandler.h
*
* PROJECT:       SP
*
* DESCRIPTION:   DBUS service handler for ECM.
*
* AUTHOR:        RVH5KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2017 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/
#ifndef SP_DBUS_HANDLER_H
#define SP_DBUS_HANDLER_H

#include "SeamlessPairingServer_generated.h"
#include <glib.h>


/******************************************************************************
* Function:    bHandle_process_app_message
* Description: used to push the certificate 
* Parameters:  proxy object, invocation pointer, user data
* Return:      gboolean
*****************************************************************************/
gboolean
bHandle_process_app_message (SeamlessPairingServer *object,
                         GDBusMethodInvocation *invocation,
                                          const gchar *key,
                                           GVariant *value,
                                       gpointer user_data);

/******************************************************************************
* Function:    bHandle_SPSConnection_State
* Description: Handler for SPS Connection state
* Parameters:  proxy object, invocation pointer, user data
* Return:      gboolean
*****************************************************************************/
gboolean
bHandle_SPSConnection_State( SeamlessPairingServer *object,
                             GDBusMethodInvocation *invocation,
                             guint16 connState,
                             gpointer user_data );
						
/******************************************************************************
* Function:    poGetSPProxyObj
* Description: Gives the Proxy object of Certificate Handler
* Parameters:  void
* Return:      SeamlessPairingServer *
*****************************************************************************/
SeamlessPairingServer *poGetSPProxyObj();

/******************************************************************************
* Function:    bInitializeSP
* Description: Initializes the plugin by creating skeleton object
* Parameters:  void 
* Return:      gboolean - TRUE when skeleteon creation is success,
                          FALSE when skeleton creation fails
*****************************************************************************/
gboolean bInitializeSP();

/******************************************************************************
* Function:    vUninitializeSP
* Description: This method unintializes the SP gateway component
* Parameters:  void
* Return:      void
*****************************************************************************/
void vUninitializeSP();

/*******************************************************************************
 * Function:    bRegisterSPServiceProperties
 * Description:
 * Parameters: void
 * Return: gboolean
 ******************************************************************************/
gboolean bRegisterSPServiceProperties();
						 
#endif //SP_DBUS_HANDLER_H						 
						 
