/******************************************************************
*FILE: ap-sdc-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for SDC
*COPYRIGHT: © 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-sdc-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.SDCError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_SDC_ERROR_UNKNOWN,
        ERROR_PREFIX "UnknownError"
    },
    {
        AP_SDC_ERROR_BAD_DATA,
        ERROR_PREFIX "BadDataRecieved"
    },
    {
        AP_SDC_ERROR_INVALID_INPUT,
        ERROR_PREFIX "InvalidInput"
    }
};



GQuark
ap_sdc_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-sdc-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}

