/******************************************************************************
*
* FILE:          SDC_DbusHandler.h
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   DBUS service handler for SDC.
*
* AUTHOR:        IPD5KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2017 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/
#ifndef SDC_DBUS_HANDLER_H
#define SDC_DBUS_HANDLER_H

#include "SecureDataCommunication_generated.h"
#include "ap-sdc-enums.h"

#include <glib.h>

/******************************************************************************
* Function:    handle_sign_device_key 
* Description: The method generates signature on the gioven data
* Parameters:  proxy object, invocation pointer, data to be signed in,
*              algorithm, user_data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_sign_with_device_key ( SecureDataCommunication* object,
                              GDBusMethodInvocation*   invocation,
                              GVariant* data,
                              guint64   algorithm,
                              gpointer  user_data);

/******************************************************************************
* Function:    handle_decrypt_with_device_key
* Description: The method decrypts the cipher text.
* Parameters:  proxy object, invocation pointer, cipherText,
*              algorithm, user data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_decrypt_with_device_key ( SecureDataCommunication *object,
                                 GDBusMethodInvocation   *invocation,
                                 GVariant* cipherText, 
                                 guint64   algorithm,
                                 gpointer  user_data);

/******************************************************************************
* Function:    handle_check_certificate
* Description: The method checks whether given certificate is valid
* Parameters:  proxy object, invocation pointer, certificate, user_data
* Return:      gboolean
*******************************************************************************/
gboolean
handle_check_certificate ( SecureDataCommunication *object,
                           GDBusMethodInvocation   *invocation,
                           GVariant*  certificate,
                           gpointer   user_data );

/******************************************************************************
* Function:    check_cert_result
* Description: The method sends the result of checkCert
* Parameters:  proxy object, result object, user_data
* Return:      gboolean
*****************************************************************************/
void check_cert_result ( GObject*      pObj,
                         GAsyncResult* res,
                         gpointer user_data );

/******************************************************************************
* Function:    handle_get_device_certificate
* Description: The method provides the device certificate data as byte array
* Parameters:  proxy object, invocation pointer, algorithm, user_data
* Return:      gboolean
*****************************************************************************/
gboolean
handle_get_device_certificate ( SecureDataCommunication *object,
                                GDBusMethodInvocation *invocation,
                                guint64 algorithm,
                                gpointer user_data );

/******************************************************************************
* Function:    bInitializeSDC
* Description: Intializes the handler by exporting skeleton object
* Parameters:  void
* Return:      gboolean - TRUE when skeleton export success
                        - FALSE when skeleton export fails
*****************************************************************************/
gboolean bInitializeSDC();

/******************************************************************************
* Function:    poGetCommProxyObj
* Description: provides the communication protocol proxy object
* Parameters:  void
* Return:      SecureDataCommunication*
*****************************************************************************/
SecureDataCommunication *poGetSDCProxyObj();

/******************************************************************************
* Function:    uninitializeSDC
* Description: unintializes the SDC component by releasing proxy
* Parameters:  void
* Return:      void
*****************************************************************************/
void uninitializeSDC();

#endif //SDC_DBUS_HANDLER_H

