/******************************************************************************
*
* FILE:          PhoneDataTyes.c
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   Phone data types utility
*
* AUTHOR:        RHK6KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2016 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/

#include "PhoneDataTypes.h"
#include <stdlib.h>

void vCleanContactInfoData(ContactInfo *arg_ContactInfoData)
{
    if(arg_ContactInfoData->contactNameArray != NULL)
    {
        for (int iCount = 0; iCount < 2; iCount++)
        {
            if(NULL != arg_ContactInfoData->contactNameArray[iCount])
                free(arg_ContactInfoData->contactNameArray[iCount]);
        }
        free(arg_ContactInfoData->contactNameArray);
    }

    if(arg_ContactInfoData->phoneNumberArray != NULL)
    {
        for (int iCount = 0;
             iCount < arg_ContactInfoData->ui_PhoneNumberCount; iCount++)
        {
            if(NULL != arg_ContactInfoData->phoneNumberArray[iCount])
                free(arg_ContactInfoData->phoneNumberArray[iCount]);
        }
        free(arg_ContactInfoData->phoneNumberArray);
    }

    if(arg_ContactInfoData->emailAddressArray != NULL)
    {
        for (int iCount = 0;
             iCount < arg_ContactInfoData->ui_EmailAddressCount; iCount++)
        {
            if(NULL != arg_ContactInfoData->emailAddressArray[iCount])
                free(arg_ContactInfoData->emailAddressArray[iCount]);
        }
        free(arg_ContactInfoData->emailAddressArray);
    }

    if(arg_ContactInfoData->strContactHandle != NULL)
    {
        free(arg_ContactInfoData->strContactHandle);
    }
}

void vCleanCallHistoryData(CallHistoryInfo *arg_CallHistoryData)
{
    if(arg_CallHistoryData->sRemoteParty != NULL)
    {
        free(arg_CallHistoryData->sRemoteParty);
    }
    if(arg_CallHistoryData->sStartTime != NULL)
    {
        free(arg_CallHistoryData->sStartTime);
    }
}
