#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "PhoneDataHandler.h"
#include "Utility.h"
#include "Phone_ClientInterface.h"
//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Phone);

tclCallHistoryItem::tclCallHistoryItem()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("tclCallHistoryItem::tclCallHistoryItem()"));
    m_uContactHandle = 0;
    m_enDirection = AP_TELEPHONY_CALL_DIRECTION_DIALED;
}

tclCallHistoryItem::tclCallHistoryItem(unsigned int arg_uContactHandle,
                                       std::string arg_sPhoneNum,
                                       std::string arg_sStartTime,
                                       ApTelephonyCallDirection arg_enDirection)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("tclCallHistoryItem::tclCallHistoryItem()"\
                       "parameterized"));

    m_uContactHandle = arg_uContactHandle;
    m_sPhoneNum.assign(arg_sPhoneNum);
    m_sStartTime.assign(arg_sStartTime);
    m_enDirection = arg_enDirection;
}

tclCallHistoryItem::~tclCallHistoryItem()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("tclCallHistoryItem::~tclCallHistoryItem ()"));
}

void tclCallHistoryItem::vUpdateCallHistoryItem(
        unsigned int arg_uContactHandle,
        std::string arg_sPhoneNum,
        std::string arg_sStartTime,
        ApTelephonyCallDirection arg_enDirection)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("tclCallHistoryItem::vUpdateCallHistoryItem()"));

    m_uContactHandle = arg_uContactHandle;
    m_sPhoneNum.assign(arg_sPhoneNum);
    m_sStartTime.assign(arg_sStartTime);
    m_enDirection = arg_enDirection;
}							 

unsigned int tclCallHistoryItem::uGetContactHandle()
{
    return m_uContactHandle;
}

std::string tclCallHistoryItem::sGetPhoneNumber()
{
    return m_sPhoneNum;
}

std::string tclCallHistoryItem::sStartTime()
{
    return m_sStartTime;
}

ApTelephonyCallDirection tclCallHistoryItem::eGetCallDirection()
{
    return m_enDirection;
}

void 
vSendGetCallHistorySliceDataHandler(std::vector<tclCallHistoryItem>
                                    arg_callHistoryList)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("+vSendGetCallHistorySliceDataHandler()"));

    int i_arrlen = arg_callHistoryList.size();
    DLT_LOG(AGW_Phone, DLT_LOG_INFO,
            DLT_STRING("vSendGetCallHistorySliceDataHandler : i_arrlen = "),
            DLT_INT(i_arrlen));

    CallHistoryInfo* l_CallHistoryInfoItems = (CallHistoryInfo*) malloc(
                i_arrlen * sizeof(CallHistoryInfo));

    int iCount = 0;
    for(std::vector<tclCallHistoryItem>::iterator
        iIterator = arg_callHistoryList.begin();
        iIterator != arg_callHistoryList.end(); iIterator++)
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING(iIterator->sGetPhoneNumber().c_str()));
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING(iIterator->sStartTime().c_str()));
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_INT(iIterator->eGetCallDirection()));
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_INT(iIterator->uGetContactHandle()));

        std::string strPhoneNumber = iIterator->sGetPhoneNumber();
        l_CallHistoryInfoItems[iCount].sRemoteParty =
                (char*)malloc((strPhoneNumber.length()+1) * sizeof(char));

        memset(l_CallHistoryInfoItems[iCount].sRemoteParty, 0,
               strPhoneNumber.length() + 1);

        strncpy(l_CallHistoryInfoItems[iCount].sRemoteParty,
                strPhoneNumber.c_str(), strPhoneNumber.length());

        std::string strStartTime = iIterator->sStartTime();
        l_CallHistoryInfoItems[iCount].sStartTime =
                (char*)malloc((strStartTime.length()+1) * sizeof(char));

        memset(l_CallHistoryInfoItems[iCount].sStartTime, 0,
               strStartTime.length() + 1);
        strncpy(l_CallHistoryInfoItems[iCount].sStartTime,
                strStartTime.c_str(), strStartTime.length());

        l_CallHistoryInfoItems[iCount].uDirection =
                iIterator->eGetCallDirection();
        l_CallHistoryInfoItems[iCount].iContactHandle =
                iIterator->uGetContactHandle();

        iCount++;
    }

    vGetCallHistoryInSliceResult(l_CallHistoryInfoItems, iCount);
}
#endif
