/*******************************************************************************
*
* FILE:          FC_Gateway_PhoneClientHandler.cpp
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for phone
* History : 
*	Date			|  Name 						|	Description
*	20-07-2016		|  Ashwini Savadi RBEI/ECO22  	|	Added changes for CreateMessage, 
*														ProvideMessageHeader, 
*														ProvideMessageBody, SendMessage

*   12-07-2017      | Deepa Jose                    |   Added methods for
                                                        PrepareMessageList,
                                                        Get message in slice and
                                                        destroy message list
*******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/*SMS*/
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_VERSION
#include "fi_msgfw_if.h"

#include "FC_Gateway_MessageClientHandler.h"

#ifdef __cplusplus
extern "C" {
#endif
#include "MessageDataTypes.h"
#ifdef __cplusplus
}
#endif
#include "procgenericgateway_tclMainApp.h"
#include "Phone_ClientInterface.h"
#include "dlt/dlt.h"
#include <stdlib.h>

//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Phone);

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define MESSAGE_HANDLE 1
#define ZERO 0


fc_gateway_tcl_messageclienthandler*
fc_gateway_tcl_messageclienthandler::
m_pofc_gateway_tcl_messageclienthandler = NULL;

/* CCA Message Map - Maps the Function ID, Opcode and Function handler */
BEGIN_MSG_MAP(fc_gateway_tcl_messageclienthandler, ahl_tclBaseWork)

/* Phone Service Method - CreateMessage */
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_CREATEMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleCreateMessageOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_CREATEMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCreateMessageOpMError)

/* Phone Service Method - ProvideMessageHeader */
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_PROVIDEMESSAGEHEADER,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleProvideMessageHeaderOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_PROVIDEMESSAGEHEADER,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleProvideMessageHeaderOpMError)

/* Phone Service Method - ProvideMessageBody */
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_PROVIDEMESSAGEBODY,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleProvideMessageBodyOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_PROVIDEMESSAGEBODY,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleProvideMessageBodyOpMError)

/* Phone Service Method - SendMessage */
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_SENDMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleSendMessageOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_SENDMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleSendMessageOpMError)

/* Message Notification */
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_MESSAGENOTIFICATION,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   vHandleMessageNotificationOpStatus)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_MESSAGENOTIFICATION,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleMessageNotificationOpError)

/* Messaging Service method - GetMessage List*/
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_GETMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleGetMessageOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_GETMESSAGE,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleGetMessageOpMError)

/*CreateMessageList and RequestSlice*/
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_CREATEMESSAGELIST,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleCreateMessageListOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_CREATEMESSAGELIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleCreateMessageListOpMError)

ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_REQUESTSLICEMESSAGELIST,
                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                   vHandleRequestSliceMessageListOpMResult)
ON_MESSAGE_SVCDATA(MOST_MSGFI_C_U16_REQUESTSLICEMESSAGELIST,
                   AMT_C_U8_CCAMSG_OPCODE_ERROR,
                   vHandleRequestSliceMessageListOpMError)


END_MSG_MAP()

/*******************************************************************************
 * Function:     getInstance
 * Description:  Gets the instance of phone client handler (singleton)
 * Parameters:   procgenericgateway_tclMainApp*
 * Return:       fc_gateway_tcl_messageclienthandler*
 ******************************************************************************/
fc_gateway_tcl_messageclienthandler*
fc_gateway_tcl_messageclienthandler::getInstance(procgenericgateway_tclMainApp*
                                                 poMainAppl)
{

    if(m_pofc_gateway_tcl_messageclienthandler == NULL)
    {
        m_pofc_gateway_tcl_messageclienthandler =
                new fc_gateway_tcl_messageclienthandler(poMainAppl);
    }

    return m_pofc_gateway_tcl_messageclienthandler;
}

/*******************************************************************************
 * Function:     fc_gateway_tcl_messageclienthandler
 * Description:  Constructor
 * Parameters:   procgenericgateway_tclMainApp*
 * Return:       NA
 ******************************************************************************/

fc_gateway_tcl_messageclienthandler::fc_gateway_tcl_messageclienthandler(
        procgenericgateway_tclMainApp *poMainAppl)
    :ahl_tclBaseOneThreadClientHandler((ahl_tclBaseOneThreadApp*)poMainAppl,
                                       CCA_C_U16_SRV_FB_MESSAGING,
                                       MOST_MSGFI_C_U16_SERVICE_MAJORVERSION,
                                       MOST_MSGFI_C_U16_SERVICE_MINORVERSION)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("unable to message to component"));
    m_PhoneNumber.clear();
    m_MessageText.clear();
    m_bIsServiceAvailable = 0;
    m_tu32lastMessageHandle = 0;
    m_bIsMessageNotification = FALSE;
    m_pBTDeviceManager =
            fc_gateway_tcl_bluetoothclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    vAddAutoRegisterForProperty(MOST_MSGFI_C_U16_MESSAGENOTIFICATION);
}

/*******************************************************************************
 * Function:     fc_gateway_tcl_messageclienthandler
 * Description:  Destructor
 * Parameters:   void
 * Return:       NA
 ******************************************************************************/

fc_gateway_tcl_messageclienthandler::~fc_gateway_tcl_messageclienthandler()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler Destructor : "),
            DLT_STRING( __FUNCTION__));

    if(m_pofc_gateway_tcl_messageclienthandler!= NULL)
    {
        delete m_pofc_gateway_tcl_messageclienthandler;
        m_pofc_gateway_tcl_messageclienthandler = NULL;
        m_tu32lastMessageHandle = 0;
    }
    vRemoveAutoRegisterForProperty(MOST_MSGFI_C_U16_MESSAGENOTIFICATION);
}

/*******************************************************************************
 * Function:    vOnServiceAvailable
 * Description: Callback on CCA service available.
 * Parameters:  none
 * Return:      tVoid
 ******************************************************************************/

tVoid fc_gateway_tcl_messageclienthandler::vOnServiceAvailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_bIsServiceAvailable = TRUE;
    if(NULL != m_pBTDeviceManager)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Bluetooth is available,"\
                           "so exposing SMS interfaces"));
        vExportSMSManagerInterface();
    }
}

/*******************************************************************************
 * Function:    vOnServiceUnavailable
 * Description: Callback on CCA service unavailable.
 * Parameters:  none
 * Return:      tVoid
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vOnServiceUnavailable()
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    m_bIsServiceAvailable = FALSE;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Unexposing SMS interfaces as message serice"\
                       "is unavailable"));

    vUnexportSMSManagerInterface();
}

/*******************************************************************************
 * Function:		vSetPhoneNumber
 * Description:		set PhoneNumber
 * Parameters:		tChar
 * Return:			tVoid
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vSetPhoneNumber(const char* phoneNum)
{
    m_PhoneNumber.assign(phoneNum);
}

/*******************************************************************************
 * Function:		chGetPhoneNumber
 * Description:		get PhoneNumber
 * Parameters:		tVoid|
 * Return:			std::string
 ******************************************************************************/
std::string fc_gateway_tcl_messageclienthandler::chGetPhoneNumber()
{
    return m_PhoneNumber;
}

/*******************************************************************************
 * Function:		vSetMessageText
 * Description:		set message text
 * Parameters:		tChar*
 * Return:			tVoid
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vSetMessageText(const char* messageText)
{
    m_MessageText.assign(messageText);
}

/*******************************************************************************
 * Function:		chGetMessageText
 * Description:		get message text
 * Parameters:		tVoid
 * Return:			std::string
 ******************************************************************************/
std::string fc_gateway_tcl_messageclienthandler::chGetMessageText()
{
    return m_MessageText;
}

/*******************************************************************************
 * Function:		fc_gateway_tcl_bluetoothclienthandler
 * Description:		get BTDeviceManager pointer
 * Parameters:		tVoid
 * Return:			fc_gateway_tcl_bluetoothclienthandler*
 ******************************************************************************/
fc_gateway_tcl_bluetoothclienthandler*
fc_gateway_tcl_messageclienthandler::poGetBTDeviceManagerPtr()
{
    return m_pBTDeviceManager;
}

/*******************************************************************************
 * Function:		bIsServiceAvailable
 * Description:		is Service available
 * Parameters:		tVoid
 * Return:			bool
 ******************************************************************************/
bool fc_gateway_tcl_messageclienthandler::bIsServiceAvailable()
{
    return m_bIsServiceAvailable;
}

/*******************************************************************************
 * Function:      sendCreateMessageMStart
 * Description:   Sends a CCA message to CreateMessage
 * Parameters:    tU8 u8CreateMessageHandle, tU8 uFolderType
 * Return:        tVoid
 ******************************************************************************/
tBool fc_gateway_tcl_messageclienthandler::sendCreateMessageMStart(
        tU8 u8CreateMessageHandle,
        most_fi_tcl_MsgMessageHandle oMessageHandle,
        most_fi_tcl_e8_MsgMessageType oMsgType,
        most_fi_tcl_e8_MsgCreateMessageType oCreateMsgType)
{
    tBool bRetVal = FALSE;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler :"),
            DLT_STRING( __FUNCTION__));

    most_msgfi_tclMsgCreateMessageMethodStart oMsgCreateMessageMethodStart;
    //CreateMesageHandle
    oMsgCreateMessageMethodStart.u8CreateMessageHandle = u8CreateMessageHandle;
    //MessageHandle

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("current device Handle :"),
            DLT_INT( m_pBTDeviceManager->getCurrentBTDeviceHandle()));

    oMsgCreateMessageMethodStart.oMessageHandle.u8DeviceHandle =
            m_pBTDeviceManager->getCurrentBTDeviceHandle();

    oMsgCreateMessageMethodStart.oMessageHandle.u32MsgHandleUpper = ZERO;
    oMsgCreateMessageMethodStart.oMessageHandle.u32MsgHandleLower = ZERO;
    //MessageTypes
    oMsgCreateMessageMethodStart.e8MessageType.enType = oMsgType.enType;
    //CreateMessageTypes
    oMsgCreateMessageMethodStart.e8CreateMessageType.enType =
            oCreateMsgType.enType;

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Create Message Handle :  "),
            DLT_INT(oMsgCreateMessageMethodStart.u8CreateMessageHandle));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("MessageType :   "),
            DLT_INT(oMsgCreateMessageMethodStart.e8MessageType.enType));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("CreateMessageType :   "),
            DLT_INT(oMsgCreateMessageMethodStart.e8CreateMessageType.enType));


    fi_tclVisitorMessage oVisitorMsg(oMsgCreateMessageMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg,            // ServiceDataMsg
                     111,                                 // CmdCounter
                     MOST_MSGFI_C_U16_CREATEMESSAGE,      // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode
    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"\
                           "Posting Create Message Method Start Msg"));

        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendCreateMessageMStart():"\
                               "enPostMessage failed"));
            bRetVal = FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler :"\
                               "Posting of CreateMessageStartMethod Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING(__FUNCTION__));
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,DLT_STRING("_poMainAppl NULL Pointer"));
        
        bRetVal = FALSE;
    }
    oMsgCreateMessageMethodStart.vDestroy();
    return bRetVal;
}

/*******************************************************************************
 * Function:	sendCreateMessageMStart
 * Description:	Receives the MethodResult message from Phone service
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tBool
fc_gateway_tcl_messageclienthandler::sendGetMessageMStart(
        uint16_t u16DeviceHandle,
        uint16_t u16MessageID,
        uint16_t u16ListID)
{
    tBool bRetVal = FALSE;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Device Handle = "),
            DLT_INT(u16DeviceHandle));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("MsgHandleUpper = "),
            DLT_INT(u16MessageID));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("MsgHandleLower = "),
            DLT_INT(u16ListID));

    most_msgfi_tclMsgGetMessageMethodStart oMsgGetMessageMethodStart;
    oMsgGetMessageMethodStart.oMessageHandle.u8DeviceHandle = (tU8)u16DeviceHandle;
    oMsgGetMessageMethodStart.oMessageHandle.u32MsgHandleUpper = u16MessageID;
    oMsgGetMessageMethodStart.oMessageHandle.u32MsgHandleLower = u16ListID;
    fi_tclVisitorMessage oVisitorMsg(oMsgGetMessageMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);
    
    vInitServiceData(oVisitorMsg, (tU16)u16MessageID,
                     (tU16) MOST_MSGFI_C_U16_GETMESSAGE,
                     (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
    
    if(NULL != _poMainAppl)
    {
        /* Post message - since the second parameter is true
           we need not explicitly delete the message*/
        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (enResult != AIL_EN_N_NO_ERROR)
        {
            // Error situation:
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendGetMessageMStart(): "));
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("enPostMessage failed for FuncId - "),
                    DLT_UINT32(MOST_MSGFI_C_U16_GETMESSAGE));
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError ="),
                    DLT_UINT32((tU32)enResult));
            
            bRetVal = FALSE;
        }
        else
        {
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));

        bRetVal = FALSE;
    }
    return bRetVal;
}

/*******************************************************************************
 * Function:	vHandleCreateMessageOpMResult
 * Description:	Receives the MethodResult message from Phone service
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleCreateMessageOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));


    if(NULL != poMessage)
    {
        fi_tclVisitorMessage oVisitorMsg(poMessage);
        most_msgfi_tclMsgCreateMessageMethodResult oMsgCreateMsgMethodResult;

        /* Fills the CCA msg data from Phone service into
       oMsgCreateMsgMethodResult */
        if(oVisitorMsg.s32GetData(oMsgCreateMsgMethodResult,
                                  MOST_MSGFI_C_U16_SERVICE_MAJORVERSION) !=
                OSAL_ERROR)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("vHandleCreateMessageOpMResult(): Method result"
                               "update message received for"
                               "'MOST_MSGFI_C_U16_CREATEMESSAGE' (FID:0x245)"));
            if(oMsgCreateMsgMethodResult.u8CreateMessageHandle > 0)
            {
                onCreateMessageMResult(
                            oMsgCreateMsgMethodResult.u8CreateMessageHandle);
            }
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("vHandleCreateMessageOpMResult: Received message"
                               "is invalid!"),DLT_STRING(  __FUNCTION__));
        }
        oMsgCreateMsgMethodResult.vDestroy();
    }
}

/*******************************************************************************
 * Function:	vHandleCreateMessageOpMResult
 * Description:	Invoked on getting CreateMessageResult
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::onCreateMessageMResult(
        tU8 u8CreateMessageHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    if(m_bIsServiceAvailable)
    {
        //Message Subject
        most_fi_tcl_String strSubject;
        //strSubject.bSet("Hello world", most_fi_tcl_String::FI_EN_UTF8);
        strSubject.bSet("");
        //Message address field
        most_fi_tcl_MsgAddressFieldItem oAddressFieldItem;
        oAddressFieldItem.e8AddressFieldType.enType =
                most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_TO;

        oAddressFieldItem.sPhoneNumber.bSet(m_PhoneNumber.c_str());
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("PhoneNumber = "),
                DLT_STRING(oAddressFieldItem.sPhoneNumber.szValue));

        //Invoking PROVIDEMESSAGEHEADER
        sendProvideMessageHeaderMStart(u8CreateMessageHandle,
                                       strSubject,
                                       oAddressFieldItem);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Service Unavailable to invoke"
                           "sendProvideMessageHeaderMStart()"));
    }
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateMessageOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for SendMessage Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleCreateMessageOpMError(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
}

/*******************************************************************************
 * Function:		sendProvideMessageHeaderMStart
 * Description:		Sends a CCA message to ProvideMessageHeader
 * Parameters:		tU8 u8CreateMessageHandle, tU8 uFolderType
 * Return:			tBool
 ******************************************************************************/
tBool fc_gateway_tcl_messageclienthandler::sendProvideMessageHeaderMStart(
        tU8 u8CreateMessageHandle,
        most_fi_tcl_String sSubject,
        most_fi_tcl_MsgAddressFieldItem oAddressFieldItem)
{    
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Create Message Handle : "),
            DLT_INT( u8CreateMessageHandle));

    most_msgfi_tclMsgProvideMessageHeaderMethodStart
            oMsgProvideMessageHeaderMethodStart;

    tBool bRetVal = FALSE;

    //CreateMesageHandle
    oMsgProvideMessageHeaderMethodStart.u8CreateMessageHandle =
            u8CreateMessageHandle;

    //Subject
    oMsgProvideMessageHeaderMethodStart.sSubject = sSubject;
    oMsgProvideMessageHeaderMethodStart.oAddressField.oItems.push_back(
                oAddressFieldItem);

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Create Message Handle : "),
            DLT_INT(oMsgProvideMessageHeaderMethodStart.u8CreateMessageHandle));


    fi_tclVisitorMessage oVisitorMsg(oMsgProvideMessageHeaderMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    vInitServiceData(oVisitorMsg,   // ServiceDataMsg
                     150,           // CmdCounter, (some random number for now).
                     MOST_MSGFI_C_U16_PROVIDEMESSAGEHEADER, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART);   // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler Posting Provide"
                           "Message Header Method Start Msg"));
        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler::"
                               "sendProvideMessageHeaderMStart():"
                               "enPostMessage failed for FuncId - "),
                    DLT_UINT32(MOST_MSGFI_C_U16_PROVIDEMESSAGEHEADER));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_INT(enResult));
            
            bRetVal =  FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler : Posting"
                               "of ProvideMessageHeaderStartMethod Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer" ));
        
        bRetVal =  FALSE;
    }
    oMsgProvideMessageHeaderMethodStart.vDestroy();

    return bRetVal;
}
/*******************************************************************************
 * Function:	vHandleProvideMessageHeaderOpMResult
 * Description:	Receives the MethodResult message from Phone service
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleProvideMessageHeaderOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    if(NULL != poMessage)
    {
        fi_tclVisitorMessage oVisitorMsg(poMessage);
        most_msgfi_tclMsgProvideMessageHeaderMethodResult
                oMsgProvideMsgHeaderMethodResult;

        /* Fills the CCA msg data from Phone service into
            oMsgCreateMsgMethodResult */
        if(oVisitorMsg.s32GetData(oMsgProvideMsgHeaderMethodResult,
                                  MOST_MSGFI_C_U16_SERVICE_MAJORVERSION)
                != OSAL_ERROR)
        {
            onProvideMessageHeaderMResult(
                        oMsgProvideMsgHeaderMethodResult.u8CreateMessageHandle);
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("vHandleProvideMessageHeaderOpMResult:"
                               "Received message is invalid!"));
        }
        oMsgProvideMsgHeaderMethodResult.vDestroy();
    }
}

/*******************************************************************************
 * Function:	onProvideMessageHeaderMResult
 * Description:	Invoked on ProvideMessageHeader result
 * Parameters:	tU8
 * Return:		tVoid
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::onProvideMessageHeaderMResult(
        tU8 u8CreateMessageHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    if(m_bIsServiceAvailable)
    {
        sendProvideMessageBodyMStart(u8CreateMessageHandle);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke"
                           "sendProvideMessageBodyMStart()"));
    }
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleProvideMessageHeaderOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for ProvideMessageHeader Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleProvideMessageHeaderOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
}

/*******************************************************************************
 * Function:		sendProvideMessageBodyMStart
 * Description:		Sends a CCA message to ProvideMessageBody
 * Parameters:		tU8 u8CreateMessageHandle
 * Return:			tVoid
 ******************************************************************************/
tBool fc_gateway_tcl_messageclienthandler::sendProvideMessageBodyMStart(
        tU8 u8CreateMessageHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    tBool bRetVal = FALSE;
    most_msgfi_tclMsgProvideMessageBodyMethodStart
            oMsgProvideMessageBodyMethodStart;

    //CreateMesageHandle
    oMsgProvideMessageBodyMethodStart.u8CreateMessageHandle =
            u8CreateMessageHandle;
    oMsgProvideMessageBodyMethodStart.u16RecordedAudioMessageHandle = 0;
    oMsgProvideMessageBodyMethodStart.u16NumMessageBodyTextElements = 1;

    most_fi_tcl_String temp;
    temp.bSet(m_MessageText.c_str());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("TextMessage = "),
            DLT_STRING(temp.szValue));
    oMsgProvideMessageBodyMethodStart.oMessageBodyText.sItems.push_back(temp);

    fi_tclVisitorMessage oVisitorMsg(oMsgProvideMessageBodyMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    vInitServiceData(oVisitorMsg,            // ServiceDataMsg
                     110,                    		     // CmdCounter
                     MOST_MSGFI_C_U16_PROVIDEMESSAGEBODY, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                           "Posting Provide Message Header Method Start Msg"));

        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("sendProvideMessageBodyMStart(): enPostMessage"
                               "failed for FuncId = "),
                    DLT_UINT32(MOST_MSGFI_C_U16_PROVIDEMESSAGEBODY));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_INT(enResult));

            bRetVal =  FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler : Posting"
                               "of ProvideMessageBodyStartMethod Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING( "_poMainAppl NULL Pointer"));
        bRetVal = FALSE;
    }
    oMsgProvideMessageBodyMethodStart.vDestroy();
    return bRetVal;
}

/*******************************************************************************
 * Function:	vHandleProvideMessageBodyOpMResult
 * Description:	Receives the MethodResult message from Phone service
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleProvideMessageBodyOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    most_msgfi_tclMsgProvideMessageBodyMethodResult
            oMsgProvideMsgBodyMethodResult;

    if(NULL != poMessage)
    {
        fi_tclVisitorMessage oVisitorMsg(poMessage);

        /* Fills the CCA msg data from Phone service into
            oMsgCreateMsgMethodResult */
        if(oVisitorMsg.s32GetData(
                    oMsgProvideMsgBodyMethodResult,
                    MOST_MSGFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("vHandleProvideMessageBodyOpMResult():"
                               "Method result update message received for"
                               "MOST_MSGFI_C_U16_PROVIDEMESSAGEBODY FID: 0x237"));
            onProvideMessageBodyMResult(
                        oMsgProvideMsgBodyMethodResult.u8CreateMessageHandle);
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("vHandleProvideMessageBodyOpMResult:"
                               "Received message is invalid! : "),
                    DLT_STRING(  __FUNCTION__));
        }
    }
    oMsgProvideMsgBodyMethodResult.vDestroy();
}

/*******************************************************************************
 * Function:	onProvideMessageBodyMResult
 * Description:	Invoked on Message body result
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::onProvideMessageBodyMResult(
        tU8 u8CreateMessageHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    if(m_bIsServiceAvailable)
    {
        //FolderType
        most_fi_tcl_e8_MsgFolderType oFolderType;
        oFolderType.enType =
                most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_SENT;

        //Invoking sendMessage
        SendMessageMStart(u8CreateMessageHandle, oFolderType);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke SendMessageMStart"));
    }
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleProvideMessageBodyOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for ProvideMessageHeader Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleProvideMessageBodyOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
}

/*******************************************************************************
 * Function:		SendMessageMStart
 * Description:		Sends a CCA message to SendMessage
 * Parameters:		tU8 u8CreateMessageHandle, tU8 uFolderType
 * Return:			tVoid
 ******************************************************************************/
tBool fc_gateway_tcl_messageclienthandler::SendMessageMStart(
        tU8 u8CreateMessageHandle,
        most_fi_tcl_e8_MsgFolderType e8FolderType)
{   
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Create Message Handle : "),
            DLT_INT(u8CreateMessageHandle),
            DLT_STRING("FolderType : "),
            DLT_INT(e8FolderType.enType));

    tBool bRetVal = FALSE;
    most_msgfi_tclMsgSendMessageMethodStart oMsgSendMessageMethodStart;

    oMsgSendMessageMethodStart.u8CreateMessageHandle = u8CreateMessageHandle;
    oMsgSendMessageMethodStart.e8FolderType.enType = e8FolderType.enType;

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Create Message Handle :"),
            DLT_INT( oMsgSendMessageMethodStart.u8CreateMessageHandle),
            DLT_STRING("FolderType : "),
            DLT_INT(oMsgSendMessageMethodStart.e8FolderType.enType));
    
    fi_tclVisitorMessage oVisitorMsg(oMsgSendMessageMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg,     // ServiceDataMsg
                     160,                          // CmdCounter
                     MOST_MSGFI_C_U16_SENDMESSAGE, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART); // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                           "Posting Send Message Method Start Msg"));

        ail_tenCommunicationError
                enResult = _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("SendMessageMStart(): enPostMessage failed"
                               "for FuncId - "),
                    DLT_UINT(MOST_MSGFI_C_U16_SENDMESSAGE));

            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_UINT((tU32)enResult));

            bRetVal = FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                               "Posting of SendMessageStartMethod Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));
        
        bRetVal = FALSE;
    }
    oMsgSendMessageMethodStart.vDestroy();
    
    return bRetVal;
}

/*******************************************************************************
 * Function:	vSendMessageResult
 * Description:	Receives the MethodResult message from Phone service
 * Parameters:	amt_tclServiceData *
 * Return:		void
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleSendMessageOpMResult(
        amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    if(NULL != poMessage)
    {
        //coverts amt_tclServiceData to fi_tclVisitorMessage
        fi_tclVisitorMessage oVisitorMsg(poMessage);
        most_msgfi_tclMsgSendMessageMethodResult oMsgSendMsgMethodResult;

        /* Fills the CCA msg data from Phone service into
        oMsgSendMsgMethodResult */
        tS32 s32Result = oVisitorMsg.s32GetData(
                    oMsgSendMsgMethodResult,
                    MOST_MSGFI_C_U16_SERVICE_MAJORVERSION );
        if(OSAL_ERROR != s32Result)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("vHandleSendMessageOpMResult(): Method result"
                               "update message received for"
                               "MOST_MSGFI_C_U16_SENDMESSAGE (FID: 0x234)!"));

            DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                    DLT_STRING("send message result status: "),
                    DLT_INT(
                        oMsgSendMsgMethodResult.e8SentMessageStatus.enType));

        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("vHandleSendMessageOpMResult: "
                               "Received message is invalid! :"),
                    DLT_STRING(  __FUNCTION__));
        }
        oMsgSendMsgMethodResult.vDestroy();
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("-vHandleSendMessageOpMResult: poMessage is NULL"));
    }
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleSendMessageOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for SendMessage Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleSendMessageOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCellSignalStrengthOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CellSignalStrengthError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleMessageNotificationOpStatus(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_msgfi_tclMsgMessageNotificationStatus oMsgNotificationStatus;

    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgNotificationStatus,
                MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler:"
                           "extracted message notification"));


        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("Device Handle = "),
                DLT_INT(oMsgNotificationStatus.oMessageHandle.u8DeviceHandle));

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("MsgHandleUpper = "),
                DLT_INT(
                    oMsgNotificationStatus.oMessageHandle.u32MsgHandleUpper));

        DLT_LOG(AGW_Phone,
                DLT_LOG_INFO,DLT_STRING("MsgHandleLower = "),
                DLT_INT(
                    oMsgNotificationStatus.oMessageHandle.u32MsgHandleLower));

        bool bRet = RequestSliceMessageListMStart(
                    tU16(oMsgNotificationStatus.oMessageHandle.u32MsgHandleLower),//list
                    0, //window start
                    1, //window size
                    tU16(oMsgNotificationStatus.e8NotificationType.enType));//cc
        if(bRet)
        {
            m_bIsMessageNotification = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : "));
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("MessageNotification Error = "),DLT_INT(s32Result));

    }
    oMsgNotificationStatus.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleMessageNotificationOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CellSignalStrengthError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleMessageNotificationOpError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));
    (tVoid)poMessage;
}         

std::string
fc_gateway_tcl_messageclienthandler::ConvertCCADateTimeToString(
        most_fi_tcl_MsgMessageDateTime	l_most_fi_tcl_MsgMessageDateTime)
{

    std::string sTimeStamp;

    std::string strHour =
            l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sHours.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Time:Hours = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sHours.szValue));



    std::string strMinutes =
            l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sMinutes.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Time:Minutes = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sMinutes.szValue));


    std::string strSeconds =
            l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sSeconds.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Time:Seconds = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageTime.sSeconds.szValue));


    std::string strYear =
            l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrYear.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Date:Year = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrYear.szValue));



    std::string strMonth =
            l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrMonth.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Date:Month = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrMonth.szValue));


    std::string strDay =
            l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrDay.szValue;
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: Date:Day = "),
            DLT_STRING(
                l_most_fi_tcl_MsgMessageDateTime.oMessageDate.sCldrDay.szValue));



    sTimeStamp = strYear + "-" + strMonth + "-" + strDay + "T"
            + strHour + ":" + strMinutes + ":" + strSeconds;

    return sTimeStamp;

}
/*******************************************************************************
*
* FUNCTION     :  bConvertCCADSToGateway(..)
*
* DESCRIPTION  :  Converts the CCA specific data strucures to Gateway DS.
*
* PARAMETER    :  l_most_msgfi_tclMsgGetMessageMethodResult
*
* RETURNVALUE  :  SMSData.
*
*******************************************************************************/

tVoid fc_gateway_tcl_messageclienthandler::vConvertCCADSToGateway(
        most_msgfi_tclMsgGetMessageMethodResult&
        l_most_msgfi_tclMsgGetMessageMethodResult,
        SMSData& l_SMSData)
{
    l_SMSData.bRead = TRUE;

    //copy the string message from CCA to the Gateway
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler: ShortMessage = "),
            DLT_STRING(
                l_most_msgfi_tclMsgGetMessageMethodResult.oMessageDetailsResult.sShortMessage.szValue));

    std::string strShortMsg =
            l_most_msgfi_tclMsgGetMessageMethodResult.oMessageDetailsResult.sShortMessage.szValue;

    l_SMSData.poMessage =
            (char*)malloc((strShortMsg.length()+1) * sizeof(char));

    memset(l_SMSData.poMessage, 0, strShortMsg.length()+1);
    strncpy(l_SMSData.poMessage, strShortMsg.c_str(), strShortMsg.length());

    //copy the time from the CCA to Gateway
    std::string timestamp = ConvertCCADateTimeToString(
                l_most_msgfi_tclMsgGetMessageMethodResult.
                oMessageDetailsResult.oMessageDateTime);

    l_SMSData.poTimeStamp =
            (char*)malloc((timestamp.length()+1) * sizeof(char));
    memset(l_SMSData.poTimeStamp, 0, timestamp.length() + 1);
    strncpy(l_SMSData.poTimeStamp, timestamp.c_str(), timestamp.length());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("vConvertCCADSToGateway: Message List Size = "),
            DLT_UINT(
                static_cast<unsigned int>(l_most_msgfi_tclMsgGetMessageMethodResult.oMessageDetailsResult.oAddressField.oItems.size())));

    for (std::vector<most_fi_tcl_MsgAddressFieldItem>::iterator itr =
         l_most_msgfi_tclMsgGetMessageMethodResult.oMessageDetailsResult.oAddressField.oItems.begin();
         itr !=
         l_most_msgfi_tclMsgGetMessageMethodResult.oMessageDetailsResult.oAddressField.oItems.end();
         ++itr)
    {
        if (itr->e8AddressFieldType.enType ==
                most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_FROM)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("from phone number: "),
                    DLT_STRING( itr->sPhoneNumber.szValue));

            std::string strFromPhoneNumber = itr->sPhoneNumber.szValue;
            l_SMSData.poFromPhoneNumber =
                    (char*)malloc((strFromPhoneNumber.length()+1) *
                                  sizeof(char));

            memset(l_SMSData.poFromPhoneNumber, 0,
                   strFromPhoneNumber.length() + 1);

            strncpy(l_SMSData.poFromPhoneNumber, strFromPhoneNumber.c_str(),
                    strFromPhoneNumber.length());
        }
        else if (itr->e8AddressFieldType.enType ==
                 most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_TO)
        {
            DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING( "To phone number: "),
                    DLT_STRING( itr->sPhoneNumber.szValue));

            std::string strToPhoneNumber = itr->sPhoneNumber.szValue;

            l_SMSData.poToPhoneNumber =
                    (char*)malloc((strToPhoneNumber.length()+1) * sizeof(char));
            memset(l_SMSData.poToPhoneNumber, 0, strToPhoneNumber.length() + 1);
            strncpy(l_SMSData.poToPhoneNumber, strToPhoneNumber.c_str(),
                    strToPhoneNumber.length());
        }
        else if (itr->e8AddressFieldType.enType ==
                 most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_CC)
        {
            //don't do anything here.
        }
        else
        {
            DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                    DLT_STRING("unkown address filed type  cannot come here."));
        }
    }

    //Following not supported from component.
    l_SMSData.poDeliveryTimeStamp = NULL;
    l_SMSData.eSMSState = AP_TELEPHONY_SMS_STATE_UNKOWN;
    l_SMSData.eDeliveryState = AP_TELEPHONY_SMS_DELIVERY_STATUS_NOTAPPLICABLE;
}


/*******************************************************************************
 *
 * FUNCTION     :  vHandleGetMessageOpMResult(..)
 *
 * DESCRIPTION  :  This is a handler function for CCA GetMessage from messaging.
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleGetMessageOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_msgfi_tclMsgGetMessageMethodResult oMsgGetMessageMethodResult;

    /* Fills the CCA msg data from Messaging service
       into oMsgGetMessageMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgGetMessageMethodResult,
                MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        SMSData l_SMSData;
        vInitializeSMSData(&l_SMSData);

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING( "get message command counter: "),
                DLT_INT( poMessage->u16GetCmdCounter()));


        vConvertCCADSToGateway(oMsgGetMessageMethodResult, l_SMSData);
        l_SMSData.u16MessageHandle = poMessage->u16GetCmdCounter();
        vReadMessageResult(&l_SMSData);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                           "vHandleGetMessageOpMResult Get Message Error = "),
                DLT_INT(s32Result));
    }

    oMsgGetMessageMethodResult.vDestroy();
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleCellSignalStrengthOpError(..)
 *
 * DESCRIPTION  :  This is a handler function for CellSignalStrengthError
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vHandleGetMessageOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));
    vReadMessageError(AP_TELEPHONY_ERROR_INTERNAL,
                      "Error while calling Read message");
    (tVoid)poMessage;
}

/******************************************************************************
 * Function:      CreateMessageListMStart
 * Description:   Sends a CCA message to create message list
 * Parameters:    tU8 u8CreateMessageHandle, tU8 uFolderType
 * Return:        tVoid
 *****************************************************************************/
tBool fc_gateway_tcl_messageclienthandler::CreateMessageListMStart(
        tU8 u8DeviceHandle,
        most_fi_tcl_e8_MsgFolderType e8FolderType)
{
    DLT_LOG(AGW_Phone, DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));
    DLT_LOG(AGW_Phone, DLT_LOG_INFO, DLT_STRING("Device Handle : "),
            DLT_INT(u8DeviceHandle)
            , DLT_STRING("FolderType : "),
            DLT_INT(e8FolderType.enType));

    tBool bRetVal = FALSE;
    most_msgfi_tclMsgCreateMessageListMethodStart
            oMsgCreateMessageListMethodStart;

    oMsgCreateMessageListMethodStart.u8DeviceHandle = u8DeviceHandle;
    oMsgCreateMessageListMethodStart.e8FolderType.enType = e8FolderType.enType;
    oMsgCreateMessageListMethodStart.e8MessageListFilterType.enType =
            most_fi_tcl_e8_MsgMessageListFilterType::FI_EN_E8MSG_LIST_FILTER_CURRENT_MAP_SESSION;
	
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Create Message Handle :"),
            DLT_INT(oMsgCreateMessageListMethodStart.u8DeviceHandle)
            , DLT_STRING("FolderType : "),
            DLT_INT(oMsgCreateMessageListMethodStart.e8FolderType.enType));

    fi_tclVisitorMessage oVisitorMsg(oMsgCreateMessageListMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg,                            // ServiceDataMsg
                     170,                                    // CmdCounter
                     MOST_MSGFI_C_U16_CREATEMESSAGELIST,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART);    // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                           "Posting CreateMessageList Start Msg"));

        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone ,DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                               "Posting of SendMessageStartMethod failed"));
            bRetVal = FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler :"\
                               "Posting of SendMessageStartMethod Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));

        bRetVal = FALSE;
    }
    oMsgCreateMessageListMethodStart.vDestroy();

    return bRetVal;
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateMessageListOpMResult(..)
 *
 * DESCRIPTION  :  This is a handler function for Create Message List
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleCreateMessageListOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_msgfi_tclMsgCreateMessageListMethodResult
            oMsgCreateMessageListMethodResult;

    /* Fills the CCA msg data to oMsgCreateMessageListMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgCreateMessageListMethodResult,
                MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING("Messages List Handle ="),
                DLT_INT(oMsgCreateMessageListMethodResult.u16ListHandle));

        //Send the result to gateway

        vGetMessagesListResult(oMsgCreateMessageListMethodResult.u16ListHandle,
                               oMsgCreateMessageListMethodResult.u16ListLength);
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                DLT_STRING("vHandleCreateMessageListOpMResult : Error Message"),
                DLT_INT(s32Result));
        char sError[] = "Prepare message list failed";
        vPrepareGetMessagesList_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);

    }
    oMsgCreateMessageListMethodResult.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleCreateMessageListOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for Create message opcode Error
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleCreateMessageListOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    char sError[] =  "Prepare message list failed";
    vPrepareGetMessagesList_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);
}

/*******************************************************************************
 * Function:      RequestSliceMessageListMStart
 * Description:   Sends a CCA message to request slice message list start
 * Parameters:    tU16 u16ListHandle, tU32 u32WindowStart, tU32 u32WindowSize
 * Return:        tBool
 ******************************************************************************/
tBool
fc_gateway_tcl_messageclienthandler::RequestSliceMessageListMStart(
        tU16 u16ListHandle, tU32 u32WindowStart,
        tU32 u32WindowSize, tU16 u16CmdCntr)
{
    DLT_LOG(AGW_Phone, DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone, DLT_LOG_INFO, DLT_STRING("List Handle : "),
            DLT_INT(u16ListHandle),
            DLT_STRING("WindowStart : "), DLT_INT(u32WindowStart),
            DLT_STRING("WindowSize : "), DLT_INT(u32WindowSize));

    tBool bRetVal = FALSE;
    most_msgfi_tclMsgRequestSliceMessageListMethodStart
            oMsgRequestSliceMessageListMethodStart;

    oMsgRequestSliceMessageListMethodStart.u16ListHandle = u16ListHandle;
    oMsgRequestSliceMessageListMethodStart.u32WindowStart = u32WindowStart;
    oMsgRequestSliceMessageListMethodStart.u32WindowSize = u32WindowSize;

    fi_tclVisitorMessage oVisitorMsg(oMsgRequestSliceMessageListMethodStart,
                                     MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    /* Sets the CCA message header fields */
    vInitServiceData(oVisitorMsg,                              // ServiceDataMsg
                     u16CmdCntr,                               // CmdCounter
                     MOST_MSGFI_C_U16_REQUESTSLICEMESSAGELIST, // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART);      // Opcode

    if(NULL != _poMainAppl)
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : Posting"
                           "RequestSliceMessageList MethodStart Msg"));

        ail_tenCommunicationError enResult =
                _poMainAppl->enPostMessage(&oVisitorMsg, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                    DLT_STRING("RequestSliceMessageListMStart :"
                               "enPostMessage failed for FuncId - "),
                    DLT_UINT(MOST_MSGFI_C_U16_REQUESTSLICEMESSAGELIST));

            DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                    DLT_STRING("ail_tenCommunicationError = "),
                    DLT_UINT((tU32)enResult));

            bRetVal = FALSE;
        }
        else
        {
            DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                    DLT_STRING("fc_gateway_tcl_messageclienthandler :"
                               "Posting of RequestSliceMessageList Success"));
            bRetVal = TRUE;
        }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
                DLT_STRING( __FUNCTION__),
                DLT_STRING("_poMainAppl NULL Pointer"));
        bRetVal = FALSE;
    }
    oMsgRequestSliceMessageListMethodStart.vDestroy();

    return bRetVal;
}
/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestSliceMessageListOpMResult(..)
 *
 * DESCRIPTION  :  This is a handler function for RequestSliceMessageList
 *                 opcode method result
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleRequestSliceMessageListOpMResult(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone, DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_msgfi_tclMsgRequestSliceMessageListMethodResult
            oMsgRequestSliceMessageListMethodResult;

    /* Fills the CCA msg data to oMsgCreateMessageListMethodResult */
    tS32 s32Result = oVisitorMsg.s32GetData(
                oMsgRequestSliceMessageListMethodResult,
                MOST_MSGFI_C_U16_SERVICE_MAJORVERSION);

    if(OSAL_ERROR != s32Result)
    {
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                DLT_STRING("vHandleRequestSliceMessageListOpMResult"));

        most_fi_tcl_MsgMessageListSliceResult
                l_oMessageListSliceResult =
                oMsgRequestSliceMessageListMethodResult.oMessageListSliceResult;

        std::vector<most_fi_tcl_MsgMessageListSliceResultItem>::iterator
                itMsgMessageListSliceList =
                l_oMessageListSliceResult.oItems.begin();
        
        int i_arrlen = (int)l_oMessageListSliceResult.oItems.size();
        DLT_LOG(AGW_Phone, DLT_LOG_INFO,DLT_STRING(
                    "vHandleRequestSliceMessageListOpMResult : i_arrlen = "),
                DLT_INT(i_arrlen));

        if(i_arrlen <= 0)
        {
            if(m_bIsMessageNotification)
            {
                m_bIsMessageNotification = FALSE;
            }
            else
            {
                char sError[] = "Get MessageList in slice failed";
                vGetMessagesListSlice_Error(AP_TELEPHONY_ERROR_INTERNAL,
                                            sError);
            }
            oMsgRequestSliceMessageListMethodResult.vDestroy();
            return;
        }

        SMSData* l_SMSDataItems;
        l_SMSDataItems = (SMSData*) malloc( i_arrlen * sizeof(SMSData));
        memset(l_SMSDataItems, 0, i_arrlen * sizeof(SMSData));

        std::string strPhoneNumber;
        int iCount = 0;
        for(; itMsgMessageListSliceList
            != l_oMessageListSliceResult.oItems.end();
            itMsgMessageListSliceList++)
        {
            DLT_LOG(AGW_Phone, DLT_LOG_INFO,
                    DLT_STRING("Short Message = "),
                    DLT_STRING(
                        itMsgMessageListSliceList->sShortMessage.szValue));
            DLT_LOG(AGW_Phone,
                    DLT_LOG_INFO,
                    DLT_STRING("Phone Number = "),
                    DLT_STRING(
                        itMsgMessageListSliceList->sPhoneNumber.szValue));

            vInitializeSMSData(&l_SMSDataItems[iCount]);

            l_SMSDataItems[iCount].u16DeviceHandle =
                    itMsgMessageListSliceList->oMessageHandle.u8DeviceHandle;
            l_SMSDataItems[iCount].u16MessageHandle =
                    static_cast<uint16_t>(itMsgMessageListSliceList->oMessageHandle.u32MsgHandleUpper);
            l_SMSDataItems[iCount].u16ListHandle =
                    static_cast<uint16_t>(itMsgMessageListSliceList->oMessageHandle.u32MsgHandleLower);

            std::string sTimestamp =
                    ConvertCCADateTimeToString(
                        itMsgMessageListSliceList->oMessageDateTime);

            l_SMSDataItems[iCount].poTimeStamp =
                    (char*)malloc((sTimestamp.length()+1) * sizeof(char));
            memset(l_SMSDataItems[iCount].poTimeStamp, 0,
                   sTimestamp.length() + 1);
            strncpy(l_SMSDataItems[iCount].poTimeStamp,
                    sTimestamp.c_str(),
                    sTimestamp.length());

            l_SMSDataItems[iCount].bRead =
                    itMsgMessageListSliceList->bReadStatusFlag;

            std::string strShortMsg =
                    itMsgMessageListSliceList->sShortMessage.szValue;
            l_SMSDataItems[iCount].poMessage =
                    (char*)malloc((strShortMsg.length()+1) * sizeof(char));
            memset(l_SMSDataItems[iCount].poMessage,
                   0,
                   strShortMsg.length()+1);
            strncpy(l_SMSDataItems[iCount].poMessage,
                    strShortMsg.c_str(),
                    strShortMsg.length());

            l_SMSDataItems[iCount].poDeliveryTimeStamp =
                    (char*)malloc(strlen("Not supported") + 1);
            memset(l_SMSDataItems[iCount].poDeliveryTimeStamp, 0,
                   strlen("Not supported") + 1);
            strcpy(l_SMSDataItems[iCount].poDeliveryTimeStamp,
                   "Not supported");

            if(!m_bIsMessageNotification)
            {
                l_SMSDataItems[iCount].eSMSState =
                        AP_TELEPHONY_SMS_STATE_RECEIVED;

                std::string strFromPhoneNumber =
                        itMsgMessageListSliceList->sPhoneNumber.szValue;

                l_SMSDataItems[iCount].poFromPhoneNumber =
                        (char*)malloc((strFromPhoneNumber.length()+1)
                                      * sizeof(char));
                memset(l_SMSDataItems[iCount].poFromPhoneNumber,
                       0,
                       strFromPhoneNumber.length() + 1);
                strncpy(l_SMSDataItems[iCount].poFromPhoneNumber,
                        strFromPhoneNumber.c_str(),
                        strFromPhoneNumber.length());
            }
            else
            {
                strPhoneNumber =
                        itMsgMessageListSliceList->sPhoneNumber.szValue;
                break;
            }
            iCount++;
        }

        if(!m_bIsMessageNotification)
        {
            vGetMessagesListSliceResult(l_SMSDataItems, iCount);
        }
        else
        {
            m_bIsMessageNotification = FALSE;
            most_fi_tcl_e8_MsgNotificationType oNotificationType;

            oNotificationType.enType =
                    most_fi_tcl_e8_MsgNotificationType::tenType(
                        poMessage->u16GetCmdCounter());
            
			SMSData l_SMSData = l_SMSDataItems[0];
			
            vTriggerSMSSignal(l_SMSData,
                              strPhoneNumber,
                              oNotificationType);
			int iItr = 0;
            while (iItr <= iCount)
            {
			    vCleanSMSData(&l_SMSDataItems[iItr]);
                iItr++;
            }
			
			free(l_SMSDataItems);
	    }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                DLT_STRING("vHandleCreateMessageListOpMResult:"
                           "Error Message = "),DLT_INT(s32Result));
        if(m_bIsMessageNotification)
        {
            m_bIsMessageNotification = FALSE;
        }
        else
        {
            char sError[] = "Get MessageList in slice failed";
            vGetMessagesListSlice_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);
        }
    }
    oMsgRequestSliceMessageListMethodResult.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  vTriggerSMSSignal(..)
 *
 * DESCRIPTION  :  This is a handler function for triggering SMS signal.
 *
 * PARAMETER    :  IN:SMSData - SMS data, PhoneNumber,
                   most_fi_tcl_e8_MsgNotificationType
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid fc_gateway_tcl_messageclienthandler::vTriggerSMSSignal(
        SMSData arg_SMSData,
        std::string strPhoneNumber,
        most_fi_tcl_e8_MsgNotificationType oNotificationType)
{
    DLT_LOG(AGW_Phone, DLT_LOG_INFO, DLT_STRING("vTriggerSMSSignal"));
    switch (oNotificationType.enType)
    {
    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_NEW_MSG:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kReceived"));
        arg_SMSData.eSMSState = AP_TELEPHONY_SMS_STATE_RECEIVED;

        arg_SMSData.poFromPhoneNumber =
                (char*)malloc((strPhoneNumber.length()+1) * sizeof(char));
        memset(arg_SMSData.poFromPhoneNumber, 0,
               strPhoneNumber.length() + 1);
        strncpy(arg_SMSData.poFromPhoneNumber,
                strPhoneNumber.c_str(),
                strPhoneNumber.length());
        vTriggerOnSMSReceivedSignal(arg_SMSData);
        break;

    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_SEND_SUCCESS:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kSent"));
        arg_SMSData.eSMSState = AP_TELEPHONY_SMS_STATE_SENT;

        arg_SMSData.poToPhoneNumber =
                (char*)malloc((strPhoneNumber.length()+1) * sizeof(char));
        memset(arg_SMSData.poToPhoneNumber, 0,
               strPhoneNumber.length() + 1);
        strncpy(arg_SMSData.poToPhoneNumber,
                strPhoneNumber.c_str(),
                strPhoneNumber.length());
        vTriggerOnSentSuccessSignal(arg_SMSData);
        break;

    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_DELIVERY_SUCCESS:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kDeliverySuccess"));
        arg_SMSData.eSMSState = AP_TELEPHONY_SMS_STATE_DELIVERED;

        arg_SMSData.poToPhoneNumber =
                (char*)malloc((strPhoneNumber.length()+1) * sizeof(char));
        memset(arg_SMSData.poToPhoneNumber, 0, strPhoneNumber.length() + 1);
        strncpy(arg_SMSData.poToPhoneNumber,
                strPhoneNumber.c_str(),
                strPhoneNumber.length());
        vTriggerOnDeliverySuccessSignal(arg_SMSData);
        break;

    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_SEND_FAILURE:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kSentFailure"));
        break;

    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_DELIVERY_FAILURE:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kDeliveryFailure"));
        arg_SMSData.eSMSState = AP_TELEPHONY_SMS_STATE_FAILED;

        arg_SMSData.poToPhoneNumber =
                (char*)malloc((strPhoneNumber.length()+1) * sizeof(char));
        memset(arg_SMSData.poToPhoneNumber, 0,
               strPhoneNumber.length() + 1);
        strncpy(arg_SMSData.poToPhoneNumber,
                strPhoneNumber.c_str(),
                strPhoneNumber.length());
        vTriggerOnDeliveryFailureSignal(arg_SMSData);
        break;

    case most_fi_tcl_e8_MsgNotificationType::FI_EN_E8NOTIFY_MSG_DELETED:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("kUnkown"));
        break;

    default:
        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("orphan enum notification type"));
        break;
    }
}

/*******************************************************************************
 *
 * FUNCTION     :  vHandleRequestSliceMessageListOpMError(..)
 *
 * DESCRIPTION  :  This is a handler function for RequestSliceMessageList Error.
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ******************************************************************************/
tVoid
fc_gateway_tcl_messageclienthandler::vHandleRequestSliceMessageListOpMError(
        amt_tclServiceData* poMessage)
{
    DLT_LOG(AGW_Phone, DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    (tVoid)poMessage;
    if(m_bIsMessageNotification)
    {
        m_bIsMessageNotification = FALSE;
    }
    else
    {
        char sError[] = "Get MessageList in slice failed";
        vGetMessagesListSlice_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);
    }
    
}

// C Functions

/******************************************************************************
 * Function:      vCreateMessageMethod
 * Description:   Wrapper function to call CreateMessage CCA method
 * Parameters:    const char *poPhoneNumber, const char *poTextMessage
 * Return:        tVoid
 *****************************************************************************/
void vCreateMessageMethod(const char *poPhoneNumber, const char *poTextMessage)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fc_gateway_tcl_messageclienthandler* poMessageObj =
            fc_gateway_tcl_messageclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Service Availablity status : "),
            DLT_INT( poMessageObj->bIsServiceAvailable()));

    if(poMessageObj->bIsServiceAvailable())
    {
        tU8 u8CreateMessageHandle = MESSAGE_HANDLE; /* creating a fake value.*/
        most_fi_tcl_MsgMessageHandle oMsgHandle;
        most_fi_tcl_e8_MsgMessageType oMsgType;
        most_fi_tcl_e8_MsgCreateMessageType oCreateMsgType;

        oMsgHandle.u8DeviceHandle =
                poMessageObj->poGetBTDeviceManagerPtr()->
                getCurrentBTDeviceHandle();

        oMsgHandle.u32MsgHandleUpper = 0;
        oMsgHandle.u32MsgHandleLower = 0;

        DLT_LOG(AGW_Phone,DLT_LOG_INFO,
                DLT_STRING("fc_gateway_tcl_messageclienthandler :"\
                           "device handle "),
                DLT_INT( oMsgHandle.u8DeviceHandle));

        //MessageType
        oMsgType.enType = most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_SMS;
        //CreateMessageType
        oCreateMsgType.enType =
                most_fi_tcl_e8_MsgCreateMessageType::FI_EN_E8NEW_MESSAGE;

        poMessageObj->vSetPhoneNumber(poPhoneNumber);
        poMessageObj->vSetMessageText(poTextMessage);

        poMessageObj->sendCreateMessageMStart(u8CreateMessageHandle,
                                              oMsgHandle,
                                              oMsgType,
                                              oCreateMsgType);
    }
    else
    {
        DLT_LOG(AGW_Phone,DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke"\
                           "sendProvideMessageBodyMStart()"));
    }
}

/******************************************************************************
* Function:    vPrepareMessagesList
* Description: Wrapper function to call Prepare message list CCA method.
* Parameters:  unsigned short iDeviceHandle
* Return:      void
******************************************************************************/
void vPrepareMessagesList(unsigned short iDeviceHandle)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fc_gateway_tcl_messageclienthandler* poMessageObj =
            fc_gateway_tcl_messageclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Service Availablity status : "),
            DLT_INT( poMessageObj->bIsServiceAvailable()));

    if(poMessageObj->bIsServiceAvailable())
    {
        //FolderType
        most_fi_tcl_e8_MsgFolderType oFolderType;
        oFolderType.enType =
                most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_INBOX;
        
        bool bRet = poMessageObj->CreateMessageListMStart((tU8)iDeviceHandle,
                                                          oFolderType);
        if(!bRet)
        {
            char sError[] = "Error while calling CreateMessageListMStart";
            vPrepareGetMessagesList_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);
        }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke"\
                           "CreateMessageListMStart()"));

        vPrepareGetMessagesList_Error(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                      "Service Unavailable");
    }
}

/******************************************************************************
* Function:    vGetMessagesListSlice
* Description: Wrapper function to call get message list in slice CCA method.
* Parameters:  unsigned int iHandle, unsigned int iWindowStart,
               unsigned int iWindowSize
* Return:      void
******************************************************************************/
void vGetMessagesListSlice(unsigned short iHandle,
                           unsigned int iWindowStart,
                           unsigned short iWindowSize)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING(" List Handle:"),
            DLT_UINT16(iHandle));

    fc_gateway_tcl_messageclienthandler*
            poMessageObj = fc_gateway_tcl_messageclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,DLT_STRING("Service Availablity status : "),
            DLT_INT( poMessageObj->bIsServiceAvailable()));
    if(poMessageObj->bIsServiceAvailable())
    {
        bool bRet = poMessageObj->RequestSliceMessageListMStart(iHandle,
                                                                iWindowStart,
                                                                iWindowSize,
                                                                0);
        if(!bRet)
        {
            char sError[] = "Error while calling RequestSliceMessageListMStart";
            vGetMessagesListSlice_Error(AP_TELEPHONY_ERROR_INTERNAL, sError);
        }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke"\
                           "RequestSliceMessageListMStart()"));

        vGetMessagesListSlice_Error(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                                    "Service Unavailable");
    }
}

/******************************************************************************
* Function:    vReadMessage
* Description: Wrapper function to call get message CCA method.
* Parameters:  uint16_t
* Return:      void
******************************************************************************/
void vReadMessage(uint16_t u16DeviceHandle,
                  uint16_t u16MessageID,
                  uint16_t u16ListID)
{
    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("fc_gateway_tcl_messageclienthandler : "),
            DLT_STRING( __FUNCTION__));

    fc_gateway_tcl_messageclienthandler*
            poMessageObj = fc_gateway_tcl_messageclienthandler::getInstance(
                procgenericgateway_tclMainApp::poGetInstance());

    DLT_LOG(AGW_Phone,DLT_LOG_INFO,
            DLT_STRING("Service Availablity status : "),
            DLT_INT( poMessageObj->bIsServiceAvailable()));

    if(poMessageObj->bIsServiceAvailable())
    {
        bool bRet = poMessageObj->sendGetMessageMStart(u16DeviceHandle,
                                                       u16MessageID,
                                                       u16ListID);
        if(!bRet)
        {
            char sError[] = "Error while calling Read message";
            vReadMessageError(AP_TELEPHONY_ERROR_INTERNAL, sError);
        }
    }
    else
    {
        DLT_LOG(AGW_Phone, DLT_LOG_ERROR,
                DLT_STRING("Service Unavailable to invoke"
                           "sendGetMessageMStart()"));
        vReadMessageError(AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
                          "Service Unavailable");
    }
}

#ifdef __cplusplus

/******************************************************************************
* Function:    get_MessageClientHandlerInstance
* Description: function to get message instance
* Parameters:  void
* Return:      fc_gateway_tcl_messageclienthandler pointer
******************************************************************************/
fc_gateway_tcl_messageclienthandler*
get_MessageClientHandlerInstance(procgenericgateway_tclMainApp* poMainAppl)
{
    fc_gateway_tcl_messageclienthandler* poMessageObj  =
            fc_gateway_tcl_messageclienthandler::getInstance(poMainAppl);

    return poMessageObj;
}

#endif

#endif//VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC