#ifndef _PHONE_DATA_HANDLER_H
#define _PHONE_DATA_HANDLER_H

/* not needed
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <stdbool.h>
#include <string.h>
#include <gio/gio.h>
*/

#include <vector> // For using vector data type
#include <algorithm>
#include <string>

#include "ap-telephony-manager-enums.h"

class tclCallHistoryItem
{
private:
    unsigned int m_uContactHandle;
    std::string m_sPhoneNum;
    std::string m_sStartTime;
    ApTelephonyCallDirection m_enDirection;

public:
    tclCallHistoryItem(unsigned int arg_uContactHandle,
                       std::string arg_sPhoneNum,
                       std::string arg_sStartTime,
                       ApTelephonyCallDirection arg_enDirection);

    tclCallHistoryItem();

    ~tclCallHistoryItem();

    void vUpdateCallHistoryItem(unsigned int arg_uContactHandle,
                                std::string arg_sPhoneNum,
                                std::string arg_sStartTime,
                                ApTelephonyCallDirection arg_enDirection);

    unsigned int uGetContactHandle();

    std::string sGetPhoneNumber();

    std::string sStartTime();

    ApTelephonyCallDirection eGetCallDirection();

};

void vSendGetCallHistorySliceDataHandler(std::vector<tclCallHistoryItem>
                                         arg_callHistoryList);

#endif //_PHONE_DATA_HANDLER_H