/*******************************************************************************
*
* FILE:          FC_Gateway_MessageClientHandler.h
* SW-COMPONENT:
* PROJECT:
* DESCRIPTION:   CCA client-handler for Message
* History : 
* Date			|  Name 						|	Description
* 20-07-2016	|  Ashwini Savadi RBEI/ECO22  	|	Added changes for CreateMessage, 
*													ProvideMessageHeader, 
*													ProvideMessageBody, SendMessage
*******************************************************************************/

#ifndef _FC_GATEWAY_MESSAGECLIENTHANDLER_H_
#define _FC_GATEWAY_MESSAGECLIENTHANDLER_H_

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/*SMS*/
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_SERVICEINFO

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

#include "conn_most_fi_if.h"
#include "etrace_if.h"

#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "FC_Gateway_BluetoothClientHandler.h"


#ifdef __cplusplus
extern "C"
{
#endif
#include "PhoneDBusHandler.h"
#ifdef __cplusplus
}
#endif

class ahl_tclBaseOneThreadClientHandler;
class procgenericgateway_tclMainApp;


class fc_gateway_tcl_messageclienthandler  : public
        ahl_tclBaseOneThreadClientHandler
{
public:
    //copy constructor
    fc_gateway_tcl_messageclienthandler(procgenericgateway_tclMainApp*
                                        poMainAppl);
    //destructor
    virtual ~fc_gateway_tcl_messageclienthandler();
    // Overriding ahl_tclBaseOneThreadClientHandler methods.
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    virtual tBool sendCreateMessageMStart(
            tU8 u8CreateMessageHandle,
            most_fi_tcl_MsgMessageHandle oMessageHandle,
            most_fi_tcl_e8_MsgMessageType e8MessageType,
            most_fi_tcl_e8_MsgCreateMessageType e8CreateMessageType);

    virtual tBool sendProvideMessageHeaderMStart(
            tU8 u8CreateMessageHandle,
            most_fi_tcl_String sSubject,
            most_fi_tcl_MsgAddressFieldItem oAddressFieldItem);

    virtual tBool sendProvideMessageBodyMStart(tU8 u8CreateMessageHandle);

    virtual tBool SendMessageMStart(tU8 u8CreateMessageHandle,
                                    most_fi_tcl_e8_MsgFolderType e8FolderType);

    virtual tBool sendGetMessageMStart(uint16_t u16DeviceHandle,
                                       uint16_t u16MessageID,
                                       uint16_t u16ListID);

    virtual tBool CreateMessageListMStart(
            tU8 u8CreateMessageHandle,
            most_fi_tcl_e8_MsgFolderType e8FolderType);

    virtual tBool RequestSliceMessageListMStart(tU16 u16ListHandle,
                                                tU32 iWindowStart,
                                                tU32 iWindowSize,
                                                tU16 u16CmdCntr);

    static fc_gateway_tcl_messageclienthandler*
    getInstance(procgenericgateway_tclMainApp* poMainAppl);

    static fc_gateway_tcl_messageclienthandler*
    m_pofc_gateway_tcl_messageclienthandler;

    tVoid vCreateMessageMethod(const char *poPhoneNumber,
                               const char *poTextMessage);

    tVoid       vSetPhoneNumber(const char* phoneNum);
    std::string chGetPhoneNumber();

    tVoid       vSetMessageText(const char* messageText);
    std::string chGetMessageText();

    bool        bIsServiceAvailable();

    fc_gateway_tcl_bluetoothclienthandler* m_pBTDeviceManager;
    fc_gateway_tcl_bluetoothclienthandler* poGetBTDeviceManagerPtr();

    tVoid vConvertCCADSToGateway(
            most_msgfi_tclMsgGetMessageMethodResult&
            l_most_msgfi_tclMsgGetMessageMethodResult,
            SMSData& l_SMSData);

    std::string ConvertCCADateTimeToString(most_fi_tcl_MsgMessageDateTime
                                           l_most_fi_tcl_MsgMessageDateTime);

    tVoid vTriggerSMSSignal(
            SMSData arg_SMSData, std::string strPhnNum,
            most_fi_tcl_e8_MsgNotificationType oNotificationType);

    /* Message map definition macro */
    DECLARE_MSG_MAP(fc_gateway_tcl_messageclienthandler);

private:

    most_fi_tcl_String m_oMsgSubject;
    bool m_bIsServiceAvailable;
    bool m_bIsMessageNotification;

    //Result
    virtual tVoid vHandleCreateMessageOpMResult(amt_tclServiceData* poMessage);

    virtual tVoid vHandleProvideMessageHeaderOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleProvideMessageBodyOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleSendMessageOpMResult(amt_tclServiceData* poMessage);

    virtual tVoid vHandleMessageNotificationOpStatus(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleGetMessageOpMResult(amt_tclServiceData* poMessage);

    virtual tVoid vHandleCreateMessageListOpMResult(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleRequestSliceMessageListOpMResult(
            amt_tclServiceData* poMessage);

    //Error
    virtual tVoid vHandleCreateMessageOpMError(amt_tclServiceData* poMessage);

    virtual tVoid vHandleProvideMessageHeaderOpMError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleProvideMessageBodyOpMError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleSendMessageOpMError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleMessageNotificationOpError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleGetMessageOpMError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleCreateMessageListOpMError(
            amt_tclServiceData* poMessage);

    virtual tVoid vHandleRequestSliceMessageListOpMError(
            amt_tclServiceData* poMessage);

    // on reply from components.
    virtual tVoid onCreateMessageMResult(tU8 u8CreateMessageHandle);

    virtual tVoid onProvideMessageHeaderMResult(tU8 u8CreateMessageHandle);

    virtual tVoid onProvideMessageBodyMResult(tU8 u8CreateMessageHandle);

    //member variable
    std::string m_PhoneNumber;
    std::string m_MessageText;
    tU32 m_tu32lastMessageHandle;
};

#ifdef __cplusplus
extern "C" {
#endif

void vCreateMessageMethod(const char *poPhoneNumber, const char *poTextMessage);

#ifdef __cplusplus
}
#endif

#endif