/******************************************************************************
*
* FILE:          PhoneDataTypes.h
*
* PROJECT:       FC_GENERIC_GATEWAY
*
* DESCRIPTION:   Phone data types and enums are defined 
*
* AUTHOR:        KRJ5KOR(RBEI/ECO2)
*
* COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
*
******************************************************************************/
#ifndef _FC_GATEWAY_PHONEDATATYPES_H_
#define _FC_GATEWAY_PHONEDATATYPES_H_

#include <stdbool.h>
#include "ap-telephony-manager-enums.h"

/***********************************PHONE : DataTypes**************************************/
typedef struct
{
    unsigned int         u16CallInstance;
    unsigned int         u8CallDurationHr;
    unsigned int         u8CallDurationMin;
    unsigned int         u8CallDurationSec;
    bool                 bIsVehicleAudio;
    ApTelephonyCallState enCallStatus;
    unsigned int         u8DeviceHandle;
    char*                pPhoneNum;
} btphn_callStatus;

typedef struct
{
    char** contactNameArray;
    unsigned short ui_PhoneNumberCount;
    char** phoneNumberArray;
    unsigned short ui_EmailAddressCount;
    char** emailAddressArray;
    char* strContactHandle;
} ContactInfo;

/**
 * @brief Structure for CallHistoryInfo
 * @var sRemoteParty
 * @var sStartTime
 * @var uDirection
 * @var iContactHandle
 *
 * structure defining CallHistoryInfo
 */
typedef struct
{
    char* sRemoteParty;
    char* sStartTime;
    unsigned char uDirection;
    int iContactHandle;
} CallHistoryInfo;

/***********************************BT : DataTypes*****************************/
typedef struct
{
    unsigned int u8DeviceHandle;
    bool bDeviceConnectedStatus;
    bool bOSDStatus;
} btphn_trBTPairedDeviceInfo;

/***********************************ERR HANDLING : DataTypes*******************/
enum _MessagingError
{
    CREATE_MESSAGE_ERR = 0,
    MESSAGE_HEADER_ERR,
    MESSAGE_BODY_ERR,
    SEND_MESSAGE_ERR,
    BT_SERVICE_UNAVAILABLE,
    MESSAGE_SERVICE_UNAVAILABLE,
    BT_DEVICE_LIST_UPDATE_ERROR
};
typedef enum _MessagingError MessagingError;

/***********************************ERR HANDLING : DataTypes*******************/

void vCleanContactInfoData(ContactInfo *arg_ContactInfoData);
void vCleanCallHistoryData(CallHistoryInfo *arg_CallHistoryData);

#endif
