/******************************************************************************
 *
 * FILE:          PhoneDBusHandler.h
 *
 * PROJECT:       FC_GENERIC_GATEWAY
 *
 * DESCRIPTION:   DBus server for Phone
 *
 * AUTHOR:        KRJ5KOR(RBEI/ECO2)
 *
 * COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
 *
 *****************************************************************************/

#ifndef PHONE_DBUS_METHOD_HANDLER_IF_H
#define PHONE_DBUS_METHOD_HANDLER_IF_H

#include <stdio.h>
#include <glib.h>
#include <gio/gio.h>

#include "TelephonyManager_generated.h"
#include "ContactManager_generated.h"
#include "PhoneDataTypes.h"
#include "MessageDataTypes.h"
#include "ap-telephony-manager-enums.h"
#include "ap-telephony-error-enums.h"

gboolean
handle_prepare_call_history_list (CallManager *object,
                                  GDBusMethodInvocation *invocation,
                                  GVariant *arg_options,
                                  gpointer user_data);

gboolean
handle_get_call_history_in_slice (CallManager *object,
                                  GDBusMethodInvocation *invocation,
                                  GVariant *arg_options,
                                  gint arg_handle,
                                  gpointer user_data);



gboolean 
handle_get_contacts_in_slice (ContactManager *object,
                              GDBusMethodInvocation *invocation,
                              GVariant *arg_options,
                              gint arg_handle);



gboolean 
handle_prepare_contact_list (ContactManager *object,
                             GDBusMethodInvocation *invocation,
                             GVariant *arg_options);

gboolean
handle_hangup_call (CallManager *object,
                    GDBusMethodInvocation *invocation,
                    unsigned int callinstance);

void vSendOnCallStateChangeSignal(btphn_callStatus l_callStatus);



gboolean handle_get_message_list_in_slice(
        SmsManager *object,
        GDBusMethodInvocation *invocation,
        GVariant *arg_options,
        guint16 arg_handle);

gboolean handle_prepare_get_messages_list(
        SmsManager *object,
        GDBusMethodInvocation *invocation,
        guint16 arg_device_handle,
        GVariant *arg_options);


/**
@brief     vTriggerOnSMSReceivedSignal
@param     SMSData
@return    void
*/
void vTriggerOnSMSReceivedSignal(SMSData l_SMSData);

/**
@brief     vTriggerOnDeliverySuccessSignal
@param     SMSData
@return    void
*/
void vTriggerOnDeliverySuccessSignal(SMSData l_SMSData);

/**
@brief     vTriggerOnDeliveryFailureSignal
@param     SMSData
@return    void
*/
void vTriggerOnDeliveryFailureSignal(SMSData l_SMSData);

/**
@brief     vTriggerOnSentSuccessSignal
@param     SMSData
@return    void
*/
void vTriggerOnSentSuccessSignal(SMSData l_SMSData);

#endif //PHONE_DBUS_METHOD_HANDLER_IF_H
