/*****************************************************************************
* FILE:         FC_Gateway_MediaPlayerClientHandler.h
* PROJECT:      G3G project
* SW-COMPONENT: Generic Gateway
* DESCRIPTION:  MediaPlayer client handlers for the gateway           
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef _FC_GATEWAY_MEDIAPLAYER_CLIENT_HANDLER_
#define _FC_GATEWAY_MEDIAPLAYER_CLIENT_HANDLER_

#include "Utility.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_DBGVISITORS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_ERRORCODES
//#define MPLAY_FI_S_ALREADY_INCLUDE_MPLAY_DEVICEMANAGERFI_ERRORCODES
//#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include "etrace_if.h"
#include "ahl_BaseOneThreadClienthandler.h"
#include "procgenericgateway_tclMainApp.h"
#include "mplay_fi_if.h"

#include <string.h>

#ifdef __cplusplus
extern "C"
{
#endif
#include "DBusToMPlayProxyWrapper.h"
#include "ap-media-player-enums.h"
#ifdef __cplusplus
}
#endif

enum lastPlaybackAction
{
   kPlay=0,
   kPause,
   kStop,
   kNext,
   kPrev
};

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class procgenericgateway_tclMainApp;
class ahl_tclBaseOneThreadClientHandler;

class FC_Gateway_MediaPlayerClientHandler : public ahl_tclBaseOneThreadClientHandler
{
private:
   //gateway_tclClientMediaplayerCallbackIF* _poCallbackIf;
	procgenericgateway_tclMainApp *m_poMainApp;
public:
   virtual const tChar* getName() const { 
            return "FC_Gateway_MediaPlayerClientHandler"; };

   FC_Gateway_MediaPlayerClientHandler(tVoid); 

   /* parameterized constructor*/
   FC_Gateway_MediaPlayerClientHandler(procgenericgateway_tclMainApp* 
                                      poMainAppl);
   /*destructor*/
   virtual ~FC_Gateway_MediaPlayerClientHandler();

   static FC_Gateway_MediaPlayerClientHandler* getInstance(
                              procgenericgateway_tclMainApp* poMainAppl);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'gateway_tclClientMediaplayer' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   FC_Gateway_MediaPlayerClientHandler& operator = 
              (const FC_Gateway_MediaPlayerClientHandler &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();

   tVoid vRegisterPropertyOnStartup();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
	tBool sendRequestPlaybackActionMStart(
	            mplay_fi_tcl_e8_MPlayAction e8Action, tU8 u8NextPrevSkipCount);
	tBool sendSeekToMStart(tU32 u32PlaypointPosition,
            	mplay_fi_tcl_e8_MPlayPlaypointFormat e8PlaypointFormat);
	tBool getCurrentPlayingTrack();

	tBool sendPlaybackModeSet(mplay_fi_tcl_e8_MPlayMode e8Mode);
	tBool sendRepeatModeSet(mplay_fi_tcl_e8_MPlayRepeat e8Repeat);

	tBool sendPlaytimeGet();
	tBool sendPlaybackStateGet();
	tBool sendPlaybackModeGet();
	tBool sendRepeatModeGet();
	tBool sendCurrentFolderPathGet();
	tVoid vNotifyTrackState(
	             mplay_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState,
				 tU16 u16TrackId 
				           );

	void vHandlePlayOpMError(int arg_errorCode);
	void vHandlePauseOpMError(int arg_errorCode);
	void vHandleStopOpMError(int arg_errorCode);
	void vHandleNextOpMError(int arg_errorCode);
	void vHandlePrevOpMError(int arg_errorCode);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
	tVoid vHandleRequestPlaybackActionOpMResult(amt_tclServiceData* poMessage);
	tVoid vHandleSeekToOpMResult(amt_tclServiceData* poMessage);

	tVoid onRequestPlaybackActionMResult();
	tVoid onSeekToMResult();

	tVoid vHandlePlaytimeOpStatus(amt_tclServiceData* poMessage);
	tVoid vHandlePlaybackStateOpStatus(amt_tclServiceData* poMessage);
	tVoid vHandlePlaybackModeOpStatus(amt_tclServiceData* poMessage);
	tVoid vHandleRepeatModeOpStatus(amt_tclServiceData* poMessage);
    tVoid vHandlePlaybackRepeatModeOpStatus(amt_tclServiceData* poMessage);
	tVoid vHandleNowPlayingOpStatus(amt_tclServiceData* poMessage);
	tVoid vHandleCurrentFolderPathOpStatus(amt_tclServiceData* poMessage);

	tVoid onPlaytimeStatus(tU32 u32ElapsedPlaytime, tU32 u32TotalPlaytime);
	tVoid onPlaybackStateStatus(mplay_fi_tcl_e8_MPlayState e8State);
	tVoid onPlaybackModeStatus(mplay_fi_tcl_e8_MPlayMode e8Mode);
	tVoid onRepeatModeStatus(mplay_fi_tcl_e8_MPlayRepeat e8Repeat);
    tVoid onPlaybackRepeatModeStatus(
	        mplay_fi_tcl_e8_MPlayMode e8Mode,
			mplay_fi_tcl_e8_MPlayRepeat e8Repeat);
	tVoid onNowPlayingStatus(
	                                          tU32 u32ListHandle,
         mplay_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState, 
	                                    	  tU32 u32Position, 
		                                      tU32 u32Tag,
		             mplay_fi_tcl_MPlayMediaObject* oMediaObject );
	tVoid onCurrentFolderPathStatus( mplay_fi_tclString sCurrentFolderPath,
                                	 tU32               u32ListHandle );

	tVoid vHandleRequestPlaybackActionOpMError(amt_tclServiceData* poMessage);
	tVoid vHandleSeekToOpMError(amt_tclServiceData* poMessage);
	tVoid vHandlePlaytimeOpMError(amt_tclServiceData* poMessage);
	tVoid vHandlePlaybackStateOpMError(amt_tclServiceData* poMessage);
    tVoid vHandlePlaybackModeOpMError(amt_tclServiceData* poMessage);
	tVoid vHandleRepeatModeOpMError(amt_tclServiceData* poMessage);

private:

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(FC_Gateway_MediaPlayerClientHandler)

   static FC_Gateway_MediaPlayerClientHandler*
                         m_poFC_Gateway_MediaPlayerClientHandler;

   	/* Stores the last Playback action */
	lastPlaybackAction m_lastPlaybackAction;

};


#endif //_FC_GATEWAY_MEDIAPLAYER_CLIENT_HANDLER_
#endif
