/******************************************************************
*FILE:  ManAppsListHandler.h
*SW-COMPONENT: Internet
*DESCRIPTION: Header for ManAppsListHandler
*             
*COPYRIGHT: © 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

 #ifndef __AP_MANAPPS_LIST_HANDLER_H__
 #define __AP_MANAPPS_LIST_HANDLER_H__

 #include "ManagedAppService_generated.h"
 #include <gio/gio.h>
 #include <glib.h>
 
 /******************************************************************************
 * Function:    bStartManAppService
 * Description: Starts the ManApps Service
 * Parameters:  void
 * Return:      gboolean
 *****************************************************************************/
 gboolean bStartManAppService();

 /******************************************************************************
 * Function:    vStopManAppService
 * Description: Stops the ManApps Service
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
 void vStopManAppService();

/****************************************************************************
 * Function:    poGetManAppServiceProxyObj
 * Description: Gives the ManagedApp proxy object
 * Parameters:  void
 * Returns:     ManagedAppService*
 *****************************************************************************/
 ManagedAppService* poGetManAppServiceProxyObj();

 /*****************************************************************************
 * Function:    vManAppNameAppeared
 * Description: Call back for ManApp service appeared
 * Parameters:  connection, bus name, 
                owner name, user_name
 * Returns:     void
 *****************************************************************************/
 void vManAppNameAppeared( GDBusConnection *connection, 
                           const gchar     *name,
                           const gchar     *name_owner, 
                           gpointer         user_data );

 /****************************************************************************
 * Function:    vManAppNameVanished
 * Description: Name disappeared call back for ManApp Servcie
 * Parameters:  connection, service_name, user_data
 * Return:      void
 *****************************************************************************/
 void vManAppNameVanished( GDBusConnection *connection, 
                           const gchar     *service_name,
                           gpointer        user_data );

 /******************************************************************
 * Function:     vManAppProxyCB
 * Description:  Call back for ManApp proxy
 * Parameters:   object, result, user_data
 * Return:       void
 ******************************************************************/
 void vManAppProxyCB( GObject      *object, 
                      GAsyncResult *result,
                      gpointer     user_data );

 /****************************************************************************
 * Function:    vExportManagedAppGW
 * Description: Exports gateway Managed app interface
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
 void vExportManagedAppGW();

 /*****************************************************************************
 * Function:    vHandleManAppPropertyChange
 * Description: Call back for Manapps properties change
 * Parameters:  Proxy, changed properties,
                invalidated properties, user_data
 * Returns:     void
 ******************************************************************************/
 void  vHandleManAppPropertyChange( GDBusProxy          *proxy,
	                                GVariant            *changed_properties,
	                                const gchar* const  *invalidated_properties,
	                                gpointer            user_data );

 /*****************************************************************************
 * Function:    vUpdateApplications
 * Description: Updates the latest value of Applications
 * Parameters:  void
 * Returns:     void
 ******************************************************************************/
 void vUpdateApplications();

 #endif
