/*!
********************************************************************************
* @file             : ECM_ClientInterface.h
********************************************************************************
*  - PROJECT:       : Header exposed to the ECM Client Handler Plugin
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Declares interfaces between Gateway and ECM Client plugin
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : -
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|------------------------
*22.6.2017 | IPD5KOR(RBEI/ECO2) | 1.0.0 | Dbus client impl. to connect to ECM
*******************************************************************************/

#ifndef ECM_CLIENTINTERFACE_H
#define ECM_CLIENTINTERFACE_H


/******************************************************************************
 * Function:      bCheckCertificate
 * Description:   Function to check the certificate
 * Parameters:    certBuffer, certSize, user_data
 * Return:        gboolean
 *****************************************************************************/
gboolean bCheckCertificate(GVariant* certBuffer,
                           guint32      certSize,
                           gpointer user_data);

/******************************************************************************
 * Function:      bPushCertificate
 * Description:   Function to Push Ceritificate
 * Parameters:    certBuffer , certSize, user_data
 * Return:        gboolean
 *****************************************************************************/

gboolean bPushCertificate( GVariant* certBuffer,
                           guint32 certSize, 
                           gpointer user_data );


/******************************************************************************
 * Function:      bPushCrl
 * Description:   Function to Push Crl
 * Parameters:    certBuffer , certSize, user_data
 * Return:        gboolean
 *****************************************************************************/
gboolean bPushCrl ( GVariant*  certBuffer,
                    guint32   certSize,
                    gpointer user_data );

/******************************************************************************
 * Function:      bGetCrlNextUpd
 * Description:   Function to get next crl update
 * Parameters:    identifier, user_data
 * Return:        gboolean
 *****************************************************************************/
gboolean bGetCrlNextUpd (gchar* identifier, 
                         gpointer user_data );


/*******************************************************************************
 * Function:    ecm_service_watch
 * Description: This methods intiates the watch for ECM service
 * Parameters:  void
 * Return:      gboolean
 ******************************************************************************/
gboolean ecm_service_watch();

/*******************************************************************************
 * Function:    ecm_service_unwatch
 * Description: This methods uninitializes the ECM service
 * Parameters:  void
 * Return:      void
 ******************************************************************************/
void ecm_service_unwatch();

/********************   Callbacks to Gateway  ********************************/

/******************************************************************************
* Function:    send_push_cert_result
* Description: This function handles the result of 'handle_push_certificate'
* Parameters:  result->0 indicates success & 1 indicates failure
*              error, errorDesc, user_data
* Return:      void
*****************************************************************************/
void
send_push_cert_result(guint16 result,
                      gboolean error,
                      gchar* errorDesc,
                      gpointer user_data);

/******************************************************************************
* Function:    send_push_crl_result
* Description: Handler to send the response for 'handle_push_crl_result'
* Parameters:  result - 0 indicates success and 1 indicates failure
*              error, errorDesc, user_data
* Return:      void
*****************************************************************************/
void
send_push_crl_result(guint16 result,
                     gboolean error,
                     gchar* errorDesc,
                     gpointer user_data);

/******************************************************************************
* Function:    send_get_crl_validity_result
* Description: Sends the result of handle_get_crlvalidity
* Parameters:  result - 0 indicates success and 1 indicates failure,
*              validity, error, errorDesc, user_data
* Return:      void
*****************************************************************************/
void
send_get_crl_validity_result( guint16 result,
                         guint64  validity,
                         gboolean error,
                         gchar* errorDesc,
                         gpointer user_data);

/******************************************************************************
* Function:    send_check_cert_result
* Description: Sends the result of handle_check_cert
* Parameters:  certValidity, error, errorDesc, user_data
* Return:      void
*****************************************************************************/
void
send_check_cert_result ( guint16 certValidity,
                         gboolean error,
                         gchar* errorDesc,
                         gpointer user_data );
						 
/******************************************************************************
* Function:    getECMClientProxy
* Description: This method provides the ECM client proxy object 
* Parameters:  None
* Return:      GDBusProxy*
*******************************************************************************/
GDBusProxy* getECMClientProxy();


/*******************************************************************************
 * Function:     vExportAGWECMInterface
 * Description:  This method exposes the gateway ECM methods
 * Parameters:   void
 * Return:       void
 ******************************************************************************/
void vExportAGWECMInterface();

/*******************************************************************************
 * Function:     vUnexportAGWECMInterface
 * Description:  This method unexposes the gateway ECM methods
 * Parameters:   void
 * Return:       void
 ******************************************************************************/
void vUnexportAGWECMInterface();

#endif //ECM_CLIENTINTERFACE_H
